/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.launch;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.zip.ZipError;
import net.fabricmc.loader.impl.launch.FabricLauncherBase;
import net.fabricmc.loader.impl.util.ManifestUtil;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.fabricmc.mapping.tree.TinyMappingFactory;
import net.fabricmc.mapping.tree.TinyTree;

public final class MappingConfiguration {
    private boolean initialized;
    private String gameId;
    private String gameVersion;
    private TinyTree mappings;

    public String getGameId() {
        this.initialize();
        return this.gameId;
    }

    public String getGameVersion() {
        this.initialize();
        return this.gameVersion;
    }

    public boolean matches(String gameId, String gameVersion) {
        this.initialize();
        return !(this.gameId != null && gameId != null && !gameId.equals(this.gameId) || this.gameVersion != null && gameVersion != null && !gameVersion.equals(this.gameVersion));
    }

    public TinyTree getMappings() {
        this.initialize();
        return this.mappings;
    }

    public String getTargetNamespace() {
        return FabricLauncherBase.getLauncher().isDevelopment() ? "named" : "intermediary";
    }

    public boolean requiresPackageAccessHack() {
        return this.getTargetNamespace().equals("named");
    }

    private void initialize() {
        if (this.initialized) {
            return;
        }
        URL url = MappingConfiguration.class.getClassLoader().getResource("mappings/mappings.tiny");
        if (url != null) {
            try {
                Manifest manifest;
                URLConnection connection = url.openConnection();
                if (connection instanceof JarURLConnection && (manifest = ((JarURLConnection)connection).getManifest()) != null) {
                    this.gameId = ManifestUtil.getManifestValue(manifest, new Attributes.Name("Game-Id"));
                    this.gameVersion = ManifestUtil.getManifestValue(manifest, new Attributes.Name("Game-Version"));
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                    long time = System.currentTimeMillis();
                    this.mappings = TinyMappingFactory.loadWithDetection((BufferedReader)reader);
                    Log.debug(LogCategory.MAPPINGS, "Loading mappings took %d ms", System.currentTimeMillis() - time);
                }
            }
            catch (IOException | ZipError e) {
                throw new RuntimeException("Error reading " + url, e);
            }
        }
        if (this.mappings == null) {
            Log.info(LogCategory.MAPPINGS, "Mappings not present!");
            this.mappings = TinyMappingFactory.EMPTY_TREE;
        }
        this.initialized = true;
    }
}

