/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.block.entity;

import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.tom.createores.CreateOreExcavation;
import com.tom.createores.block.entity.ExcavatingBlockEntityImpl;
import com.tom.createores.recipe.DrillingRecipe;
import com.tom.createores.util.IOBlockType;
import com.tom.createores.util.QueueInventory;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3956;

public class DrillBlockEntity
extends ExcavatingBlockEntityImpl<DrillingRecipe> {
    private QueueInventory inventory = new QueueInventory();

    public DrillBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public <T> Storage<T> getCaps(IOBlockType type) {
        if (type == IOBlockType.ITEM_OUT) {
            return this.inventory;
        }
        if (type == IOBlockType.FLUID_IN) {
            return this.fluidTank;
        }
        return null;
    }

    @Override
    protected void read(class_2487 tag, boolean clientPacket) {
        super.read(tag, clientPacket);
        if (!clientPacket) {
            this.inventory.load(tag.method_10554("inv", 10));
        }
    }

    @Override
    protected void write(class_2487 tag, boolean clientPacket) {
        super.write(tag, clientPacket);
        if (!clientPacket) {
            tag.method_10566("inv", (class_2520)this.inventory.toTag());
        }
    }

    @Override
    public void dropInv() {
        super.dropInv();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            this.dropItemStack(this.inventory.getStackInSlot(i));
        }
    }

    @Override
    protected boolean canExtract() {
        return this.inventory.hasSpace() && super.canExtract();
    }

    @Override
    protected void onFinished() {
        ((DrillingRecipe)this.current).getOutput().stream().map(ProcessingOutput::rollOutput).filter(i -> !i.method_7960()).forEach(this.inventory::add);
        super.onFinished();
    }

    @Override
    protected class_3956<DrillingRecipe> getRecipeType() {
        return CreateOreExcavation.DRILLING_RECIPES.getRecipeType();
    }
}

