/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.blocks.portable_energy_interface;

import com.jozufozu.flywheel.api.InstanceData;
import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.api.instance.TickableInstance;
import com.jozufozu.flywheel.backend.instancing.blockentity.BlockEntityInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.model.ModelData;
import com.jozufozu.flywheel.util.AnimationTickHolder;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlock;
import com.mrh0.createaddition.blocks.portable_energy_interface.PortableEnergyInterfaceBlockEntity;
import com.mrh0.createaddition.index.CAPartials;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;

public class PortableEnergyInterfaceInstance
extends BlockEntityInstance<PortableEnergyInterfaceBlockEntity>
implements DynamicInstance,
TickableInstance {
    private final PIInstance instance;

    public PortableEnergyInterfaceInstance(MaterialManager materialManager, PortableEnergyInterfaceBlockEntity tile) {
        super(materialManager, (class_2586)tile);
        this.instance = new PIInstance(materialManager, this.blockState, this.getInstancePosition());
    }

    public void init() {
        this.instance.init(this.isLit());
    }

    public void tick() {
        this.instance.tick(this.isLit());
    }

    public void beginFrame() {
        this.instance.beginFrame(((PortableEnergyInterfaceBlockEntity)this.blockEntity).getExtensionDistance(AnimationTickHolder.getPartialTicks()));
    }

    public void updateLight() {
        this.relight(this.pos, new FlatLit[]{this.instance.middle, this.instance.top});
    }

    public void remove() {
        this.instance.remove();
    }

    private boolean isLit() {
        return ((PortableEnergyInterfaceBlockEntity)this.blockEntity).isConnected();
    }

    public static class PIInstance {
        private final MaterialManager materialManager;
        private final class_2680 blockState;
        private final class_2338 instancePos;
        private final float angleX;
        private final float angleY;
        private boolean lit;
        ModelData middle;
        ModelData top;

        public PIInstance(MaterialManager materialManager, class_2680 blockState, class_2338 instancePos) {
            this.materialManager = materialManager;
            this.blockState = blockState;
            this.instancePos = instancePos;
            class_2350 facing = (class_2350)blockState.method_11654((class_2769)PortableEnergyInterfaceBlock.field_10927);
            this.angleX = facing == class_2350.field_11036 ? 0.0f : (facing == class_2350.field_11033 ? 180.0f : 90.0f);
            this.angleY = AngleHelper.horizontalAngle((class_2350)facing);
        }

        public void init(boolean lit) {
            this.lit = lit;
            PartialModel middleForState = lit ? CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE_POWERED : CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE;
            this.middle = (ModelData)this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(middleForState, this.blockState).createInstance();
            this.top = (ModelData)this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(CAPartials.PORTABLE_ENERGY_INTERFACE_TOP, this.blockState).createInstance();
        }

        public void beginFrame(float progress) {
            ((ModelData)((ModelData)((ModelData)((ModelData)this.middle.loadIdentity().translate((class_2382)this.instancePos)).centre()).rotateY((double)this.angleY)).rotateX((double)this.angleX)).unCentre();
            ((ModelData)((ModelData)((ModelData)((ModelData)this.top.loadIdentity().translate((class_2382)this.instancePos)).centre()).rotateY((double)this.angleY)).rotateX((double)this.angleX)).unCentre();
            this.middle.translate(0.0, (double)(progress * 0.5f + 0.375f), 0.0);
            this.top.translate(0.0, (double)progress, 0.0);
        }

        public void tick(boolean lit) {
            if (this.lit != lit) {
                this.lit = lit;
                PartialModel middleForState = lit ? CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE_POWERED : CAPartials.PORTABLE_ENERGY_INTERFACE_MIDDLE;
                this.materialManager.defaultSolid().material(Materials.TRANSFORMED).getModel(middleForState, this.blockState).stealInstance((InstanceData)this.middle);
            }
        }

        public void remove() {
            this.middle.delete();
            this.top.delete();
        }
    }
}

