/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.utils;

import earth.terrarium.adastra.common.blockentities.base.ContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.utils.ItemUtils;
import earth.terrarium.adastra.common.utils.ModUtils;
import earth.terrarium.botarium.common.energy.EnergyApi;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.fluid.FluidApi;
import earth.terrarium.botarium.common.fluid.base.FluidContainer;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.impl.WrappedBlockFluidContainer;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1263;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2614;
import net.minecraft.class_3611;

public class TransferUtils {
    public static void pushEnergyNearby(ContainerMachineBlockEntity machine, class_2338 pos, long amount, ConfigurationEntry sideConfig, Predicate<class_2350> filter) {
        EnergyContainer container = EnergyContainer.of((class_2586)machine, null);
        if (container == null) {
            return;
        }
        if (container.getStoredEnergy() == 0L) {
            return;
        }
        for (Map.Entry<class_2350, Configuration> entry : sideConfig.sides().entrySet()) {
            EnergyContainer nearbyContainer;
            class_2586 nearbyEntity;
            class_2350 direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPush() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyEntity = machine.level().method_8321(pos.method_10093(direction))) == null || (nearbyContainer = EnergyContainer.of((class_2586)nearbyEntity, (class_2350)direction.method_10153())) == null) continue;
            EnergyApi.moveEnergy((EnergyContainer)container, (EnergyContainer)nearbyContainer, (long)amount, (boolean)false);
        }
    }

    public static void pullEnergyNearby(ContainerMachineBlockEntity machine, class_2338 pos, long amount, ConfigurationEntry sideConfig, Predicate<class_2350> filter) {
        EnergyContainer container = EnergyContainer.of((class_2586)machine, null);
        if (container == null) {
            return;
        }
        for (Map.Entry<class_2350, Configuration> entry : sideConfig.sides().entrySet()) {
            EnergyContainer nearbyContainer;
            class_2586 nearbyEntity;
            class_2350 direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPull() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyEntity = machine.level().method_8321(pos.method_10093(direction))) == null || (nearbyContainer = EnergyContainer.of((class_2586)nearbyEntity, (class_2350)direction.method_10153())) == null) continue;
            EnergyApi.moveEnergy((EnergyContainer)nearbyContainer, (EnergyContainer)container, (long)amount, (boolean)false);
        }
    }

    public static void pushFluidNearby(ContainerMachineBlockEntity machine, class_2338 pos, WrappedBlockFluidContainer container, long amount, int tank, ConfigurationEntry sideConfig, Predicate<class_2350> filter) {
        if (container.isEmpty()) {
            return;
        }
        for (Map.Entry<class_2350, Configuration> entry : sideConfig.sides().entrySet()) {
            FluidHolder holder;
            FluidContainer nearbyContainer;
            class_2586 nearbyEntity;
            class_2350 direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPush() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyEntity = machine.level().method_8321(pos.method_10093(direction))) == null || !FluidContainer.holdsFluid((class_2586)nearbyEntity, (class_2350)direction) || (nearbyContainer = FluidContainer.of((class_2586)nearbyEntity, (class_2350)direction.method_10153())) == null || (holder = (FluidHolder)container.getFluids().get(tank)).isEmpty() || FluidApi.moveFluid((FluidContainer)container, (FluidContainer)nearbyContainer, (FluidHolder)FluidHolder.ofMillibuckets((class_3611)holder.getFluid(), (long)amount), (boolean)false) <= 0L) continue;
            machine.sync();
        }
    }

    public static void pullFluidNearby(ContainerMachineBlockEntity machine, class_2338 pos, WrappedBlockFluidContainer container, long amount, int tank, ConfigurationEntry sideConfig, Predicate<class_2350> filter) {
        for (Map.Entry<class_2350, Configuration> entry : sideConfig.sides().entrySet()) {
            FluidHolder holder;
            FluidContainer nearbyContainer;
            class_2586 nearbyEntity;
            class_2350 direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPull() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyEntity = machine.level().method_8321(pos.method_10093(direction))) == null || !FluidContainer.holdsFluid((class_2586)nearbyEntity, (class_2350)direction) || (nearbyContainer = FluidContainer.of((class_2586)nearbyEntity, (class_2350)direction.method_10153())) == null || (holder = (FluidHolder)nearbyContainer.getFluids().get(tank)).isEmpty() || FluidApi.moveFluid((FluidContainer)nearbyContainer, (FluidContainer)container, (FluidHolder)FluidHolder.ofMillibuckets((class_3611)holder.getFluid(), (long)amount), (boolean)false) <= 0L) continue;
            machine.sync();
        }
    }

    public static void pushItemsNearby(ContainerMachineBlockEntity machine, class_2338 pos, int[] slots, ConfigurationEntry sideConfig, Predicate<class_2350> filter) {
        if (machine.method_5442()) {
            return;
        }
        for (Map.Entry<class_2350, Configuration> entry : sideConfig.sides().entrySet()) {
            class_1263 nearbyContainer;
            class_2350 direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPush() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyContainer = class_2614.method_11250((class_1937)machine.level(), (class_2338)pos.method_10093(direction))) == null) continue;
            ItemUtils.push(machine, nearbyContainer, slots, direction);
        }
    }

    public static void pullItemsNearby(ContainerMachineBlockEntity machine, class_2338 pos, int[] slots, ConfigurationEntry sideConfig, Predicate<class_2350> filter) {
        for (Map.Entry<class_2350, Configuration> entry : sideConfig.sides().entrySet()) {
            class_1263 nearbyContainer;
            class_2350 direction;
            Configuration configuration = entry.getValue();
            if (!configuration.canPull() || !filter.test(direction = ModUtils.relative(machine, entry.getKey())) || (nearbyContainer = class_2614.method_11250((class_1937)machine.level(), (class_2338)pos.method_10093(direction))) == null) continue;
            ItemUtils.pull(nearbyContainer, machine, slots, direction);
        }
    }
}

