/*
 * Decompiled with CFR 0.152.
 */
package appeng.api.inventories;

import appeng.api.inventories.InternalInventory;
import appeng.core.definitions.AEItems;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1799;
import org.jetbrains.annotations.Nullable;

class InternalInventoryStorage
extends SnapshotParticipant<Snapshot>
implements Storage<ItemVariant> {
    private final InternalInventory inventory;
    @Nullable
    private Snapshot lastReleasedSnapshot;

    public InternalInventoryStorage(InternalInventory inventory) {
        this.inventory = inventory;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        class_1799 stack = resource.toStack((int)Math.min(Integer.MAX_VALUE, maxAmount));
        this.updateSnapshots(transaction);
        class_1799 overflow = this.inventory.addItems(stack);
        return maxAmount - (long)overflow.method_7947();
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        if (resource.getItem() == AEItems.WRAPPED_GENERIC_STACK.method_8389()) {
            return 0L;
        }
        this.updateSnapshots(transaction);
        int amt = (int)Math.min(Integer.MAX_VALUE, maxAmount);
        class_1799 extracted = this.inventory.removeItems(amt, resource.toStack(), null);
        return extracted.method_7947();
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return new InventoryIterator();
    }

    protected Snapshot createSnapshot() {
        Snapshot snapshot;
        if (this.lastReleasedSnapshot != null && this.lastReleasedSnapshot.items.length == this.inventory.size()) {
            snapshot = this.lastReleasedSnapshot;
            this.lastReleasedSnapshot = null;
        } else {
            snapshot = new Snapshot();
        }
        for (int i = 0; i < this.inventory.size(); ++i) {
            class_1799 stack;
            snapshot.items[i] = stack = this.inventory.getStackInSlot(i);
            snapshot.counts[i] = stack.method_7947();
        }
        return snapshot;
    }

    protected void readSnapshot(Snapshot snapshot) {
        class_1799[] items = snapshot.items;
        int[] counts = snapshot.counts;
        for (int i = 0; i < items.length; ++i) {
            class_1799 stack = items[i];
            if (stack.method_7947() != counts[i]) {
                stack.method_7939(counts[i]);
            }
            this.inventory.setItemDirect(i, stack);
        }
    }

    protected void releaseSnapshot(Snapshot snapshot) {
        this.lastReleasedSnapshot = snapshot;
    }

    protected void onFinalCommit() {
        Preconditions.checkState((this.lastReleasedSnapshot != null ? 1 : 0) != 0, (Object)"There should have been at least one snapshot");
        for (int i = 0; i < this.lastReleasedSnapshot.items.length; ++i) {
            class_1799 current = this.inventory.getStackInSlot(i);
            if (current == this.lastReleasedSnapshot.items[i] && current.method_7947() == this.lastReleasedSnapshot.counts[i]) continue;
            this.inventory.sendChangeNotification(i);
        }
    }

    private class InventoryIterator
    implements Iterator<StorageView<ItemVariant>> {
        private int currentSlot = -1;

        private InventoryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.currentSlot + 1 < InternalInventoryStorage.this.inventory.size();
        }

        @Override
        public StorageView<ItemVariant> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.currentSlot;
            final int slot = this.currentSlot;
            return new StorageView<ItemVariant>(){

                public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
                    StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
                    if (resource.getItem() == AEItems.WRAPPED_GENERIC_STACK.method_8389()) {
                        return 0L;
                    }
                    InternalInventoryStorage.this.updateSnapshots(transaction);
                    return InternalInventoryStorage.this.inventory.extractItem(slot, (int)Math.min(Integer.MAX_VALUE, maxAmount), false).method_7947();
                }

                public boolean isResourceBlank() {
                    return InternalInventoryStorage.this.inventory.getStackInSlot(slot).method_7960();
                }

                public ItemVariant getResource() {
                    return ItemVariant.of((class_1799)InternalInventoryStorage.this.inventory.getStackInSlot(slot));
                }

                public long getAmount() {
                    return InternalInventoryStorage.this.inventory.getStackInSlot(slot).method_7947();
                }

                public long getCapacity() {
                    return InternalInventoryStorage.this.inventory.getSlotLimit(slot);
                }
            };
        }
    }

    public class Snapshot {
        class_1799[] items;
        int[] counts;

        public Snapshot() {
            this.items = new class_1799[InternalInventoryStorage.this.inventory.size()];
            this.counts = new int[InternalInventoryStorage.this.inventory.size()];
        }
    }
}

