/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.layout.flow;

import appeng.client.guidebook.document.DefaultStyles;
import appeng.client.guidebook.document.LytRect;
import appeng.client.guidebook.document.LytSize;
import appeng.client.guidebook.document.block.LytBlock;
import appeng.client.guidebook.document.flow.InlineBlockAlignment;
import appeng.client.guidebook.document.flow.LytFlowAnchor;
import appeng.client.guidebook.document.flow.LytFlowBreak;
import appeng.client.guidebook.document.flow.LytFlowContent;
import appeng.client.guidebook.document.flow.LytFlowInlineBlock;
import appeng.client.guidebook.document.flow.LytFlowText;
import appeng.client.guidebook.layout.LayoutContext;
import appeng.client.guidebook.layout.flow.Line;
import appeng.client.guidebook.layout.flow.LineBlock;
import appeng.client.guidebook.layout.flow.LineElement;
import appeng.client.guidebook.layout.flow.LineTextRun;
import appeng.client.guidebook.style.ResolvedTextStyle;
import appeng.client.guidebook.style.TextAlignment;
import java.lang.invoke.LambdaMetafactory;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

class LineBuilder
implements Consumer<LytFlowContent> {
    private final LayoutContext context;
    private final List<Line> lines;
    private final List<LineBlock> floats;
    private final int lineBoxX;
    private final int startY;
    private int innerX;
    private int lineBoxY;
    private final int lineBoxWidth;
    private int remainingLineWidth;
    @Nullable
    private LineElement openLineElement;
    private final TextAlignment alignment;

    public LineBuilder(LayoutContext context, int x, int y, int availableWidth, List<Line> lines, List<LineBlock> floats, TextAlignment alignment) {
        this.floats = floats;
        this.alignment = alignment;
        this.context = context;
        this.startY = y;
        this.lineBoxX = x;
        this.lineBoxY = y;
        this.lineBoxWidth = availableWidth;
        this.remainingLineWidth = this.getAvailableHorizontalSpace();
        this.lines = lines;
    }

    @Override
    public void accept(LytFlowContent content) {
        if (content instanceof LytFlowText) {
            LytFlowText text = (LytFlowText)content;
            this.appendText(text.getText(), content);
        } else if (content instanceof LytFlowBreak) {
            this.appendBreak(content);
        } else if (content instanceof LytFlowInlineBlock) {
            LytFlowInlineBlock inlineBlock = (LytFlowInlineBlock)content;
            this.appendInlineBlock(inlineBlock);
        } else if (content instanceof LytFlowAnchor) {
            LytFlowAnchor anchor = (LytFlowAnchor)content;
            anchor.setLayoutY(this.lineBoxY);
        } else {
            throw new IllegalArgumentException("Don't know how to layout flow content: " + content);
        }
    }

    private void appendBreak(@Nullable LytFlowContent flowContent) {
        LytFlowBreak flowBreak;
        if (this.openLineElement == null) {
            this.openLineElement = new LineTextRun("", DefaultStyles.BASE_STYLE, DefaultStyles.BASE_STYLE);
            this.openLineElement.flowContent = flowContent;
        }
        this.endLine();
        if (flowContent instanceof LytFlowBreak && ((flowBreak = (LytFlowBreak)flowContent).isClearLeft() || flowBreak.isClearRight())) {
            this.context.clearFloats(flowBreak.isClearLeft(), flowBreak.isClearRight()).ifPresent(floatBottom -> {
                this.lineBoxY = Math.max(this.lineBoxY, floatBottom);
            });
        }
    }

    private void appendInlineBlock(LytFlowInlineBlock inlineBlock) {
        LytSize size = inlineBlock.getPreferredSize(this.lineBoxWidth);
        LytBlock block = inlineBlock.getBlock();
        int marginLeft = block.getMarginLeft();
        int marginRight = block.getMarginRight();
        int marginTop = block.getMarginTop();
        int marginBottom = block.getMarginBottom();
        int outerWidth = size.width() + marginLeft + marginRight;
        this.ensureSpaceIsAvailable(outerWidth);
        LineBlock el = new LineBlock(block);
        el.bounds = new LytRect(this.innerX + marginLeft, marginTop, size.width(), size.height());
        el.flowContent = inlineBlock;
        if (inlineBlock.getAlignment() == InlineBlockAlignment.FLOAT_LEFT) {
            el.bounds = el.bounds.withX(this.getInnerLeftEdge() + marginLeft).withY(this.lineBoxY + marginTop);
            block.layout(this.context, el.bounds.x(), el.bounds.y(), size.width());
            el.floating = true;
            this.context.addLeftFloat(el.bounds.expand(0, 0, marginRight, marginBottom));
            this.floats.add(el);
            this.remainingLineWidth -= outerWidth;
        } else if (inlineBlock.getAlignment() == InlineBlockAlignment.FLOAT_RIGHT) {
            el.bounds = el.bounds.withX(this.getInnerRightEdge() - el.bounds.width() + marginRight).withY(this.lineBoxY + marginTop);
            block.layout(this.context, el.bounds.x(), el.bounds.y(), size.width());
            el.floating = true;
            this.context.addRightFloat(el.bounds.expand(marginLeft, 0, 0, marginBottom));
            this.floats.add(el);
            this.remainingLineWidth -= outerWidth;
        } else {
            this.innerX += size.width();
            this.appendToOpenLine(el);
            this.remainingLineWidth -= size.width();
        }
    }

    private void ensureSpaceIsAvailable(int width) {
        if (width <= this.remainingLineWidth) {
            return;
        }
        this.endLine();
        if (width <= this.remainingLineWidth) {
            return;
        }
        OptionalInt nextFloatEdge = this.context.getNextFloatBottomEdge(this.lineBoxY);
        while (nextFloatEdge.isPresent()) {
            this.lineBoxY = nextFloatEdge.getAsInt();
            this.context.clearFloatsAbove(this.lineBoxY);
            this.remainingLineWidth = this.getAvailableHorizontalSpace();
            if (width <= this.remainingLineWidth) break;
            nextFloatEdge = this.context.getNextFloatBottomEdge(this.lineBoxY);
        }
    }

    @Nullable
    private LineElement getEndOfOpenLine() {
        LineElement el = this.openLineElement;
        if (el != null) {
            while (el.next != null) {
                el = el.next;
            }
        }
        return el;
    }

    /*
     * Unable to fully structure code
     */
    private void appendText(String text, LytFlowContent flowContent) {
        style = flowContent.resolveStyle();
        hoverStyle = flowContent.resolveHoverStyle(style);
        lastChar = '\u0000';
        endOfOpenLine = this.getEndOfOpenLine();
        if (!(endOfOpenLine instanceof LineTextRun)) ** GOTO lbl-1000
        textRun = (LineTextRun)endOfOpenLine;
        if (!textRun.text.isEmpty()) {
            lastChar = textRun.text.charAt(textRun.text.length() - 1);
        } else if (endOfOpenLine == null || endOfOpenLine.floating) {
            lastChar = '\n';
        }
        this.iterateRuns(text, style, lastChar, (LineConsumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/CharSequence;FZ)V, lambda$appendText$1(appeng.client.guidebook.style.ResolvedTextStyle appeng.client.guidebook.style.ResolvedTextStyle appeng.client.guidebook.document.flow.LytFlowContent java.lang.CharSequence float boolean ), (Ljava/lang/CharSequence;FZ)V)((LineBuilder)this, (ResolvedTextStyle)style, (ResolvedTextStyle)hoverStyle, (LytFlowContent)flowContent));
    }

    private void iterateRuns(CharSequence text, ResolvedTextStyle style, char lastChar, LineConsumer consumer) {
        int lastBreakOpportunity = -1;
        float widthAtBreakOpportunity = 0.0f;
        float curLineWidth = 0.0f;
        float fontScale = style.fontScale();
        StringBuilder lineBuffer = new StringBuilder();
        boolean lastCharWasWhitespace = Character.isWhitespace(lastChar);
        if (lastCharWasWhitespace) {
            lastBreakOpportunity = 0;
        }
        for (int i = 0; i < text.length(); ++i) {
            char low;
            char ch = text.charAt(i);
            char codePoint = ch;
            if (Character.isHighSurrogate(ch) && i + 1 < text.length() && Character.isLowSurrogate(low = text.charAt(i + 1))) {
                ++i;
                codePoint = Character.toCodePoint(ch, low);
            }
            if (codePoint == '\n') {
                if (style.whiteSpace().isCollapseSegmentBreaks()) {
                    codePoint = ' ';
                } else {
                    consumer.visitRun(lineBuffer, curLineWidth, true);
                    lineBuffer.setLength(0);
                    curLineWidth = 0.0f;
                    widthAtBreakOpportunity = 0.0f;
                    lastBreakOpportunity = 0;
                    lastCharWasWhitespace = true;
                    this.remainingLineWidth = this.getAvailableHorizontalSpace();
                    continue;
                }
            }
            if (Character.isWhitespace((int)codePoint)) {
                if (lastCharWasWhitespace && style.whiteSpace().isCollapseWhitespace()) continue;
                lastBreakOpportunity = lineBuffer.length();
                widthAtBreakOpportunity = curLineWidth;
                lastCharWasWhitespace = true;
            } else {
                lastCharWasWhitespace = false;
            }
            float advance = this.context.getAdvance(codePoint, style) * fontScale;
            if (curLineWidth + advance > (float)this.remainingLineWidth) {
                if (lastBreakOpportunity != -1) {
                    consumer.visitRun(lineBuffer.subSequence(0, lastBreakOpportunity), widthAtBreakOpportunity, true);
                    curLineWidth -= widthAtBreakOpportunity;
                    lineBuffer.delete(0, lastBreakOpportunity);
                    if (!lineBuffer.isEmpty() && Character.isWhitespace(lineBuffer.charAt(0))) {
                        char firstChar = lineBuffer.charAt(0);
                        lineBuffer.deleteCharAt(0);
                        curLineWidth -= this.context.getAdvance(firstChar, style) * fontScale;
                    }
                } else {
                    consumer.visitRun(lineBuffer, curLineWidth, true);
                    lineBuffer.setLength(0);
                    curLineWidth = 0.0f;
                }
                lastBreakOpportunity = 0;
                widthAtBreakOpportunity = curLineWidth;
                this.remainingLineWidth = this.getAvailableHorizontalSpace();
                if (lastCharWasWhitespace) continue;
            }
            curLineWidth += advance;
            lineBuffer.appendCodePoint(codePoint);
        }
        if (!lineBuffer.isEmpty()) {
            consumer.visitRun(lineBuffer, curLineWidth, false);
        }
    }

    private void endLine() {
        if (this.openLineElement == null) {
            return;
        }
        this.context.clearFloatsAbove(this.lineBoxY);
        int lineHeight = 1;
        int lineWidth = 0;
        LineElement el = this.openLineElement;
        while (el != null) {
            lineHeight = Math.max(lineHeight, el.bounds.bottom());
            lineWidth = Math.max(lineWidth, el.bounds.right());
            el = el.next;
        }
        int textAreaStart = this.getInnerLeftEdge();
        int textAreaEnd = this.getInnerRightEdge();
        int xTranslation = textAreaStart;
        if (this.alignment == TextAlignment.RIGHT) {
            xTranslation = textAreaEnd - lineWidth;
        } else if (this.alignment == TextAlignment.CENTER) {
            xTranslation = textAreaStart + (textAreaEnd - textAreaStart - lineWidth) / 2;
        }
        int actualRight = this.lineBoxX;
        LineElement el2 = this.openLineElement;
        while (el2 != null) {
            el2.bounds = el2.bounds.move(xTranslation, this.lineBoxY);
            if (el2 instanceof LineBlock) {
                LineBlock lineBlock = (LineBlock)el2;
                lineBlock.getBlock().layout(this.context, el2.bounds.x(), el2.bounds.y(), el2.bounds.width());
            }
            actualRight = Math.max(actualRight, el2.bounds.right());
            el2 = el2.next;
        }
        LytRect lineBounds = new LytRect(this.lineBoxX, this.lineBoxY, actualRight - this.lineBoxX, lineHeight);
        Line line = new Line(lineBounds, this.openLineElement);
        this.lines.add(line);
        this.lineBoxY += line.bounds().height();
        this.context.clearFloatsAbove(this.lineBoxY);
        this.openLineElement = null;
        this.innerX = 0;
        this.remainingLineWidth = this.getInnerRightEdge() - this.getInnerLeftEdge();
    }

    private int getAvailableHorizontalSpace() {
        return Math.max(0, this.getInnerRightEdge() - this.getInnerLeftEdge());
    }

    private int getInnerLeftEdge() {
        return this.context.getLeftFloatRightEdge().orElse(this.lineBoxX);
    }

    private int getInnerRightEdge() {
        return this.context.getRightFloatLeftEdge().orElse(this.lineBoxX + this.lineBoxWidth);
    }

    private void appendToOpenLine(LineElement el) {
        if (this.openLineElement != null) {
            LineElement l = this.openLineElement;
            while (l.next != null) {
                l = l.next;
            }
            l.next = el;
        } else {
            this.openLineElement = el;
        }
    }

    public void end() {
        this.endLine();
    }

    public LytRect getBounds() {
        int width = this.lines.stream().mapToInt(l -> l.bounds().width()).max().orElse(0);
        return new LytRect(this.lineBoxX, this.startY, width, this.lineBoxY - this.startY);
    }

    private /* synthetic */ void lambda$appendText$1(ResolvedTextStyle style, ResolvedTextStyle hoverStyle, LytFlowContent flowContent, CharSequence run, float width, boolean endLine) {
        if (!run.isEmpty()) {
            LineTextRun el = new LineTextRun(run.toString(), style, hoverStyle);
            el.flowContent = flowContent;
            el.bounds = new LytRect(this.innerX, 0, Math.round(width), this.context.getLineHeight(style));
            this.appendToOpenLine(el);
            this.innerX += el.bounds.width();
            this.remainingLineWidth -= el.bounds.width();
        }
        if (endLine) {
            this.endLine();
        }
    }

    @FunctionalInterface
    static interface LineConsumer {
        public void visitRun(CharSequence var1, float var2, boolean var3);
    }
}

