/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PlacementStrategy;
import appeng.api.config.Actionable;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.core.AEConfig;
import appeng.util.Platform;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3965;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ItemPlacementStrategy
implements PlacementStrategy {
    private static final class_5819 RANDOM_OFFSET = class_5819.method_43047();
    private final class_3218 level;
    private final class_2338 pos;
    private final class_2350 side;
    private final class_2586 host;
    @Nullable
    private final UUID ownerUuid;
    private boolean blocked = false;

    public ItemPlacementStrategy(class_3218 level, class_2338 pos, class_2350 side, class_2586 host, @Nullable UUID owningPlayerId) {
        this.level = level;
        this.pos = pos;
        this.side = side;
        this.host = host;
        this.ownerUuid = owningPlayerId;
    }

    @Override
    public void clearBlocked() {
        this.blocked = !this.level.method_8320(this.pos).method_45474();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long placeInWorld(AEKey what, long amount, Actionable type, boolean placeAsEntity) {
        AEItemKey itemKey;
        block18: {
            block17: {
                if (this.blocked || !(what instanceof AEItemKey)) break block17;
                itemKey = (AEItemKey)what;
                if (amount > 0L) break block18;
            }
            return 0L;
        }
        class_1792 i = itemKey.getItem();
        int maxStorage = (int)Math.min(amount, (long)itemKey.getMaxStackSize());
        class_1799 is = itemKey.toStack(maxStorage);
        boolean worked = false;
        class_2350 side = this.side.method_10153();
        class_2338 placePos = this.pos;
        if (this.level.method_8320(placePos).method_45474()) {
            if (placeAsEntity) {
                int sum = this.countEntitesAround((class_1937)this.level, placePos);
                if (sum < AEConfig.instance().getFormationPlaneEntityLimit()) {
                    worked = true;
                    if (type == Actionable.MODULATE) {
                        is.method_7939(maxStorage);
                        ItemPlacementStrategy.spawnItemEntity((class_1937)this.level, this.host, side, is);
                    }
                }
            } else {
                class_1657 player = Platform.getFakePlayer(this.level, this.ownerUuid);
                Platform.configurePlayer(player, side, this.host);
                maxStorage = is.method_7947();
                worked = true;
                if (type == Actionable.MODULATE) {
                    class_2350 lookDirection = side;
                    PlaneDirectionalPlaceContext context = new PlaneDirectionalPlaceContext((class_1937)this.level, player, placePos, lookDirection, is, lookDirection.method_10153());
                    player.method_6122(class_1268.field_5808, is);
                    try {
                        i.method_7884((class_1838)context);
                    }
                    finally {
                        player.method_6122(class_1268.field_5808, class_1799.field_8037);
                    }
                    maxStorage = Math.max(0, maxStorage - is.method_7947());
                } else {
                    maxStorage = 1;
                }
            }
        }
        boolean bl = this.blocked = !this.level.method_8320(placePos).method_45474();
        if (worked) {
            return maxStorage;
        }
        return 0L;
    }

    private static void spawnItemEntity(class_1937 level, class_2586 te, class_2350 side, class_1799 is) {
        double centerX = (double)te.method_11016().method_10263() + 0.5;
        double centerY = te.method_11016().method_10264();
        double centerZ = (double)te.method_11016().method_10260() + 0.5;
        class_1542 entity = new class_1542(level, centerX, centerY, centerZ, is.method_7972());
        double additionalYOffset = side.method_10164() == -1 ? (double)(1.0f - entity.method_17682()) : 0.0;
        double spawnAreaHeight = Math.max(0.0f, 1.0f - entity.method_17682());
        double spawnAreaWidth = Math.max(0.0f, 1.0f - entity.method_17681());
        double offsetX = side.method_10148() == 0 ? (double)RANDOM_OFFSET.method_43057() * spawnAreaWidth - spawnAreaWidth / 2.0 : (double)side.method_10148() * (0.525 + (double)(entity.method_17681() / 2.0f));
        double offsetY = side.method_10164() == 0 ? (double)RANDOM_OFFSET.method_43057() * spawnAreaHeight : (double)side.method_10164() + additionalYOffset;
        double offsetZ = side.method_10165() == 0 ? (double)RANDOM_OFFSET.method_43057() * spawnAreaWidth - spawnAreaWidth / 2.0 : (double)side.method_10165() * (0.525 + (double)(entity.method_17681() / 2.0f));
        double absoluteX = centerX + offsetX;
        double absoluteY = centerY + offsetY;
        double absoluteZ = centerZ + offsetZ;
        entity.method_5814(absoluteX, absoluteY, absoluteZ);
        entity.method_18800((double)side.method_10148() * 0.1, (double)side.method_10164() * 0.1, (double)side.method_10165() * 0.1);
        level.method_8649((class_1297)entity);
    }

    private int countEntitesAround(class_1937 level, class_2338 pos) {
        class_238 t = new class_238(pos).method_1014(8.0);
        List list = level.method_18467(class_1297.class, t);
        return list.size();
    }

    private static class PlaneDirectionalPlaceContext
    extends class_1750 {
        private final class_2350 lookDirection;

        public PlaneDirectionalPlaceContext(class_1937 level, class_1657 player, class_2338 pos, class_2350 lookDirection, class_1799 itemStack, class_2350 facing) {
            super(level, player, class_1268.field_5808, itemStack, new class_3965(class_243.method_24955((class_2382)pos), facing, pos, false));
            this.lookDirection = lookDirection;
        }

        public class_2338 method_8037() {
            return this.method_30344().method_17777();
        }

        public boolean method_7716() {
            return this.method_8045().method_8320(this.method_8037()).method_26166((class_1750)this);
        }

        public class_2350 method_7715() {
            return class_2350.field_11033;
        }

        public class_2350[] method_7718() {
            class_2350[] class_2350Array;
            switch (this.lookDirection) {
                default: {
                    class_2350[] class_2350Array2 = new class_2350[6];
                    class_2350Array2[0] = class_2350.field_11033;
                    class_2350Array2[1] = class_2350.field_11043;
                    class_2350Array2[2] = class_2350.field_11034;
                    class_2350Array2[3] = class_2350.field_11035;
                    class_2350Array2[4] = class_2350.field_11039;
                    class_2350Array = class_2350Array2;
                    class_2350Array2[5] = class_2350.field_11036;
                    break;
                }
                case field_11036: {
                    class_2350[] class_2350Array3 = new class_2350[6];
                    class_2350Array3[0] = class_2350.field_11033;
                    class_2350Array3[1] = class_2350.field_11036;
                    class_2350Array3[2] = class_2350.field_11043;
                    class_2350Array3[3] = class_2350.field_11034;
                    class_2350Array3[4] = class_2350.field_11035;
                    class_2350Array = class_2350Array3;
                    class_2350Array3[5] = class_2350.field_11039;
                    break;
                }
                case field_11043: {
                    class_2350[] class_2350Array4 = new class_2350[6];
                    class_2350Array4[0] = class_2350.field_11033;
                    class_2350Array4[1] = class_2350.field_11043;
                    class_2350Array4[2] = class_2350.field_11034;
                    class_2350Array4[3] = class_2350.field_11039;
                    class_2350Array4[4] = class_2350.field_11036;
                    class_2350Array = class_2350Array4;
                    class_2350Array4[5] = class_2350.field_11035;
                    break;
                }
                case field_11035: {
                    class_2350[] class_2350Array5 = new class_2350[6];
                    class_2350Array5[0] = class_2350.field_11033;
                    class_2350Array5[1] = class_2350.field_11035;
                    class_2350Array5[2] = class_2350.field_11034;
                    class_2350Array5[3] = class_2350.field_11039;
                    class_2350Array5[4] = class_2350.field_11036;
                    class_2350Array = class_2350Array5;
                    class_2350Array5[5] = class_2350.field_11043;
                    break;
                }
                case field_11039: {
                    class_2350[] class_2350Array6 = new class_2350[6];
                    class_2350Array6[0] = class_2350.field_11033;
                    class_2350Array6[1] = class_2350.field_11039;
                    class_2350Array6[2] = class_2350.field_11035;
                    class_2350Array6[3] = class_2350.field_11036;
                    class_2350Array6[4] = class_2350.field_11043;
                    class_2350Array = class_2350Array6;
                    class_2350Array6[5] = class_2350.field_11034;
                    break;
                }
                case field_11034: {
                    class_2350[] class_2350Array7 = new class_2350[6];
                    class_2350Array7[0] = class_2350.field_11033;
                    class_2350Array7[1] = class_2350.field_11034;
                    class_2350Array7[2] = class_2350.field_11035;
                    class_2350Array7[3] = class_2350.field_11036;
                    class_2350Array7[4] = class_2350.field_11043;
                    class_2350Array = class_2350Array7;
                    class_2350Array7[5] = class_2350.field_11039;
                }
            }
            return class_2350Array;
        }

        public class_2350 method_8042() {
            return this.lookDirection.method_10166() == class_2350.class_2351.field_11052 ? class_2350.field_11043 : this.lookDirection;
        }

        public boolean method_8046() {
            return false;
        }

        public float method_8044() {
            return this.lookDirection.method_10161() * 90;
        }
    }
}

