/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.config.PowerUnits;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.core.AppEng;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.CapabilityP2PTunnelPart;
import appeng.parts.p2p.P2PModels;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import team.reborn.energy.api.EnergyStorage;

public class FEP2PTunnelPart
extends CapabilityP2PTunnelPart<FEP2PTunnelPart, EnergyStorage> {
    private static final P2PModels MODELS = new P2PModels(AppEng.makeId("part/p2p/p2p_tunnel_fe"));

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public FEP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem, EnergyStorage.SIDED);
        this.inputHandler = new InputEnergyStorage();
        this.outputHandler = new OutputEnergyStorage();
        this.emptyHandler = EnergyStorage.EMPTY;
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    private class InputEnergyStorage
    implements EnergyStorage {
        private InputEnergyStorage() {
        }

        public boolean supportsInsertion() {
            for (FEP2PTunnelPart output : FEP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = output.getAdjacentCapability();
                try {
                    if (!((EnergyStorage)capabilityGuard.get()).supportsInsertion()) continue;
                    boolean bl = true;
                    return bl;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            return false;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            StoragePreconditions.notNegative((long)maxAmount);
            long total = 0L;
            int outputTunnels = FEP2PTunnelPart.this.getOutputs().size();
            long amount = maxAmount;
            if (outputTunnels == 0 || amount == 0L) {
                return 0L;
            }
            long amountPerOutput = amount / (long)outputTunnels;
            long overflow = amountPerOutput == 0L ? amount : amount % amountPerOutput;
            for (FEP2PTunnelPart target : FEP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = target.getAdjacentCapability();
                try {
                    EnergyStorage output = (EnergyStorage)capabilityGuard.get();
                    long toSend = amountPerOutput + overflow;
                    long received = output.insert(toSend, transaction);
                    overflow = toSend - received;
                    total += received;
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            FEP2PTunnelPart.this.queueTunnelDrain(PowerUnits.TR, total, transaction);
            return total;
        }

        public boolean supportsExtraction() {
            return false;
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public long getAmount() {
            long tot = 0L;
            for (FEP2PTunnelPart output : FEP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = output.getAdjacentCapability();
                try {
                    tot += ((EnergyStorage)capabilityGuard.get()).getAmount();
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            return tot;
        }

        public long getCapacity() {
            long tot = 0L;
            for (FEP2PTunnelPart output : FEP2PTunnelPart.this.getOutputs()) {
                CapabilityP2PTunnelPart.CapabilityGuard capabilityGuard = output.getAdjacentCapability();
                try {
                    tot += ((EnergyStorage)capabilityGuard.get()).getCapacity();
                }
                finally {
                    if (capabilityGuard == null) continue;
                    capabilityGuard.close();
                }
            }
            return tot;
        }
    }

    private class OutputEnergyStorage
    implements EnergyStorage {
        private OutputEnergyStorage() {
        }

        public boolean supportsInsertion() {
            return false;
        }

        public long insert(long maxAmount, TransactionContext transaction) {
            return 0L;
        }

        public boolean supportsExtraction() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FEP2PTunnelPart.this.getInputCapability();){
                boolean bl = ((EnergyStorage)input.get()).supportsExtraction();
                return bl;
            }
        }

        public long extract(long maxAmount, TransactionContext transaction) {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FEP2PTunnelPart.this.getInputCapability();){
                long extracted = ((EnergyStorage)input.get()).extract(maxAmount, transaction);
                FEP2PTunnelPart.this.queueTunnelDrain(PowerUnits.TR, extracted, transaction);
                long l = extracted;
                return l;
            }
        }

        public long getAmount() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FEP2PTunnelPart.this.getInputCapability();){
                long l = ((EnergyStorage)input.get()).getAmount();
                return l;
            }
        }

        public long getCapacity() {
            try (CapabilityP2PTunnelPart.CapabilityGuard input = FEP2PTunnelPart.this.getInputCapability();){
                long l = ((EnergyStorage)input.get()).getCapacity();
                return l;
            }
        }
    }
}

