/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.p2p;

import appeng.api.networking.IGridNodeListener;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.core.AppEng;
import appeng.items.parts.PartModels;
import appeng.parts.p2p.P2PModels;
import appeng.parts.p2p.P2PTunnelPart;
import appeng.util.Platform;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2487;
import net.minecraft.class_2680;

public class RedstoneP2PTunnelPart
extends P2PTunnelPart<RedstoneP2PTunnelPart> {
    private static final P2PModels MODELS = new P2PModels(AppEng.makeId("part/p2p/p2p_tunnel_redstone"));
    private int power;
    private boolean recursive = false;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public RedstoneP2PTunnelPart(IPartItem<?> partItem) {
        super(partItem);
    }

    @Override
    protected float getPowerDrainPerTick() {
        return 0.5f;
    }

    private void setNetworkReady() {
        RedstoneP2PTunnelPart in;
        if (this.isOutput() && (in = (RedstoneP2PTunnelPart)this.getInput()) != null) {
            this.putInput(in.power);
        }
    }

    private void putInput(Object o) {
        int newPower;
        if (this.recursive) {
            return;
        }
        this.recursive = true;
        if (this.isOutput() && this.getMainNode().isActive() && this.power != (newPower = ((Integer)o).intValue())) {
            this.power = newPower;
            this.notifyNeighbors();
        }
        this.recursive = false;
    }

    private void notifyNeighbors() {
        class_1937 level = this.getBlockEntity().method_10997();
        Platform.notifyBlocksOfNeighbors(level, this.getBlockEntity().method_11016());
        for (class_2350 face : class_2350.values()) {
            Platform.notifyBlocksOfNeighbors(level, this.getBlockEntity().method_11016().method_10093(face));
        }
    }

    @Override
    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        if (this.getMainNode().hasGridBooted()) {
            this.setNetworkReady();
        }
    }

    @Override
    public void readFromNBT(class_2487 tag) {
        super.readFromNBT(tag);
        this.power = tag.method_10550("power");
    }

    @Override
    public void writeToNBT(class_2487 tag) {
        super.writeToNBT(tag);
        tag.method_10569("power", this.power);
    }

    @Override
    public void onTunnelNetworkChange() {
        this.setNetworkReady();
    }

    @Override
    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        if (!this.isOutput()) {
            class_2338 target = this.getBlockEntity().method_11016().method_10093(this.getSide());
            class_2680 state = this.getBlockEntity().method_10997().method_8320(target);
            class_2248 b = state.method_26204();
            if (b != null && !this.isOutput()) {
                class_2350 srcSide = this.getSide();
                if (b instanceof class_2457) {
                    srcSide = class_2350.field_11036;
                }
                this.power = b.method_9524(state, (class_1922)this.getBlockEntity().method_10997(), target, srcSide);
                this.power = Math.max(this.power, b.method_9524(state, (class_1922)this.getBlockEntity().method_10997(), target, srcSide));
                this.sendToOutput(this.power);
            } else {
                this.sendToOutput(0);
            }
        }
    }

    @Override
    public boolean canConnectRedstone() {
        return true;
    }

    @Override
    public int isProvidingStrongPower() {
        return this.isOutput() ? this.power : 0;
    }

    @Override
    public int isProvidingWeakPower() {
        return this.isOutput() ? this.power : 0;
    }

    private void sendToOutput(int power) {
        for (RedstoneP2PTunnelPart rs : this.getOutputs()) {
            rs.putInput(power);
        }
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }
}

