/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ConfigFile {
    private static final List<ConfigFile> loadableFiles = new ArrayList<ConfigFile>();
    private final String fileName;
    private final List<Runnable> reloadListeners = new ArrayList<Runnable>();
    private ConfigSection root = null;
    public final LoadPhase loadPhase;
    private boolean reloading = false;
    private boolean loaded = false;

    private static void registerConfig(@NotNull ConfigFile file) {
        loadableFiles.add(file);
    }

    public static void loadClientFiles(@NotNull LoadPhase phase) {
        ConfigFile.loadFiles(true, phase);
    }

    public static void loadServerFiles(@NotNull LoadPhase phase) {
        ConfigFile.loadFiles(false, phase);
    }

    public static void loadFiles(boolean logicalClient, @NotNull LoadPhase phase) {
        for (ConfigFile file : loadableFiles) {
            try {
                if (file.isLoaded() || !file.shouldReload(logicalClient) || file.loadPhase != phase) continue;
                file.reload();
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LightmansCurrency.LogError("Error reloading config file!", e);
            }
        }
    }

    public static void reloadClientFiles() {
        ConfigFile.reloadFiles(true);
    }

    public static void reloadServerFiles() {
        ConfigFile.reloadFiles(false);
    }

    private static void reloadFiles(boolean logicalClient) {
        for (ConfigFile file : loadableFiles) {
            try {
                if (!file.shouldReload(logicalClient)) continue;
                file.reload();
            }
            catch (IllegalArgumentException | NullPointerException e) {
                LightmansCurrency.LogError("Error reloading config file!", e);
            }
        }
    }

    @NotNull
    protected String getConfigFolder() {
        return "config";
    }

    @NotNull
    public String getFileName() {
        return this.fileName;
    }

    public final void addListener(@NotNull Runnable listener) {
        if (!this.reloadListeners.contains(listener)) {
            this.reloadListeners.add(listener);
        }
    }

    @NotNull
    protected String getFilePath() {
        return this.getConfigFolder() + "/" + this.fileName + ".lcconfig";
    }

    @NotNull
    protected final File getFile() {
        return new File(this.getFilePath());
    }

    private void confirmSetup() {
        if (this.root == null) {
            ConfigBuilder builder = new ConfigBuilder();
            this.setup(builder);
            this.root = builder.build(this);
        }
    }

    protected final void forEach(@NotNull Consumer<ConfigOption<?>> action) {
        this.confirmSetup();
        this.root.forEach(action);
    }

    @NotNull
    protected final Map<String, ConfigOption<?>> getAllOptions() {
        this.confirmSetup();
        HashMap results = new HashMap();
        this.collectOptionsFrom(this.root, results);
        return ImmutableMap.copyOf(results);
    }

    private void collectOptionsFrom(@NotNull ConfigSection section, @NotNull Map<String, ConfigOption<?>> resultMap) {
        section.options.forEach((? super K key, ? super V option) -> resultMap.put(section.fullNameOfChild((String)key), (ConfigOption<?>)option));
        section.sectionsInOrder.forEach((? super T s) -> this.collectOptionsFrom((ConfigSection)s, resultMap));
    }

    @NotNull
    protected final ConfigSection findSection(@NotNull String sectionName) {
        String[] subSections = sectionName.split("\\.");
        ConfigSection currentSection = this.root;
        for (String ss : subSections) {
            if (!currentSection.sections.containsKey(ss)) {
                return null;
            }
            currentSection = currentSection.sections.get(ss);
        }
        return currentSection;
    }

    protected ConfigFile(@NotNull String fileName) {
        this(fileName, LoadPhase.GAME_START);
    }

    protected ConfigFile(@NotNull String fileName, @NotNull LoadPhase loadPhase) {
        this.fileName = fileName;
        this.loadPhase = loadPhase;
        ConfigFile.registerConfig(this);
    }

    protected boolean isClientOnly() {
        return false;
    }

    protected boolean isServerOnly() {
        return false;
    }

    protected abstract void setup(@NotNull ConfigBuilder var1);

    public boolean shouldReload(boolean isLogicalClient) {
        if (this.isClientOnly() && !isLogicalClient) {
            return false;
        }
        return !this.isServerOnly() || !isLogicalClient;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public final void reload() {
        if (this.reloading) {
            return;
        }
        this.reloading = true;
        LightmansCurrency.LogInfo("Reloading " + this.getFilePath());
        this.confirmSetup();
        List<String> lines = this.readLines();
        this.forEach(ConfigOption::clear);
        ConfigSection currentSection = this.root;
        for (String line : lines) {
            String cleanLine = ConfigFile.cleanStartingWhitespace(line);
            if (cleanLine.startsWith("#")) continue;
            int equalIndex = cleanLine.indexOf(61);
            if (equalIndex > 0) {
                String optionName = cleanLine.substring(0, equalIndex);
                String optionValue = "";
                if (equalIndex < cleanLine.length() - 1) {
                    optionValue = cleanLine.substring(equalIndex + 1);
                }
                if (currentSection.options.containsKey(optionName)) {
                    currentSection.options.get(optionName).load(currentSection.fullNameOfChild(optionName), optionValue, false);
                    continue;
                }
                LightmansCurrency.LogWarning("Option " + currentSection.fullName() + "." + optionName + " found in the file, but is not present in the config setup!");
                continue;
            }
            if (!cleanLine.startsWith("[")) continue;
            String fullyCleaned = ConfigOption.cleanWhitespace(cleanLine);
            if (fullyCleaned.endsWith("]")) {
                String section = fullyCleaned.substring(1, fullyCleaned.length() - 1);
                ConfigSection query = this.findSection(section);
                if (query != null) {
                    currentSection = query;
                    continue;
                }
                LightmansCurrency.LogWarning("Line " + (lines.indexOf(line) + 1) + " of " + this.fileName + " contained a section (" + section + ") that is not present in this config!");
                currentSection = this.root;
                continue;
            }
            LightmansCurrency.LogWarning("Line " + (lines.indexOf(line) + 1) + " of config '" + this.fileName + "' is missing the ']' for the section label!");
        }
        this.getAllOptions().forEach((? super K id, ? super V option) -> {
            if (!option.isLoaded()) {
                LightmansCurrency.LogWarning("Option " + id + " was missing from the config. Default value will be used instead.");
            }
        });
        this.loaded = true;
        this.writeToFile();
        this.afterReload();
        for (Runnable l : this.reloadListeners) {
            l.run();
        }
        this.reloading = false;
    }

    @NotNull
    public static String cleanStartingWhitespace(@NotNull String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return line.substring(i);
        }
        return line;
    }

    private List<String> readLines() {
        File file = this.getFile();
        if (!file.exists()) {
            return new ArrayList<String>();
        }
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(file, StandardCharsets.UTF_8));
            ArrayList<String> lines = new ArrayList<String>();
            while ((line = br.readLine()) != null) {
                lines.add(line);
            }
            br.close();
            return lines;
        }
        catch (IOException e) {
            LightmansCurrency.LogError("Error loading config file '" + file.getPath() + "'!", e);
            return new ArrayList<String>();
        }
    }

    public final void writeToFile() {
        File file = this.getFile();
        try {
            if (!file.exists()) {
                File folder = new File(file.getParent());
                if (!folder.exists()) {
                    folder.mkdirs();
                }
                if (!file.createNewFile()) {
                    LightmansCurrency.LogError("Unable to createTrue " + this.fileName + "!");
                    return;
                }
            }
            try (PrintWriter writer = new PrintWriter(file, StandardCharsets.UTF_8);){
                this.confirmSetup();
                this.writeSection(writer, this.root);
            }
        }
        catch (IOException | SecurityException e) {
            LightmansCurrency.LogError("Error modifying " + this.fileName + "!", e);
        }
    }

    private void writeSection(@NotNull PrintWriter writer, @NotNull ConfigSection section) {
        Consumer<String> w;
        if (section.parent != null) {
            w = section.parent.lineConsumer(writer);
            ConfigFile.writeComments(section.comments, w);
            w.accept("[" + section.fullName() + "]");
        }
        w = section.lineConsumer(writer);
        section.optionsInOrder.forEach((? super T pair) -> ((ConfigOption)pair.getSecond()).write((String)pair.getFirst(), w));
        section.sectionsInOrder.forEach((? super T s) -> this.writeSection(writer, (ConfigSection)s));
    }

    public static Consumer<String> lineConsumer(@NotNull PrintWriter writer, int depth) {
        return s -> writer.println("\t".repeat(Math.max(0, depth)) + s);
    }

    public static void writeComments(@NotNull List<String> comments, @NotNull Consumer<String> writer) {
        for (String c : comments) {
            for (String c2 : c.split("\n")) {
                writer.accept("#" + c2);
            }
        }
    }

    protected void afterReload() {
    }

    public static enum LoadPhase {
        NULL,
        GAME_START;

    }

    private static final class ConfigSection {
        private final ConfigSection parent;
        private final int depth;
        private final String name;
        private final List<String> comments;
        private final List<ConfigSection> sectionsInOrder;
        private final Map<String, ConfigSection> sections;
        private final List<Pair<String, ConfigOption<?>>> optionsInOrder;
        private final Map<String, ConfigOption<?>> options;

        private String fullName() {
            if (this.parent != null) {
                return this.parent.fullNameOfChild(this.name);
            }
            return this.name;
        }

        private String fullNameOfChild(@NotNull String childName) {
            if (this.parent == null) {
                return childName;
            }
            return this.fullName() + "." + childName;
        }

        void forEach(@NotNull Consumer<ConfigOption<?>> action) {
            this.optionsInOrder.forEach((? super T p) -> action.accept((ConfigOption)p.getSecond()));
            this.sectionsInOrder.forEach((? super T s) -> s.forEach(action));
        }

        Consumer<String> lineConsumer(@NotNull PrintWriter writer) {
            return ConfigFile.lineConsumer(writer, this.depth);
        }

        private ConfigSection(ConfigSectionBuilder builder, ConfigSection parent, ConfigFile file) {
            this.name = builder.name;
            this.depth = builder.depth;
            this.parent = parent;
            this.comments = ImmutableList.copyOf(builder.comments);
            this.optionsInOrder = ImmutableList.copyOf(builder.optionsInOrder);
            this.options = ImmutableMap.copyOf(builder.options);
            this.optionsInOrder.forEach((? super T o) -> ((ConfigOption)o.getSecond()).setParent(file));
            ArrayList temp1 = new ArrayList();
            builder.sectionsInOrder.forEach((? super T b) -> temp1.add(b.build(this, file)));
            this.sectionsInOrder = ImmutableList.copyOf(temp1);
            HashMap temp2 = new HashMap();
            this.sectionsInOrder.forEach((? super T section) -> temp2.put(section.name, section));
            this.sections = ImmutableMap.copyOf(temp2);
        }
    }

    protected static final class ConfigBuilder {
        private final ConfigSectionBuilder root = new ConfigSectionBuilder("root", 0, null);
        private final List<String> comments = new ArrayList<String>();
        private ConfigSectionBuilder currentSection = this.root;

        private ConfigSection build(ConfigFile file) {
            return this.root.build(null, file);
        }

        private ConfigBuilder() {
        }

        public ConfigBuilder push(String newSection) {
            if (ConfigBuilder.invalidName(newSection)) {
                throw new IllegalArgumentException("Illegal section name '" + newSection + "'!");
            }
            this.currentSection = this.currentSection.sections.containsKey(newSection) ? this.currentSection.sections.get(newSection) : this.currentSection.addChild(newSection);
            this.currentSection.comments.addAll(this.comments);
            this.comments.clear();
            return this;
        }

        public static boolean invalidName(String name) {
            if (name.equals("root")) {
                return false;
            }
            for (int i = 0; i < name.length(); ++i) {
                if (ConfigBuilder.validNameChar(name.charAt(i))) continue;
                return true;
            }
            return false;
        }

        public static boolean validNameChar(char c) {
            return c == '_' || c == '-' || c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z';
        }

        public ConfigBuilder pop() {
            if (this.currentSection == this.root) {
                throw new IllegalArgumentException("Cannot pop the builder when we're already at root level!");
            }
            this.currentSection = this.currentSection.parent;
            return this;
        }

        public ConfigBuilder comment(String ... comment) {
            this.comments.addAll((Collection<String>)ImmutableList.copyOf((Object[])comment));
            return this;
        }

        public ConfigBuilder add(@NotNull String optionName, @NotNull ConfigOption<?> option) {
            if (ConfigBuilder.invalidName(optionName)) {
                throw new IllegalArgumentException("Illegal option name '" + optionName + "'!");
            }
            if (this.currentSection == null) {
                this.currentSection = this.root;
            }
            if (this.currentSection.options.containsKey(optionName)) {
                LightmansCurrency.LogError("Duplicate option '" + this.currentSection.fullNameOfChild(optionName) + "'!\nDuplicate option will be ignored!");
                return this;
            }
            this.currentSection.addOption(optionName, option);
            option.setComments(this.comments);
            this.comments.clear();
            return this;
        }
    }

    private static final class ConfigSectionBuilder {
        private final ConfigSectionBuilder parent;
        private final String name;
        private final int depth;
        private final List<String> comments = new ArrayList<String>();
        private final List<ConfigSectionBuilder> sectionsInOrder = new ArrayList<ConfigSectionBuilder>();
        private final Map<String, ConfigSectionBuilder> sections = new HashMap<String, ConfigSectionBuilder>();
        private final List<Pair<String, ConfigOption<?>>> optionsInOrder = new ArrayList();
        private final Map<String, ConfigOption<?>> options = new HashMap();

        @NotNull
        private String fullName() {
            if (this.parent != null) {
                return this.parent.fullNameOfChild(this.name);
            }
            return this.name;
        }

        private String fullNameOfChild(@NotNull String childName) {
            if (this.parent == null) {
                return childName;
            }
            return this.fullName() + "." + childName;
        }

        private ConfigSectionBuilder(@NotNull String name, int depth, ConfigSectionBuilder parent) {
            this.name = name;
            this.depth = depth;
            this.parent = parent;
        }

        private void addOption(@NotNull String name, @NotNull ConfigOption<?> option) {
            this.optionsInOrder.add(Pair.of((Object)name, option));
            this.options.put(name, option);
        }

        private ConfigSectionBuilder addChild(@NotNull String name) {
            ConfigSectionBuilder builder = new ConfigSectionBuilder(name, this.depth + 1, this);
            this.sectionsInOrder.add(builder);
            this.sections.put(name, builder);
            return builder;
        }

        private ConfigSection build(@Nullable ConfigSection parent, @NotNull ConfigFile file) {
            return new ConfigSection(this, parent, file);
        }
    }
}

