/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config;

import com.google.common.collect.ImmutableMap;
import io.github.lightman314.lightmanscurrency.api.config.ConfigFile;
import io.github.lightman314.lightmanscurrency.api.config.options.ConfigOption;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.network.client.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.network.client.messages.config.SPacketSyncConfig;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public abstract class SyncedConfigFile
extends ConfigFile {
    private static final Map<class_2960, SyncedConfigFile> fileMap = new HashMap<class_2960, SyncedConfigFile>();
    protected final class_2960 id;
    private boolean loadedSyncData = false;

    @Override
    protected boolean isServerOnly() {
        return true;
    }

    public static void playerJoined(@NotNull class_3222 player) {
        fileMap.values().forEach((? super T c) -> c.createSyncPacket().sendTo(player));
    }

    public static void handleSyncData(@NotNull class_2960 configID, @NotNull Map<String, String> data) {
        if (fileMap.containsKey(configID)) {
            fileMap.get(configID).loadSyncData(data);
        } else {
            LightmansCurrency.LogError("Received config data for '" + configID + "' from the server, however this config is not present on the client!");
        }
    }

    public static void onClientLeavesServer() {
        fileMap.values().forEach(SyncedConfigFile::clearSyncedData);
    }

    protected SyncedConfigFile(@NotNull String fileName, @NotNull class_2960 id) {
        super(fileName, ConfigFile.LoadPhase.GAME_START);
        this.id = id;
        if (fileMap.containsKey(this.id)) {
            throw new IllegalArgumentException("Synced Config " + this.id + " already exists!");
        }
        fileMap.put(this.id, this);
    }

    @Override
    public boolean isLoaded() {
        return super.isLoaded() || this.loadedSyncData;
    }

    @Override
    protected void afterReload() {
        this.createSyncPacket().sendToAll();
    }

    public final void clearSyncedData() {
        this.forEach(ConfigOption::clearSyncedData);
        this.loadedSyncData = false;
    }

    @NotNull
    private Map<String, String> getSyncData() {
        HashMap map = new HashMap();
        this.getAllOptions().forEach((? super K id, ? super V option) -> map.put(id, option.write()));
        return ImmutableMap.copyOf(map);
    }

    private ServerToClientPacket createSyncPacket() {
        return new SPacketSyncConfig(this.id, this.getSyncData());
    }

    private void loadSyncData(@NotNull Map<String, String> syncData) {
        LightmansCurrency.LogInfo("Received config data for '" + this.id + "' from the server!");
        this.getAllOptions().forEach((? super K id, ? super V option) -> {
            if (syncData.containsKey(id)) {
                option.load((String)id, (String)syncData.get(id), true);
            } else {
                LightmansCurrency.LogWarning("Received data for config option '" + id + "' but it is not present on the client!");
            }
        });
    }
}

