/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.config.options.basic;

import io.github.lightman314.lightmanscurrency.api.config.options.ListOption;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.LongOption;
import io.github.lightman314.lightmanscurrency.api.config.options.parsing.ConfigParser;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LongListOption
extends ListOption<Long> {
    private final long lowerLimit;
    private final long upperLimit;
    private final ConfigParser<Long> parser;

    protected LongListOption(@NotNull Supplier<List<Long>> defaultValue, long lowerLimit, long upperLimit) {
        super(defaultValue);
        this.lowerLimit = lowerLimit;
        this.upperLimit = upperLimit;
        this.parser = LongOption.makeParser(lowerLimit, upperLimit);
    }

    @Override
    protected ConfigParser<Long> getPartialParser() {
        return this.parser;
    }

    @Override
    @Nullable
    protected String bonusComment() {
        return "Range: " + this.lowerLimit + " -> " + this.upperLimit;
    }

    public static LongListOption create(@NotNull List<Long> defaultValue) {
        return new LongListOption(() -> defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static LongListOption create(@NotNull List<Long> defaultValue, long lowerLimit) {
        return new LongListOption(() -> defaultValue, lowerLimit, Long.MAX_VALUE);
    }

    public static LongListOption create(@NotNull List<Long> defaultValue, long lowerLimit, long upperLimit) {
        return new LongListOption(() -> defaultValue, lowerLimit, upperLimit);
    }

    public static LongListOption create(@NotNull Supplier<List<Long>> defaultValue) {
        return new LongListOption(defaultValue, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    public static LongListOption create(@NotNull Supplier<List<Long>> defaultValue, long lowerLimit) {
        return new LongListOption(defaultValue, lowerLimit, Long.MAX_VALUE);
    }

    public static LongListOption create(@NotNull Supplier<List<Long>> defaultValue, long lowerLimit, long upperLimit) {
        return new LongListOption(defaultValue, lowerLimit, upperLimit);
    }
}

