/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.callbacks.RenderInventoryCallback;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.ChestCoinCollectButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.NotificationButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.TeamManagerButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.TraderRecoveryButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.WalletButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.WalletVisibilityToggleButton;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.client.util.ScreenUtil;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menu.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.integration.trinketsapi.LCTrinketsAPI;
import io.github.lightman314.lightmanscurrency.network.server.messages.wallet.CMessageOpenWalletMenu;
import io.github.lightman314.lightmanscurrency.network.server.messages.walletslot.CMessageSetWalletVisible;
import io.github.lightman314.lightmanscurrency.network.server.messages.walletslot.CMessageWalletInteraction;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.model.ModelLoadingRegistry;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.fabricmc.fabric.impl.client.screen.ScreenExtensions;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_476;
import net.minecraft.class_481;
import net.minecraft.class_485;
import net.minecraft.class_490;
import net.minecraft.class_746;

public class ClientEventListeners {
    public static final class_2960 WALLET_SLOT_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/container/wallet_slot.png");
    public static final class_304 KEY_WALLET = new class_304("key.wallet", 86, "key.categories.inventory");

    public static void init() {
        try {
            KeyBindingHelper.registerKeyBinding((class_304)KEY_WALLET);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        ClientTickEvents.END_CLIENT_TICK.register(ClientEventListeners::onClientTick);
        ScreenEvents.AFTER_INIT.register(ClientEventListeners::onInventoryScreenInit);
        RenderInventoryCallback.RENDER_BACKGROUND.register(ClientEventListeners::renderInventoryScreen);
        ModelLoadingRegistry.INSTANCE.registerModelProvider(ClientEventListeners::loadExtraModels);
    }

    private static void loadExtraModels(class_3300 manager, Consumer<class_2960> consumer) {
        consumer.accept(SlotMachineBlock.LIGHT_MODEL_LOCATION);
    }

    private static void onClientTick(class_310 client) {
        if (KEY_WALLET.method_1436() && client.field_1724 != null && client.field_1755 == null) {
            class_746 player = client.field_1724;
            new CMessageOpenWalletMenu(-1).sendToServer();
            class_1799 walletStack = WalletHandler.getWallet((class_1657)player).getWallet();
            if (!walletStack.method_7960()) {
                client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)class_3417.field_14581, (float)(1.25f + player.method_37908().field_9229.method_43057() * 0.5f), (float)0.75f));
                if (!WalletItem.isEmpty(walletStack)) {
                    client.method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)ModSounds.COINS_CLINKING, (float)1.0f, (float)0.4f));
                }
            }
        }
    }

    private static void onInventoryScreenInit(class_310 client, class_437 screen, int scaledWidth, int scaledHeight) {
        List screenWidgets;
        class_465 gui;
        if (screen instanceof class_490 || screen instanceof class_481) {
            gui = (class_465)screen;
            screenWidgets = Screens.getButtons((class_437)screen);
            if (!LCTrinketsAPI.isValid((class_1309)client.field_1724)) {
                screenWidgets.add(new WalletButton(gui));
                screenWidgets.add(new WalletVisibilityToggleButton(gui));
            }
            screenWidgets.add(new NotificationButton(gui));
            screenWidgets.add(new TeamManagerButton(gui));
            screenWidgets.add(new TraderRecoveryButton(gui));
            ScreenExtensions extension = ScreenExtensions.getExtensions((class_437)screen);
            extension.fabric_getAfterRenderEvent().register(ClientEventListeners::renderInventoryTooltips);
            extension.fabric_getAllowMouseClickEvent().register(ClientEventListeners::onInventoryClick);
        }
        if (screen instanceof class_476) {
            gui = (class_476)screen;
            screenWidgets = Screens.getButtons((class_437)screen);
            screenWidgets.add(new ChestCoinCollectButton((class_476)gui));
        }
    }

    public static void toggleWalletVisibility() {
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        WalletHandler handler = WalletHandler.getWallet((class_1657)player);
        boolean nowVisibile = !handler.visible();
        handler.setVisible(nowVisibile);
        new CMessageSetWalletVisible(nowVisibile).sendToServer();
    }

    public static void renderInventoryScreen(class_437 screen, class_332 context, int mouseX, int mouseY, float tickDelta) {
        if (screen instanceof class_485) {
            class_481 creativeScreen;
            class_485 gui = (class_485)screen;
            if (gui instanceof class_481 && !(creativeScreen = (class_481)gui).method_47424()) {
                return;
            }
            class_310 client = Screens.getClient((class_437)screen);
            if (LCTrinketsAPI.isValid((class_1309)client.field_1724)) {
                return;
            }
            WalletHandler walletHandler = WalletHandler.getWallet((class_1657)client.field_1724);
            ScreenPosition slotPosition = screen instanceof class_481 ? (ScreenPosition)LCConfig.CLIENT.walletSlotCreative.get() : (ScreenPosition)LCConfig.CLIENT.walletSlot.get();
            context.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            slotPosition = slotPosition.offset(ScreenUtil.getScreenCorner(gui));
            context.method_25302(WALLET_SLOT_TEXTURE, slotPosition.x, slotPosition.y, 0, 0, 18, 18);
            class_1799 wallet = walletHandler.getWallet();
            slotPosition = slotPosition.offset(1, 1);
            if (wallet.method_7960()) {
                ItemRenderUtil.drawSlotBackground(context, slotPosition.x, slotPosition.y, WalletSlot.BACKGROUND);
            } else {
                ItemRenderUtil.drawItemStack(context, null, wallet, slotPosition.x, slotPosition.y);
            }
            if (ClientEventListeners.isMouseOverWalletSlot(mouseX, mouseY, slotPosition.offset(-1, -1))) {
                class_465.method_33285((class_332)context, (int)slotPosition.x, (int)slotPosition.y, (int)0);
            }
        }
    }

    public static void renderInventoryTooltips(class_437 screen, class_332 context, int mouseX, int mouseY, float tickDelta) {
        if (screen instanceof class_485) {
            class_481 creativeScreen;
            class_485 gui = (class_485)screen;
            if (screen instanceof class_481 && !(creativeScreen = (class_481)screen).method_47424()) {
                return;
            }
            class_310 client = Screens.getClient((class_437)screen);
            if (!LCTrinketsAPI.isValid((class_1309)client.field_1724)) {
                WalletHandler walletHandler = WalletHandler.getWallet((class_1657)client.field_1724);
                class_1799 wallet = walletHandler.getWallet();
                ScreenPosition slotPosition = screen instanceof class_481 ? (ScreenPosition)LCConfig.CLIENT.walletSlotCreative.get() : (ScreenPosition)LCConfig.CLIENT.walletSlot.get();
                if (ClientEventListeners.isMouseOverWalletSlot(mouseX, mouseY, (slotPosition = slotPosition.offset(ScreenUtil.getScreenCorner(gui))).offset(-1, -1)) && !wallet.method_7960()) {
                    context.method_51434(client.field_1772, ItemRenderUtil.getTooltipFromItem(wallet), mouseX, mouseY);
                }
            }
            NotificationButton.tryRenderTooltip(context, mouseX, mouseY);
            TeamManagerButton.tryRenderTooltip(context, mouseX, mouseY);
            TraderRecoveryButton.tryRenderTooltip(context, mouseX, mouseY);
        }
    }

    private static boolean onInventoryClick(class_437 screen, double mouseX, double mouseY, int button) {
        if (screen instanceof class_485) {
            class_1735 hoveredSlot;
            class_481 creativeScreen;
            class_485 gui = (class_485)screen;
            if (gui instanceof class_481 && !(creativeScreen = (class_481)gui).method_47424()) {
                return true;
            }
            if (LCTrinketsAPI.isValid((class_1309)Screens.getClient((class_437)screen).field_1724)) {
                return true;
            }
            ScreenPosition slotPosition = screen instanceof class_481 ? (ScreenPosition)LCConfig.CLIENT.walletSlotCreative.get() : (ScreenPosition)LCConfig.CLIENT.walletSlot.get();
            if (ClientEventListeners.isMouseOverWalletSlot(mouseX, mouseY, slotPosition = slotPosition.offset(ScreenUtil.getScreenCorner(gui))) && !ClientEventListeners.isMouseOverVisibilityButton(mouseX, mouseY, slotPosition)) {
                boolean shiftHeld;
                class_1799 heldStack = gui.method_17577().method_34255().method_7972();
                boolean bl = shiftHeld = class_437.method_25442() && !(gui instanceof class_481);
                if (gui instanceof class_481) {
                    WalletHandler.WalletSlotInteraction((class_1657)class_310.method_1551().field_1724, -1, false, heldStack);
                }
                new CMessageWalletInteraction(-1, shiftHeld, heldStack).sendToServer();
            } else if (class_437.method_25442() && !(gui instanceof class_481) && (hoveredSlot = ScreenUtil.getFocusedSlot(gui)) != null) {
                class_310 client = Screens.getClient((class_437)screen);
                class_746 player = client.field_1724;
                if (player != null) {
                    int slotIndex;
                    int n = slotIndex = hoveredSlot.field_7871 != player.method_31548() ? -1 : hoveredSlot.method_34266();
                    if (slotIndex < 0) {
                        return true;
                    }
                    class_1799 slotItem = player.method_31548().method_5438(slotIndex);
                    if (WalletSlot.isValidWallet(slotItem)) {
                        class_1799 heldStack = gui.method_17577().method_34255().method_7972();
                        new CMessageWalletInteraction(slotIndex, true, heldStack).sendToServer();
                        return false;
                    }
                }
            }
        }
        return true;
    }

    private static boolean isMouseOverWalletSlot(double mouseX, double mouseY, ScreenPosition slotPosition) {
        return mouseX >= (double)slotPosition.x && mouseX < (double)(slotPosition.x + 18) && mouseY >= (double)slotPosition.y && mouseY < (double)(slotPosition.y + 18);
    }

    private static boolean isMouseOverVisibilityButton(double mouseX, double mouseY, ScreenPosition slotPosition) {
        return mouseX >= (double)slotPosition.x && mouseX < (double)(slotPosition.x + 6) && mouseY >= (double)slotPosition.y && mouseY < (double)(slotPosition.y + 6);
    }
}

