/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.overlay;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenCorner;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import java.util.List;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class WalletDisplayOverlay {
    public static final WalletDisplayOverlay INSTANCE = new WalletDisplayOverlay();
    private boolean sendError = true;

    private WalletDisplayOverlay() {
    }

    public static void setup() {
        HudRenderCallback.EVENT.register(INSTANCE::render);
    }

    private void render(class_332 gui, float partialTick) {
        block12: {
            if (!((Boolean)LCConfig.CLIENT.walletOverlayEnabled.get()).booleanValue()) {
                return;
            }
            try {
                WalletHandler walletHandler;
                class_1799 wallet;
                ScreenCorner corner = (ScreenCorner)((Object)LCConfig.CLIENT.walletOverlayCorner.get());
                ScreenPosition offset = (ScreenPosition)LCConfig.CLIENT.walletOverlayPosition.get();
                int screenWidth = class_310.method_1551().method_22683().method_4486();
                int screenHeight = class_310.method_1551().method_22683().method_4502();
                ScreenPosition currentPosition = corner.getCorner(screenWidth, screenHeight).offset(offset);
                if (corner.isRightSide) {
                    currentPosition = currentPosition.offset(ScreenPosition.of(-16, 0));
                }
                if (corner.isBottomSide) {
                    currentPosition = currentPosition.offset(ScreenPosition.of(0, -16));
                }
                if (!WalletItem.isWallet(wallet = (walletHandler = WalletHandler.getWallet((class_1657)class_310.method_1551().field_1724)).getWallet())) break block12;
                ItemRenderUtil.drawItemStack(gui, null, wallet, currentPosition.x, currentPosition.y);
                currentPosition = corner.isRightSide ? currentPosition.offset(ScreenPosition.of(-17, 0)) : currentPosition.offset(ScreenPosition.of(17, 0));
                CoinValue contents = MoneyUtil.getCoinValue(WalletItem.getWalletInventory(wallet));
                if (!contents.hasAny()) {
                    return;
                }
                switch ((DisplayType)((Object)LCConfig.CLIENT.walletOverlayType.get())) {
                    case ITEMS_NARROW: 
                    case ITEMS_WIDE: {
                        int offsetAmount = LCConfig.CLIENT.walletOverlayType.get() == DisplayType.ITEMS_WIDE ? 17 : 9;
                        List<class_1799> walletContents = MoneyUtil.getCoinsOfValue(contents);
                        for (class_1799 coin : walletContents) {
                            ItemRenderUtil.drawItemStack(gui, null, coin, currentPosition.x, currentPosition.y);
                            if (corner.isRightSide) {
                                currentPosition = currentPosition.offset(ScreenPosition.of(-offsetAmount, 0));
                                continue;
                            }
                            currentPosition = currentPosition.offset(ScreenPosition.of(offsetAmount, 0));
                        }
                        break;
                    }
                    case TEXT: {
                        class_327 font = class_310.method_1551().field_1772;
                        class_5250 walletText = contents.getComponent();
                        ScreenPosition pos = corner.isRightSide ? currentPosition.offset(-1 * font.method_27525((class_5348)walletText), 3) : currentPosition.offset(0, 3);
                        gui.method_51439(font, (class_2561)walletText, pos.x, pos.y, 0xFFFFFF, false);
                    }
                }
            }
            catch (Throwable t) {
                if (!this.sendError) break block12;
                this.sendError = false;
                LightmansCurrency.LogError("Error occurred while rendering wallet overlay!", t);
            }
        }
    }

    public static enum DisplayType {
        ITEMS_WIDE,
        ITEMS_NARROW,
        TEXT;

    }
}

