/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamBankAccountTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamMemberEditTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamMemberListTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamNameTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamOwnerTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamSelectionTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class TeamManagerScreen
extends class_437 {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/teammanager.png");
    public final int xSize = 200;
    public final int ySize = 200;
    private long activeTeamID = -1L;
    List<class_339> tabWidgets = Lists.newArrayList();
    List<class_364> tabListeners = Lists.newArrayList();
    List<TeamTab> tabs = Lists.newArrayList((Object[])new TeamTab[]{TeamSelectionTab.INSTANCE, TeamMemberListTab.INSTANCE, TeamNameTab.INSTANCE, TeamMemberEditTab.INSTANCE, TeamBankAccountTab.INSTANCE, TeamOwnerTab.INSTANCE});
    List<TabButton> tabButtons = new ArrayList<TabButton>();
    int currentTabIndex = 0;

    public static void open() {
        if (RenderSystem.isOnRenderThread()) {
            class_310 client = class_310.method_1551();
            client.method_1507((class_437)new TeamManagerScreen());
        } else {
            ScreenUtil.safelyOpenScreen(new TeamManagerScreen());
        }
    }

    public TeamManagerScreen() {
        super((class_2561)class_2561.method_43473());
        this.tabs.forEach(tab -> tab.setScreen(this));
    }

    public class_1657 getPlayer() {
        return this.field_22787.field_1724;
    }

    public class_327 getFont() {
        return this.field_22793;
    }

    public final int guiLeft() {
        Objects.requireNonNull(this);
        return (this.field_22789 - 200) / 2;
    }

    public final int guiTop() {
        Objects.requireNonNull(this);
        return (this.field_22790 - 200) / 2;
    }

    public Team getActiveTeam() {
        if (this.activeTeamID < 0L) {
            return null;
        }
        Team team = TeamSaveData.GetTeam(true, this.activeTeamID);
        if (team != null && team.isMember(this.getPlayer())) {
            return team;
        }
        return null;
    }

    public void setActiveTeam(long teamID) {
        this.activeTeamID = teamID;
    }

    public TeamTab currentTab() {
        return this.tabs.get(MathUtil.clamp(this.currentTabIndex, 0, this.tabs.size() - 1));
    }

    public void method_25426() {
        for (int i = 0; i < this.tabs.size(); ++i) {
            TabButton button = (TabButton)this.method_37063((class_364)new TabButton(this::clickedOnTab, this.field_22793, this.tabs.get(i)));
            button.field_22763 = i != this.currentTabIndex;
            button.field_22764 = this.tabs.get(i).allowViewing(this.getPlayer(), this.getActiveTeam());
            this.tabButtons.add(button);
        }
        this.positionTabButtons();
        this.currentTab().initTab();
    }

    private int getTabPosX(int index) {
        if (index < 8) {
            return this.guiLeft() + 25 * index;
        }
        if (index < 16) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            return n + 200;
        }
        if (index < 24) {
            int n = this.guiLeft();
            Objects.requireNonNull(this);
            return n + 200 - 25 * (index - 15);
        }
        return this.guiLeft() - 25;
    }

    private int getTabPosY(int index) {
        if (index < 8) {
            return this.guiTop() - 25;
        }
        if (index < 16) {
            return this.guiTop() + 25 * (index - 10);
        }
        if (index < 24) {
            int n = this.guiTop();
            Objects.requireNonNull(this);
            return n + 200;
        }
        int n = this.guiTop();
        Objects.requireNonNull(this);
        return n + 200 - 25 * (index - 23);
    }

    private int getTabRotation(int index) {
        if (index < 8) {
            return 0;
        }
        if (index < 16) {
            return 1;
        }
        if (index < 24) {
            return 2;
        }
        return 3;
    }

    private void positionTabButtons() {
        int index = 0;
        for (TabButton thisButton : this.tabButtons) {
            if (!thisButton.field_22764) continue;
            thisButton.reposition(this.getTabPosX(index), this.getTabPosY(index), this.getTabRotation(index));
            ++index;
        }
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.method_25420(gui);
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        int n = this.guiLeft();
        int n2 = this.guiTop();
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        gui.method_25302(GUI_TEXTURE, n, n2, 0, 0, 200, 200);
        super.method_25394(gui, mouseX, mouseY, partialTicks);
        try {
            this.currentTab().preRender(gui, mouseX, mouseY, partialTicks);
            this.tabWidgets.forEach(widget -> widget.method_25394(gui, mouseX, mouseY, partialTicks));
            this.currentTab().postRender(gui, mouseX, mouseY, partialTicks);
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (TabButton tabButton : this.tabButtons) {
            if (!tabButton.method_25405(mouseX, mouseY)) continue;
            gui.method_51438(this.field_22793, (class_2561)tabButton.tab.getTooltip(), mouseX, mouseY);
        }
    }

    public void method_25393() {
        if (this.activeTeamID < 0L && this.currentTabIndex != 0) {
            this.changeTab(0);
        }
        boolean updateTabs = false;
        for (int i = 0; i < this.tabs.size(); ++i) {
            boolean visible = this.tabs.get(i).allowViewing(this.getPlayer(), this.getActiveTeam());
            if (visible == this.tabButtons.get((int)i).field_22764) continue;
            updateTabs = true;
            this.tabButtons.get((int)i).field_22764 = visible;
        }
        if (updateTabs) {
            this.positionTabButtons();
        }
        if (!this.currentTab().allowViewing(this.getPlayer(), this.getActiveTeam()) && this.currentTabIndex != 0) {
            this.changeTab(0);
        }
        this.currentTab().tick();
    }

    public <T extends class_339> T addRenderableTabWidget(T widget) {
        this.tabWidgets.add(widget);
        return widget;
    }

    public void removeRenderableTabWidget(class_339 widget) {
        this.tabWidgets.remove(widget);
    }

    public <T extends class_364> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public void removeTabListener(class_364 listener) {
        this.tabListeners.remove(listener);
    }

    public void changeTab(int tabIndex) {
        if (!this.tabs.get(tabIndex).allowViewing(this.getPlayer(), this.getActiveTeam())) {
            return;
        }
        this.currentTab().closeTab();
        this.tabButtons.get((int)this.currentTabIndex).field_22763 = true;
        this.currentTabIndex = tabIndex;
        this.tabButtons.get((int)this.currentTabIndex).field_22763 = false;
        this.tabWidgets.clear();
        this.tabListeners.clear();
        this.currentTab().initTab();
    }

    private void clickedOnTab(class_4185 tab) {
        int tabIndex = this.tabButtons.indexOf(tab);
        if (tabIndex < 0) {
            return;
        }
        this.changeTab(tabIndex);
    }

    public List<? extends class_364> method_25396() {
        List coreListeners = super.method_25396();
        ArrayList listeners = Lists.newArrayList();
        listeners.addAll(coreListeners);
        listeners.addAll(this.tabWidgets);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean method_25421() {
        return false;
    }
}

