/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.MenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.ITab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.tab.TabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.notifications.NotificationDisplayWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.IScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.LazyWidgetPositioner;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageOpenTrades;
import io.github.lightman314.lightmanscurrency.network.server.messages.trader.CMessageStoreCoins;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1661;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class TraderStorageScreen
extends MenuScreen<TraderStorageMenu>
implements TraderStorageMenu.IClientMessage,
IScreen {
    Map<Integer, TraderStorageClientTab<?>> availableTabs = new HashMap();
    Map<Integer, TabButton> tabButtons = new HashMap<Integer, TabButton>();
    class_4185 buttonShowTrades;
    class_4185 buttonCollectMoney;
    class_4185 buttonOpenSettings;
    class_4185 buttonStoreMoney;
    class_4185 buttonShowLog;
    NotificationDisplayWidget logWindow;
    class_4185 buttonTradeRules;
    List<class_339> tabRenderables = new ArrayList<class_339>();
    List<class_364> tabListeners = new ArrayList<class_364>();
    private final List<Runnable> tickListeners = new ArrayList<Runnable>();

    public TraderStorageClientTab<?> currentTab() {
        return this.availableTabs.get(((TraderStorageMenu)this.field_2797).getCurrentTabIndex());
    }

    public TraderStorageScreen(TraderStorageMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
        ((TraderStorageMenu)this.field_2797).getAllTabs().forEach((key, tab) -> this.availableTabs.put((Integer)key, tab.createClientTab(this)));
        this.field_2792 = 206;
        this.field_2779 = 236;
        menu.addMessageListener(this::serverMessage);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.tabRenderables.clear();
        this.tabListeners.clear();
        this.tabButtons.clear();
        this.availableTabs.forEach((key, tab) -> {
            if (tab.tabButtonVisible()) {
                TabButton newButton = (TabButton)this.method_37063((class_364)new TabButton(button -> this.changeTab((int)key), this.field_22793, (ITab)tab));
                if (key.intValue() == ((TraderStorageMenu)this.field_2797).getCurrentTabIndex()) {
                    newButton.field_22763 = false;
                }
                this.tabButtons.put((Integer)key, newButton);
            }
        });
        int xPos = this.field_2776 - 25;
        AtomicInteger index = new AtomicInteger(0);
        this.tabButtons.forEach((key, button) -> {
            int yPos = this.field_2800 + 25 * index.get();
            button.reposition(xPos, yPos, 3);
            index.set(index.get() + 1);
        });
        this.buttonShowTrades = (class_4185)this.method_37063((class_364)IconAndButtonUtil.traderButton(this.field_2776 + 15 - 20, this.field_2800 + 118, this::PressTradesButton));
        this.buttonCollectMoney = (class_4185)this.method_37063((class_364)IconAndButtonUtil.collectCoinButton(this.field_2776 + 15 - 20, this.field_2800 + 138, this::PressCollectionButton, ((TraderStorageMenu)this.field_2797).player, ((TraderStorageMenu)this.field_2797)::getTrader));
        this.buttonCollectMoney.field_22764 = ((TraderStorageMenu)this.field_2797).hasPermission("collectCoins") && !((TraderStorageMenu)this.field_2797).getTrader().hasBankAccount();
        this.buttonStoreMoney = (class_4185)this.method_37063((class_364)IconAndButtonUtil.storeCoinButton(this.field_2776 + 15 + 176, this.field_2800 + 158, this::PressStoreCoinsButton));
        this.buttonStoreMoney.field_22764 = false;
        this.buttonOpenSettings = (class_4185)this.method_37063((class_364)IconAndButtonUtil.openSettingsButton(this.field_2776 + 15 + 176, this.field_2800 + 118, this::PressSettingsButton));
        this.buttonOpenSettings.field_22764 = ((TraderStorageMenu)this.field_2797).hasPermission("editSettings");
        this.buttonTradeRules = (class_4185)this.method_37063((class_364)IconAndButtonUtil.tradeRuleButton(this.field_2776 + 15 + 176, this.field_2800 + 138, this::PressTradeRulesButton, () -> this.currentTab().getTradeRuleTradeIndex() >= 0));
        this.buttonTradeRules.field_22764 = ((TraderStorageMenu)this.field_2797).hasPermission("editTradeRules");
        this.buttonShowLog = (class_4185)this.method_37063((class_364)IconAndButtonUtil.showLoggerButton(this.field_2776 + 15 - 20, this.field_2800 + 158, this::PressLogButton, () -> false));
        this.logWindow = (NotificationDisplayWidget)this.method_37063((class_364)new NotificationDisplayWidget(this.field_2776 + 15, this.field_2800, this.field_2792 - 30, this.field_2779 / 22, this.field_22793, () -> {
            TraderData trader = ((TraderStorageMenu)this.field_2797).getTrader();
            return trader != null ? trader.getNotifications() : new ArrayList();
        }));
        this.logWindow.field_22764 = false;
        LazyWidgetPositioner.create(this, LazyWidgetPositioner.MODE_TOPDOWN, -5, 118, 20, new class_339[]{this.buttonShowTrades, this.buttonCollectMoney, this.buttonShowLog});
        LazyWidgetPositioner.create(this, LazyWidgetPositioner.MODE_TOPDOWN, 191, 118, 20, new class_339[]{this.buttonStoreMoney, this.buttonOpenSettings, this.buttonTradeRules});
        this.currentTab().onOpen();
        this.method_37432();
    }

    protected void method_2389(class_332 gui, float partialTicks, int mouseX, int mouseY) {
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        gui.method_25302(TraderScreen.GUI_TEXTURE, this.field_2776, this.field_2800, 0, 0, this.field_2792, this.field_2779);
        for (CoinSlot slot : ((TraderStorageMenu)this.field_2797).getCoinSlots()) {
            if (!slot.method_7682()) continue;
            gui.method_25302(TraderScreen.GUI_TEXTURE, this.field_2776 + slot.field_7873 - 1, this.field_2800 + slot.field_7872 - 1, this.field_2792, 0, 18, 18);
        }
        try {
            this.currentTab().renderBG(gui, mouseX, mouseY, partialTicks);
            this.tabRenderables.forEach(widget -> widget.method_25394(gui, mouseX, mouseY, partialTicks));
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error rendering trader storage tab " + this.currentTab().getClass().getName(), e);
        }
    }

    protected void method_2388(class_332 gui, int mouseX, int mouseY) {
        gui.method_51439(this.field_22793, this.field_29347, 23, this.field_2779 - 94, 0x404040, false);
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (((TraderStorageMenu)this.field_2797).getTrader() == null) {
            ((TraderStorageMenu)this.field_2797).closeMenu(((TraderStorageMenu)this.field_2797).player);
            return;
        }
        this.method_25420(gui);
        if (this.logWindow != null && this.logWindow.field_22764) {
            this.logWindow.method_25394(gui, mouseX, mouseY, partialTicks);
            this.buttonShowLog.method_25394(gui, mouseX, mouseY, partialTicks);
            this.logWindow.tryRenderTooltip(gui, mouseX, mouseY);
            return;
        }
        super.method_25394(gui, mouseX, mouseY, partialTicks);
        this.method_2380(gui, mouseX, mouseY);
        try {
            this.currentTab().renderTooltips(gui, mouseX, mouseY);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error rendering trader storage tab tooltips " + this.currentTab().getClass().getName(), e);
        }
        this.tabButtons.forEach((key, button) -> {
            if (button.method_25405(mouseX, mouseY)) {
                gui.method_51438(this.field_22793, (class_2561)button.tab.getTooltip(), mouseX, mouseY);
            }
        });
    }

    @Override
    protected void method_37432() {
        if (((TraderStorageMenu)this.field_2797).getTrader() == null) {
            ((TraderStorageMenu)this.field_2797).closeMenu(((TraderStorageMenu)this.field_2797).player);
            return;
        }
        ((TraderStorageMenu)this.field_2797).validateCoinSlots();
        if (!((TraderStorageMenu)this.field_2797).hasPermission("openStorage")) {
            ((TraderStorageMenu)this.field_2797).closeMenu(((TraderStorageMenu)this.field_2797).player);
            new CMessageOpenTrades(((TraderStorageMenu)this.field_2797).getTrader().getID()).sendToServer();
            return;
        }
        this.buttonOpenSettings.field_22764 = ((TraderStorageMenu)this.field_2797).hasPermission("editSettings");
        this.buttonTradeRules.field_22764 = ((TraderStorageMenu)this.field_2797).hasPermission("editTradeRules");
        this.buttonStoreMoney.field_22764 = ((TraderStorageMenu)this.field_2797).HasCoinsToAdd() && ((TraderStorageMenu)this.field_2797).hasPermission("storeCoins");
        this.buttonShowLog.field_22764 = ((TraderStorageMenu)this.field_2797).hasPermission("viewLogs");
        this.currentTab().tick();
        for (Runnable r : this.tickListeners) {
            r.run();
        }
    }

    public boolean method_25404(int keyCode, int scanCode, int modifier) {
        if (this.currentTab().blockInventoryClosing() && this.field_22787.field_1690.field_1822.method_1417(keyCode, scanCode)) {
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifier);
    }

    private TabButton getTabButton(int key) {
        if (this.tabButtons.containsKey(key)) {
            return this.tabButtons.get(key);
        }
        return null;
    }

    public void changeTab(int newTab) {
        this.changeTab(newTab, true, null);
    }

    public void changeTab(int newTab, boolean sendMessage, class_2487 selfMessage) {
        if (newTab == ((TraderStorageMenu)this.field_2797).getCurrentTabIndex()) {
            return;
        }
        int oldTab = ((TraderStorageMenu)this.field_2797).getCurrentTabIndex();
        this.currentTab().onClose();
        TabButton button = this.getTabButton(((TraderStorageMenu)this.field_2797).getCurrentTabIndex());
        if (button != null) {
            button.field_22763 = true;
        }
        this.tabRenderables.clear();
        this.tabListeners.clear();
        ((TraderStorageMenu)this.field_2797).changeTab(newTab);
        button = this.getTabButton(((TraderStorageMenu)this.field_2797).getCurrentTabIndex());
        if (button != null) {
            button.field_22763 = false;
        }
        if (selfMessage != null) {
            this.currentTab().receiveSelfMessage(selfMessage);
        }
        this.currentTab().onOpen();
        if (oldTab != ((TraderStorageMenu)this.field_2797).getCurrentTabIndex() && sendMessage) {
            ((TraderStorageMenu)this.field_2797).sendMessage(((TraderStorageMenu)this.field_2797).createTabChangeMessage(newTab, selfMessage));
        }
    }

    @Override
    public void selfMessage(class_2487 message) {
        if (message.method_10573("ChangeTab", 3)) {
            this.changeTab(message.method_10550("ChangeTab"), false, message);
        } else {
            this.currentTab().receiveSelfMessage(message);
        }
    }

    public void serverMessage(class_2487 message) {
        this.currentTab().receiveServerMessage(message);
    }

    public <T extends class_339> T addRenderableTabWidget(T widget) {
        this.tabRenderables.add(widget);
        return widget;
    }

    public <T extends class_4068> void removeRenderableTabWidget(T widget) {
        this.tabRenderables.remove(widget);
    }

    public <T extends class_364> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public <T extends class_364> void removeTabListener(T listener) {
        this.tabListeners.remove(listener);
    }

    public List<? extends class_364> method_25396() {
        List coreListeners = super.method_25396();
        ArrayList listeners = Lists.newArrayList();
        listeners.addAll(coreListeners);
        listeners.addAll(this.tabRenderables);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        try {
            if (this.currentTab().mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        try {
            if (this.currentTab().mouseReleased(mouseX, mouseY, button)) {
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.method_25406(mouseX, mouseY, button);
    }

    private void PressTradesButton(class_4185 button) {
        new CMessageOpenTrades(((TraderStorageMenu)this.field_2797).getTrader().getID()).sendToServer();
    }

    private void PressCollectionButton(class_4185 button) {
        if (((TraderStorageMenu)this.field_2797).hasPermission("collectCoins")) {
            new CMessageCollectCoins().sendToServer();
        } else {
            Permissions.PermissionWarning(((TraderStorageMenu)this.field_2797).player, "collect stored coins", "collectCoins");
        }
    }

    private void PressStoreCoinsButton(class_4185 button) {
        if (((TraderStorageMenu)this.field_2797).hasPermission("storeCoins")) {
            new CMessageStoreCoins().sendToServer();
        } else {
            Permissions.PermissionWarning(((TraderStorageMenu)this.field_2797).player, "store coins", "storeCoins");
        }
    }

    private void PressLogButton(class_4185 button) {
        this.logWindow.field_22764 = !this.logWindow.field_22764;
    }

    private void PressTradeRulesButton(class_4185 button) {
        ((TraderStorageMenu)this.field_2797).closeMenu(((TraderStorageMenu)this.field_2797).player);
        class_310.method_1551().method_1507((class_437)new TradeRuleScreen(((TraderStorageMenu)this.field_2797).getTrader().getID(), this.currentTab().getTradeRuleTradeIndex()));
    }

    private void PressSettingsButton(class_4185 button) {
        ((TraderStorageMenu)this.field_2797).closeMenu(((TraderStorageMenu)this.field_2797).player);
        class_310.method_1551().method_1507((class_437)new TraderSettingsScreen(((TraderStorageMenu)this.field_2797).traderSource));
    }

    @Override
    public void addTickListener(Runnable r) {
        this.tickListeners.add(r);
    }
}

