/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menu.ATMMenu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageBankTransferPlayer;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageBankTransferTeam;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class TransferTab
extends ATMTab {
    public static final int RESPONSE_DURATION = 100;
    private int responseTimer = 0;
    CoinValueInput amountWidget;
    class_342 playerInput;
    TeamSelectWidget teamSelection;
    IconButton buttonToggleMode;
    class_4185 buttonTransfer;
    long selectedTeam = -1L;
    boolean playerMode = true;

    public TransferTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORE_COINS;
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.atm.transfer");
    }

    @Override
    public void init() {
        SimpleSlot.SetInactive(this.screen.method_17577());
        this.responseTimer = 0;
        ((ATMMenu)this.screen.method_17577()).clearMessage();
        this.amountWidget = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft(), this.screen.getGuiTop(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.bank.transfertip"), CoinValue.EMPTY, this.screen.getFont(), value -> {}, this.screen::addRenderableTabWidget));
        this.amountWidget.init();
        this.amountWidget.allowFreeToggle = false;
        this.amountWidget.drawBG = false;
        this.buttonToggleMode = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getImageWidth() - 30, this.screen.getGuiTop() + 64, this::ToggleMode, this.playerMode ? IconData.of((class_1935)class_1802.field_8575) : IconData.of(ItemRenderUtil.getAlexHead()), (Supplier<class_7919>)new IconAndButtonUtil.ToggleTooltip(() -> this.playerMode, (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.atm.transfer.mode.team"), (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.atm.transfer.mode.player"))));
        this.playerInput = this.screen.addRenderableTabWidget(new class_342(this.screen.getFont(), this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 104, this.screen.getImageWidth() - 20, 20, (class_2561)class_2561.method_43473()));
        this.playerInput.field_22764 = this.playerMode;
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 84, 2, TeamButton.Size.NORMAL, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.screen.getFont());
        this.teamSelection.field_22764 = !this.playerMode;
        this.buttonTransfer = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 126, this.screen.getImageWidth() - 20, 20, (class_2561)class_2561.method_43471((String)(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team")), this::PressTransfer));
        this.buttonTransfer.field_22763 = false;
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        BankAccount.AccountReference source = ((ATMMenu)this.screen.method_17577()).getBankAccountReference();
        Team blockTeam = null;
        if (source != null && source.accountType == BankAccount.AccountType.Team) {
            blockTeam = TeamSaveData.GetTeam(true, source.teamID);
        }
        for (Team team : TeamSaveData.GetAllTeams(true)) {
            if (!team.hasBankAccount() || team == blockTeam) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.selectedTeam >= 0L) {
            return TeamSaveData.GetTeam(true, this.selectedTeam);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            if (team.getID() == this.selectedTeam) {
                return;
            }
            this.selectedTeam = team.getID();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PressTransfer(class_4185 button) {
        if (this.playerMode) {
            new CMessageBankTransferPlayer(this.playerInput.method_1882(), this.amountWidget.getCoinValue()).sendToServer();
            this.playerInput.method_1852("");
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        } else if (this.selectedTeam >= 0L) {
            new CMessageBankTransferTeam(this.selectedTeam, this.amountWidget.getCoinValue()).sendToServer();
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        }
    }

    private void ToggleMode(class_4185 button) {
        this.playerMode = !this.playerMode;
        this.buttonTransfer.method_25355((class_2561)class_2561.method_43471((String)(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team")));
        this.teamSelection.field_22764 = !this.playerMode;
        this.playerInput.field_22764 = this.playerMode;
        this.buttonToggleMode.setIcon(this.playerMode ? IconData.of((class_1935)class_1802.field_8575) : IconData.of(ItemRenderUtil.getAlexHead()));
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.hideCoinSlots(gui);
        class_5250 balance = ((ATMMenu)this.screen.method_17577()).getBankAccount() == null ? class_2561.method_43471((String)"gui.lightmanscurrency.bank.null") : class_2561.method_43469((String)"gui.lightmanscurrency.bank.balance", (Object[])new Object[]{((ATMMenu)this.screen.method_17577()).getBankAccount().getCoinStorage().getString("0")});
        gui.method_51439(this.screen.getFont(), (class_2561)balance, this.screen.getGuiLeft() + 8, this.screen.getGuiTop() + 72, 0x404040, false);
        if (this.hasMessage()) {
            TextRenderUtil.drawCenteredMultilineText(gui, this.getMessage(), this.screen.getGuiLeft() + 2, this.screen.getImageWidth() - 4, this.screen.getGuiTop() + 5, 0x404040);
            this.amountWidget.field_22764 = false;
        } else {
            this.amountWidget.field_22764 = true;
        }
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY) {
    }

    @Override
    public void tick() {
        this.amountWidget.tick();
        if (this.playerMode) {
            this.playerInput.method_1865();
            this.buttonTransfer.field_22763 = !this.playerInput.method_1882().isBlank() && this.amountWidget.getCoinValue().isValid();
        } else {
            Team team = this.selectedTeam();
            boolean bl = this.buttonTransfer.field_22763 = team != null && team.hasBankAccount() && this.amountWidget.getCoinValue().isValid();
        }
        if (this.hasMessage()) {
            ++this.responseTimer;
            if (this.responseTimer >= 100) {
                this.responseTimer = 0;
                ((ATMMenu)this.screen.method_17577()).clearMessage();
            }
        }
    }

    private boolean hasMessage() {
        return ((ATMMenu)this.screen.method_17577()).hasTransferMessage();
    }

    private class_2561 getMessage() {
        return ((ATMMenu)this.screen.method_17577()).getTransferMessage();
    }

    @Override
    public void onClose() {
        SimpleSlot.SetActive(this.screen.method_17577());
        this.responseTimer = 0;
        ((ATMMenu)this.screen.method_17577()).clearMessage();
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.playerMode;
    }
}

