/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.auction;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.trader.TraderClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.server.messages.auction.CMessageSubmitBid;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;

public class AuctionBidTab
extends TraderClientTab {
    private final long auctionHouseID;
    private final int tradeIndex;
    TradeButton tradeDisplay;
    CoinValueInput bidAmount;
    class_4185 bidButton;
    class_4185 closeButton;

    private AuctionHouseTrader getAuctionHouse() {
        TraderData data = TraderSaveData.GetTrader(true, this.auctionHouseID);
        if (data instanceof AuctionHouseTrader) {
            return (AuctionHouseTrader)data;
        }
        return null;
    }

    private AuctionTradeData getTrade() {
        AuctionHouseTrader trader = this.getAuctionHouse();
        if (trader != null) {
            return trader.getTrade(this.tradeIndex);
        }
        return null;
    }

    public AuctionBidTab(TraderScreen screen, long auctionHouseID, int tradeIndex) {
        super(screen);
        this.auctionHouseID = auctionHouseID;
        this.tradeIndex = tradeIndex;
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void onOpen() {
        if (this.getTrade() == null) {
            return;
        }
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(() -> this.menu.getContext(this.getAuctionHouse()), this::getTrade, b -> {}));
        this.tradeDisplay.method_48229(this.screen.getGuiLeft() + this.screen.getImageWidth() / 2 - this.tradeDisplay.method_25368() / 2, this.screen.getGuiTop() + 5);
        this.bidAmount = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft() + this.screen.getImageWidth() / 2 - 88, this.screen.getGuiTop() + 10 + this.tradeDisplay.method_25364(), (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.auction.bidamount"), this.getTrade().getMinNextBid(), this.font, v -> {}, this.screen::addRenderableTabWidget));
        this.bidAmount.init();
        this.bidAmount.allowFreeToggle = false;
        this.bidAmount.drawBG = false;
        this.bidButton = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 22, this.screen.getGuiTop() + 119, 68, 20, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.auction.bid"), this::SubmitBid));
        this.closeButton = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + this.screen.getImageWidth() - 25, this.screen.getGuiTop() + 5, 20, 20, (class_2561)class_2561.method_43470((String)"X").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), this::close));
        this.tick();
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
        this.tradeDisplay.renderTooltips(gui, this.font, mouseX, mouseY);
    }

    @Override
    public void tick() {
        if (this.getTrade() == null) {
            this.screen.closeTab();
            return;
        }
        if (this.bidAmount != null) {
            CoinValue minBid;
            long bidQuery = this.bidAmount.getCoinValue().getRawValue();
            if (bidQuery < (minBid = this.getTrade().getMinNextBid()).getRawValue()) {
                this.bidAmount.setCoinValue(this.getTrade().getMinNextBid());
            }
            this.bidButton.field_22763 = this.menu.getContext(this.getAuctionHouse()).getAvailableFunds() >= bidQuery;
            this.bidAmount.tick();
        }
    }

    private void SubmitBid(class_4185 button) {
        new CMessageSubmitBid(this.auctionHouseID, this.tradeIndex, this.bidAmount.getCoinValue()).sendToServer();
        this.screen.closeTab();
    }

    private void close(class_4185 button) {
        this.screen.closeTab();
    }
}

