/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.base;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.blockentity.traderinterface.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.common.menu.traderinterface.base.InfoTab;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class InfoClientTab
extends TraderInterfaceClientTab<InfoTab> {
    TradeButton tradeDisplay;
    TradeButton newTradeDisplay;
    ScrollTextDisplay changesDisplay;
    DropdownWidget interactionDropdown;
    class_4185 acceptChangesButton;

    public InfoClientTab(TraderInterfaceScreen screen, InfoTab tab) {
        super(screen, tab);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)class_1802.field_8407);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.interface.info");
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void onOpen() {
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(this.menu::getTradeContext, this.menu.getTraderInterface()::getReferencedTrade, TradeButton.NULL_PRESS));
        this.tradeDisplay.method_48229(this.screen.getGuiLeft() + 6, this.screen.getGuiTop() + 20);
        this.tradeDisplay.displayOnly = true;
        this.newTradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(this.menu::getTradeContext, this.menu.getTraderInterface()::getTrueTrade, TradeButton.NULL_PRESS));
        this.newTradeDisplay.field_22764 = false;
        this.newTradeDisplay.displayOnly = true;
        this.interactionDropdown = this.screen.addRenderableTabWidget(IconAndButtonUtil.interactionTypeDropdown(this.screen.getGuiLeft() + 104, this.screen.getGuiTop() + 20, 97, this.font, this.menu.getTraderInterface().getInteractionType(), this::onInteractionSelect, this.screen::addRenderableTabWidget, this.menu.getTraderInterface().getBlacklistedInteractions()));
        this.changesDisplay = this.screen.addRenderableTabWidget(new ScrollTextDisplay(this.screen.getGuiLeft() + 104, this.screen.getGuiTop() + 36, 97, 73, this.font, (Supplier<List<? extends class_2561>>)((Supplier)this::getMessages)));
        this.changesDisplay.backgroundColor = 0;
        this.acceptChangesButton = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getImageWidth(), this.screen.getGuiTop() + 40, this::AcceptTradeChanges, IconAndButtonUtil.ICON_CHECKMARK, (java.util.function.Supplier<class_7919>)new IconAndButtonUtil.SimpleTooltip((class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.interface.info.acceptchanges"))));
        this.acceptChangesButton.field_22764 = false;
    }

    private List<class_2561> getMessages() {
        TraderData trader;
        if (this.menu.getTraderInterface() == null) {
            return new ArrayList<class_2561>();
        }
        ArrayList<class_2561> list = new ArrayList<class_2561>();
        TradeContext.TradeResult result = this.menu.getTraderInterface().mostRecentTradeResult();
        if (result.failMessage != null) {
            list.add(result.failMessage);
        }
        if (this.menu.getTraderInterface().getInteractionType().trades) {
            TradeData referencedTrade = this.menu.getTraderInterface().getReferencedTrade();
            TradeData trueTrade = this.menu.getTraderInterface().getTrueTrade();
            if (referencedTrade == null) {
                return new ArrayList<class_2561>();
            }
            if (trueTrade == null) {
                list.add((class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.interface.difference.missing").method_27692(class_124.field_1061));
                return list;
            }
            TradeData.TradeComparisonResult differences = referencedTrade.compare(trueTrade);
            if (!differences.TypeMatches()) {
                list.add((class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.interface.difference.type").method_27692(class_124.field_1061));
                return list;
            }
            list.addAll(referencedTrade.GetDifferenceWarnings(differences));
            return list;
        }
        if (this.menu.getTraderInterface().getInteractionType().requiresPermissions && (trader = this.menu.getTraderInterface().getTrader()) != null && !trader.hasPermission(this.menu.getTraderInterface().getReferencedPlayer(), "interactionLink")) {
            list.add((class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.interface.info.trader.permissions").method_27692(class_124.field_1061));
        }
        return list;
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        BankAccount account;
        if (this.menu.getTraderInterface() == null) {
            return;
        }
        TraderData trader = this.menu.getTraderInterface().getTrader();
        class_5250 infoText = trader != null ? trader.getTitle() : (this.menu.getTraderInterface().hasTrader() ? class_2561.method_43471((String)"gui.lightmanscurrency.interface.info.trader.removed").method_27692(class_124.field_1061) : class_2561.method_43471((String)"gui.lightmanscurrency.interface.info.trader.null"));
        gui.method_51439(this.font, TextRenderUtil.fitString((class_2561)infoText, this.screen.getImageWidth() - 16), this.screen.getGuiLeft() + 8, this.screen.getGuiTop() + 6, 0x404040, false);
        this.tradeDisplay.field_22764 = this.menu.getTraderInterface().getInteractionType().trades;
        this.acceptChangesButton.field_22764 = this.newTradeDisplay.field_22764 = this.tradeDisplay.field_22764 && this.changeInTrades();
        if (this.tradeDisplay.field_22764 && this.menu.getTraderInterface().getReferencedTrade() == null) {
            gui.method_51439(this.font, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.interface.info.trade.notdefined"), this.screen.getGuiLeft() + 6, this.screen.getGuiTop() + 20, 0x404040, false);
        }
        if (this.newTradeDisplay.field_22764) {
            this.newTradeDisplay.method_48229(this.screen.getGuiLeft() + 6, this.screen.getGuiTop() + 109 - this.newTradeDisplay.method_25364());
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            gui.method_25302(TraderInterfaceScreen.GUI_TEXTURE, this.screen.getGuiLeft() - 2 + this.tradeDisplay.method_25368() / 2, this.screen.getGuiTop() + 54, 206, 18, 16, 22);
            if (this.menu.getTraderInterface().getTrueTrade() == null) {
                class_5250 class_52502 = class_2561.method_43471((String)"gui.lightmanscurrency.interface.info.trade.missing").method_27692(class_124.field_1061);
                int n = this.screen.getGuiLeft() + 6;
                int n2 = this.screen.getGuiTop() + 109;
                Objects.requireNonNull(this.font);
                gui.method_51439(this.font, (class_2561)class_52502, n, n2 - 9, 0x404040, false);
            }
        }
        if ((account = this.menu.getTraderInterface().getBankAccount()) != null && this.menu.getTraderInterface().getInteractionType().trades) {
            class_2561 accountName = TextRenderUtil.fitString((class_2561)account.getName(), 160);
            gui.method_51439(this.font, accountName, this.screen.getGuiLeft() + 15 + 88 - this.font.method_27525((class_5348)accountName) / 2, this.screen.getGuiTop() + 120, 0x404040, false);
            class_5250 balanceText = class_2561.method_43469((String)"gui.lightmanscurrency.bank.balance", (Object[])new Object[]{account.getCoinStorage().getString("0")});
            gui.method_51439(this.font, (class_2561)balanceText, this.screen.getGuiLeft() + 15 + 88 - this.font.method_27525((class_5348)balanceText) / 2, this.screen.getGuiTop() + 130, 0x404040, false);
        }
    }

    public boolean changeInTrades() {
        TradeData referencedTrade = this.menu.getTraderInterface().getReferencedTrade();
        TradeData trueTrade = this.menu.getTraderInterface().getTrueTrade();
        if (referencedTrade == null) {
            return false;
        }
        if (trueTrade == null) {
            return true;
        }
        return !referencedTrade.compare(trueTrade).Identical();
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
        if (this.menu.getTraderInterface() == null) {
            return;
        }
        this.tradeDisplay.renderTooltips(gui, this.font, mouseX, mouseY);
        this.newTradeDisplay.renderTooltips(gui, this.font, mouseX, mouseY);
    }

    @Override
    public void tick() {
    }

    @Override
    public void onClose() {
    }

    private void onInteractionSelect(int newTypeIndex) {
        TraderInterfaceBlockEntity.InteractionType newType = TraderInterfaceBlockEntity.InteractionType.fromIndex(newTypeIndex);
        ((InfoTab)this.commonTab).changeInteractionType(newType);
    }

    private void AcceptTradeChanges(class_4185 button) {
        ((InfoTab)this.commonTab).acceptTradeChanges();
    }
}

