/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TimeInputWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.auction.AuctionCreateTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.auction.tradedata.AuctionTradeData;
import io.github.lightman314.lightmanscurrency.network.server.messages.persistentdata.CMessageAddPersistentAuction;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import java.util.function.Supplier;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_7919;
import org.jetbrains.annotations.NotNull;

public class AuctionCreateClientTab
extends TraderStorageClientTab<AuctionCreateTab> {
    public static final long CLOSE_DELAY = 5000L;
    AuctionTradeData pendingAuction;
    TradeButton tradeDisplay;
    CoinValueInput priceSelect;
    class_4185 buttonTogglePriceMode;
    boolean startingBidMode = true;
    class_4185 buttonSubmitAuction;
    boolean locked = false;
    long successTime = 0L;
    class_4185 buttonSubmitPersistentAuction;
    class_342 persistentAuctionIDInput;
    TimeInputWidget timeInput;

    public AuctionCreateClientTab(TraderStorageScreen screen, AuctionCreateTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_PLUS;
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.auction.create");
    }

    @Override
    public boolean tabButtonVisible() {
        return true;
    }

    @Override
    public boolean blockInventoryClosing() {
        return CommandLCAdmin.isAdminPlayer(this.menu.player);
    }

    @Override
    public void onOpen() {
        this.pendingAuction = new AuctionTradeData(this.menu.player);
        this.locked = false;
        this.successTime = 0L;
        this.startingBidMode = true;
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(this.menu::getContext, () -> this.pendingAuction, b -> {}));
        this.tradeDisplay.method_48229(this.screen.getGuiLeft() + 15, this.screen.getGuiTop() + 5);
        this.priceSelect = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft() + this.screen.getImageWidth() / 2 - 88, this.screen.getGuiTop() + 34, (class_2561)class_2561.method_43473(), CoinValue.EMPTY, this.font, this::onPriceChanged, this.screen::addRenderableTabWidget));
        this.priceSelect.init();
        this.priceSelect.allowFreeToggle = false;
        this.priceSelect.drawBG = false;
        this.buttonTogglePriceMode = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 114, this.screen.getGuiTop() + 5, this.screen.getImageWidth() - 119, 20, (class_2561)class_2561.method_43471((String)"button.lightmanscurrency.auction.toggleprice.startingbid"), b -> this.TogglePriceTarget()));
        ((AuctionCreateTab)this.commonTab).getAuctionItems().method_5489(c -> this.UpdateAuctionItems());
        this.timeInput = this.screen.addRenderableTabWidget(new TimeInputWidget(this.screen.getGuiLeft() + 80, this.screen.getGuiTop() + 112, 10, TimeUtil.TimeUnit.DAY, TimeUtil.TimeUnit.HOUR, this.screen::addRenderableTabWidget, this::updateDuration));
        this.timeInput.minDuration = Math.max((long)((Integer)LCConfig.SERVER.auctionHouseDurationMin.get()).intValue() * 86400000L, 3600000L);
        this.timeInput.maxDuration = (long)Math.max((Integer)LCConfig.SERVER.auctionHouseDurationMax.get(), (Integer)LCConfig.SERVER.auctionHouseDurationMin.get()) * 86400000L;
        this.timeInput.setTime(this.timeInput.minDuration);
        this.buttonSubmitAuction = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 40, this.screen.getGuiTop() - 20, this.screen.getImageWidth() - 80, 20, (class_2561)class_2561.method_43471((String)"button.lightmanscurrency.auction.create"), b -> this.submitAuction()));
        this.buttonSubmitAuction.field_22763 = false;
        this.buttonSubmitPersistentAuction = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getImageWidth() - 20, this.screen.getGuiTop() - 20, this::submitPersistentAuction, IconAndButtonUtil.ICON_PERSISTENT_DATA, (Supplier<class_7919>)IconAndButtonUtil.TOOLTIP_PERSISTENT_AUCTION));
        this.buttonSubmitPersistentAuction.field_22764 = CommandLCAdmin.isAdminPlayer(((TraderStorageMenu)this.screen.method_17577()).player);
        this.buttonSubmitPersistentAuction.field_22763 = false;
        int idWidth = this.font.method_27525((class_5348)class_2561.method_43471((String)"gui.lightmanscurrency.settings.persistent.id"));
        this.persistentAuctionIDInput = this.screen.addRenderableTabWidget(new class_342(this.font, this.screen.getGuiLeft() + idWidth + 2, this.screen.getGuiTop() - 40, this.screen.getImageWidth() - idWidth - 2, 18, (class_2561)class_2561.method_43473()));
        this.persistentAuctionIDInput.field_22764 = CommandLCAdmin.isAdminPlayer(((TraderStorageMenu)this.screen.method_17577()).player);
    }

    @Override
    public void onClose() {
        ((AuctionCreateTab)this.commonTab).getAuctionItems().method_5488(c -> this.UpdateAuctionItems());
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        for (SimpleSlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
            gui.method_25302(TraderScreen.GUI_TEXTURE, this.screen.getGuiLeft() + slot.field_7873 - 1, this.screen.getGuiTop() + slot.field_7872 - 1, 206, 0, 18, 18);
        }
        gui.method_51439(this.font, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.auction.auctionitems"), this.screen.getGuiLeft() + 15 + 7, this.screen.getGuiTop() + 112, 0x404040, false);
        if (this.locked && this.successTime != 0L) {
            TextRenderUtil.drawCenteredText(gui, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.auction.create.success").method_27692(class_124.field_1067), this.screen.getGuiLeft() + this.screen.getImageWidth() / 2, 34, 0x404040);
        }
        if (CommandLCAdmin.isAdminPlayer(((TraderStorageMenu)this.screen.method_17577()).player)) {
            gui.method_51439(this.font, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.settings.persistent.id"), this.screen.getGuiLeft(), this.screen.getGuiTop() - 35, 0xFFFFFF, false);
        }
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
        this.tradeDisplay.renderTooltips(gui, this.font, mouseX, mouseY);
    }

    @Override
    public void tick() {
        this.priceSelect.locked = this.locked;
        this.priceSelect.tick();
        if (this.locked && this.successTime != 0L && TimeUtil.compareTime(5000L, this.successTime)) {
            this.screen.changeTab(0);
            return;
        }
        if (this.locked) {
            this.buttonSubmitAuction.field_22763 = false;
            this.buttonTogglePriceMode.field_22763 = false;
        } else {
            this.buttonTogglePriceMode.field_22763 = true;
            this.buttonSubmitAuction.field_22763 = this.pendingAuction.isValid();
        }
        if (CommandLCAdmin.isAdminPlayer(((TraderStorageMenu)this.screen.method_17577()).player)) {
            this.persistentAuctionIDInput.field_22764 = !this.locked;
            this.buttonSubmitPersistentAuction.field_22764 = this.persistentAuctionIDInput.field_22764;
            this.buttonSubmitPersistentAuction.field_22763 = this.pendingAuction.isValid();
            this.persistentAuctionIDInput.method_1865();
        } else {
            this.persistentAuctionIDInput.field_22764 = false;
            this.buttonSubmitPersistentAuction.field_22764 = false;
        }
    }

    private void UpdateAuctionItems() {
        this.pendingAuction.setAuctionItems((class_1263)((AuctionCreateTab)this.commonTab).getAuctionItems());
    }

    private void onPriceChanged(CoinValue newPrice) {
        if (this.startingBidMode) {
            this.pendingAuction.setStartingBid(newPrice);
        } else {
            this.pendingAuction.setMinBidDifferent(newPrice);
        }
    }

    private void TogglePriceTarget() {
        this.startingBidMode = !this.startingBidMode;
        this.buttonTogglePriceMode.method_25355((class_2561)class_2561.method_43471((String)(this.startingBidMode ? "button.lightmanscurrency.auction.toggleprice.startingbid" : "button.lightmanscurrency.auction.toggleprice.mindeltabid")));
        if (this.startingBidMode) {
            this.priceSelect.setCoinValue(this.pendingAuction.getLastBidAmount());
        } else {
            this.priceSelect.setCoinValue(this.pendingAuction.getMinBidDifference());
        }
    }

    private void updateDuration(TimeUtil.TimeData newTime) {
        this.pendingAuction.setDuration(newTime.miliseconds);
    }

    private void submitAuction() {
        ((AuctionCreateTab)this.commonTab).createAuction(this.pendingAuction);
        this.locked = true;
        for (SimpleSlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
            slot.locked = true;
        }
    }

    private void submitPersistentAuction(class_4185 button) {
        new CMessageAddPersistentAuction(this.pendingAuction.getAsNBT(), this.persistentAuctionIDInput.method_1882()).sendToServer();
    }

    @Override
    public void receiveServerMessage(class_2487 message) {
        if (message.method_10545("AuctionCreated")) {
            if (message.method_10577("AuctionCreated")) {
                this.successTime = TimeUtil.getCurrentTime();
            } else {
                this.locked = false;
                for (SimpleSlot slot : ((AuctionCreateTab)this.commonTab).getSlots()) {
                    slot.locked = false;
                }
            }
        }
    }
}

