/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.item;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ItemEditWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.InteractionConsumer;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.item.ItemTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import org.jetbrains.annotations.NotNull;

public class ItemTradeEditClientTab
extends TraderStorageClientTab<ItemTradeEditTab>
implements InteractionConsumer,
ItemEditWidget.IItemEditListener {
    private static final int X_OFFSET = 13;
    private static final int Y_OFFSET = 71;
    private static final int COLUMNS = 10;
    private static final int ROWS = 2;
    TradeButton tradeDisplay;
    CoinValueInput priceSelection;
    class_342 customNameInput;
    ItemEditWidget itemEdit;
    ScrollBarWidget itemEditScroll;
    class_4185 buttonToggleTradeType;
    private int selection = -1;
    private int itemEditScrollValue = -1;

    public ItemTradeEditClientTab(TraderStorageScreen screen, ItemTradeEditTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.BLANK;
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43473();
    }

    @Override
    public boolean tabButtonVisible() {
        return false;
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public int getTradeRuleTradeIndex() {
        return ((ItemTradeEditTab)this.commonTab).getTradeIndex();
    }

    @Override
    public void onOpen() {
        ItemTradeData trade = this.getTrade();
        this.tradeDisplay = this.screen.addRenderableTabWidget(new TradeButton(this.menu::getContext, ((ItemTradeEditTab)this.commonTab)::getTrade, button -> {}));
        this.tradeDisplay.method_48229(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 18);
        this.priceSelection = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft() + 103 - 88, this.screen.getGuiTop() + 40, (class_2561)class_2561.method_43473(), trade == null ? CoinValue.EMPTY : trade.getCost(), this.font, this::onValueChanged, this.screen::addRenderableTabWidget));
        this.priceSelection.drawBG = false;
        this.priceSelection.init();
        this.itemEdit = this.screen.addRenderableTabWidget(new ItemEditWidget(this.screen.getGuiLeft() + 13, this.screen.getGuiTop() + 71, 10, 2, this));
        this.itemEdit.init(this.screen::addRenderableTabWidget, this.screen::addTabListener);
        if (this.itemEditScrollValue >= 0) {
            this.itemEdit.setScroll(this.itemEditScrollValue);
        }
        this.itemEditScroll = this.screen.addRenderableTabWidget(new ScrollBarWidget(this.screen.getGuiLeft() + 13 + 180, this.screen.getGuiTop() + 71, 36, this.itemEdit));
        this.itemEditScroll.smallKnob = true;
        int labelWidth = this.font.method_27525((class_5348)class_2561.method_43471((String)"gui.lightmanscurrency.customname"));
        this.customNameInput = this.screen.addRenderableTabWidget(new class_342(this.font, this.screen.getGuiLeft() + 15 + labelWidth, this.screen.getGuiTop() + 38, this.screen.getImageWidth() - 28 - labelWidth, 18, (class_2561)class_2561.method_43473()));
        if (this.selection >= 0 && this.selection < 2 && trade != null) {
            this.customNameInput.method_1852(trade.getCustomName(this.selection));
        }
        this.buttonToggleTradeType = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 113, this.screen.getGuiTop() + 15, 80, 20, (class_2561)class_2561.method_43473(), this::ToggleTradeType));
    }

    @Override
    public void onClose() {
        this.selection = -1;
        this.itemEditScrollValue = -1;
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (this.getTrade() == null) {
            return;
        }
        this.validateRenderables();
        if (this.itemEditScroll.field_22764) {
            this.itemEditScroll.beforeWidgetRender(mouseY);
        }
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        gui.method_25302(TraderScreen.GUI_TEXTURE, this.getArrowPosition(), this.screen.getGuiTop() + 10, 214, 18, 8, 6);
        if (this.customNameInput.field_22764) {
            gui.method_51439(this.font, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.customname"), this.screen.getGuiLeft() + 13, this.screen.getGuiTop() + 42, 0x404040, false);
        }
    }

    private int getArrowPosition() {
        ItemTradeData trade = this.getTrade();
        if (this.selection == -1) {
            if (trade.isSale()) {
                return this.screen.getGuiLeft() + 25;
            }
            if (trade.isPurchase()) {
                return this.screen.getGuiLeft() + 81;
            }
            return -100;
        }
        if (this.selection >= 2 && !trade.isBarter()) {
            return -100;
        }
        int horizSlot = this.selection;
        if (trade.isSale() || trade.isBarter()) {
            horizSlot += 2;
        }
        int spacing = horizSlot % 4 >= 2 ? 20 : 0;
        return this.screen.getGuiLeft() + 16 + 18 * (horizSlot % 4) + spacing;
    }

    private void validateRenderables() {
        boolean bl = this.priceSelection.field_22764 = this.selection < 0 && !this.getTrade().isBarter();
        if (this.priceSelection.field_22764) {
            this.priceSelection.tick();
        }
        this.itemEditScroll.field_22764 = this.getTrade().isBarter() && this.selection >= 2 || this.getTrade().isPurchase() && this.selection >= 0;
        this.itemEdit.field_22764 = this.itemEditScroll.field_22764;
        boolean bl2 = this.customNameInput.field_22764 = this.selection >= 0 && this.selection < 2 && !this.getTrade().isPurchase();
        if (this.customNameInput.field_22764 && !this.customNameInput.method_1882().contentEquals(this.getTrade().getCustomName(this.selection))) {
            ((ItemTradeEditTab)this.commonTab).setCustomName(this.selection, this.customNameInput.method_1882());
        }
        this.buttonToggleTradeType.method_25355((class_2561)class_2561.method_43471((String)("gui.button.lightmanscurrency.tradedirection." + this.getTrade().getTradeType().name().toLowerCase())));
    }

    @Override
    public void tick() {
        if (this.customNameInput.field_22764) {
            this.customNameInput.method_1865();
        }
        if (this.itemEdit.field_22764) {
            this.itemEdit.tick();
            this.itemEditScrollValue = this.itemEdit.currentScroll();
        }
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
        this.tradeDisplay.renderTooltips(gui, this.font, mouseX, mouseY);
        if (this.selection >= 0) {
            this.itemEdit.renderTooltips(gui, this.font, mouseX, mouseY);
        }
    }

    @Override
    public void receiveSelfMessage(class_2487 message) {
        if (message.method_10545("TradeIndex")) {
            ((ItemTradeEditTab)this.commonTab).setTradeIndex(message.method_10550("TradeIndex"));
        }
        if (message.method_10545("StartingSlot")) {
            this.selection = message.method_10550("StartingSlot");
        }
    }

    @Override
    public void onTradeButtonInputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trade instanceof ItemTradeData) {
            ItemTradeData t = (ItemTradeData)trade;
            class_1799 heldItem = this.menu.method_34255();
            if (t.isSale()) {
                this.changeSelection(-1);
            } else if (t.isPurchase()) {
                if (this.selection != index && heldItem.method_7960()) {
                    this.changeSelection(index);
                } else {
                    ((ItemTradeEditTab)this.commonTab).defaultInteraction(index, heldItem, mouseButton);
                }
            } else if (t.isBarter()) {
                if (this.selection != index + 2 && heldItem.method_7960()) {
                    this.changeSelection(index + 2);
                } else {
                    ((ItemTradeEditTab)this.commonTab).defaultInteraction(index + 2, heldItem, mouseButton);
                }
            }
        }
    }

    @Override
    public void onTradeButtonOutputInteraction(TraderData trader, TradeData trade, int index, int mouseButton) {
        if (trade instanceof ItemTradeData) {
            ItemTradeData t = (ItemTradeData)trade;
            class_1799 heldItem = this.menu.method_34255();
            if (t.isSale() || t.isBarter()) {
                if (this.selection != index && heldItem.method_7960()) {
                    this.changeSelection(index);
                } else {
                    ((ItemTradeEditTab)this.commonTab).defaultInteraction(index, heldItem, mouseButton);
                }
            } else if (t.isPurchase()) {
                this.changeSelection(-1);
            }
        }
    }

    private void changeSelection(int newSelection) {
        this.selection = newSelection;
        if (this.selection == -1) {
            this.priceSelection.setCoinValue(this.getTrade().getCost());
        }
        if (this.selection >= 0 && this.selection < 2) {
            this.customNameInput.method_1852(((ItemTradeEditTab)this.commonTab).getTrade().getCustomName(this.selection));
        }
        if (this.selection >= 2) {
            this.itemEdit.refreshSearch();
        }
    }

    @Override
    public void onTradeButtonInteraction(TraderData trader, TradeData trade, int localMouseX, int localMouseY, int mouseButton) {
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        this.tradeDisplay.onInteractionClick((int)mouseX, (int)mouseY, button, this);
        this.itemEditScroll.onMouseClicked(mouseX, mouseY, button);
        return false;
    }

    @Override
    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        this.itemEditScroll.onMouseReleased(mouseX, mouseY, button);
        return false;
    }

    public void onValueChanged(CoinValue value) {
        ((ItemTradeEditTab)this.commonTab).setPrice(value.copy());
    }

    @Override
    public ItemTradeData getTrade() {
        return ((ItemTradeEditTab)this.commonTab).getTrade();
    }

    @Override
    public boolean restrictItemEditItems() {
        return this.selection < 2;
    }

    @Override
    public void onItemClicked(class_1799 item) {
        ((ItemTradeEditTab)this.commonTab).setSelectedItem(this.selection, item);
    }

    private void ToggleTradeType(class_4185 button) {
        if (this.getTrade() != null) {
            ((ItemTradeEditTab)this.commonTab).setType(this.getTrade().getTradeType().next());
        }
    }
}

