/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.slot_machine.SlotMachineEntryEditWidget;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.slot_machine.SlotMachineEntryTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineEntry;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class SlotMachineEntryClientTab
extends TraderStorageClientTab<SlotMachineEntryTab>
implements ScrollBarWidget.IScrollable {
    public static final int ENTRY_ROWS = 3;
    public static final int ENTRY_COLUMNS = 2;
    public static final int ENTRIES_PER_PAGE = 6;
    private int scroll = 0;
    private class_4185 buttonAddEntry;
    private final List<SlotMachineEntryEditWidget> editWidgets = new ArrayList<SlotMachineEntryEditWidget>();

    public SlotMachineEntryClientTab(TraderStorageScreen screen, SlotMachineEntryTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    public boolean tabButtonVisible() {
        return true;
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_TRADER_ALT;
    }

    @Override
    public class_5250 getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.trader.slot_machine.edit_entries", new Object[0]);
    }

    @Override
    public void onOpen() {
        this.editWidgets.clear();
        this.screen.addTabListener(new ScrollListener(this.screen.getGuiLeft(), this.screen.getGuiTop(), this.screen.getImageWidth(), 145, this::handleScrollWheel));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 2; ++x) {
                SlotMachineEntryEditWidget w = this.screen.addRenderableTabWidget(new SlotMachineEntryEditWidget(ScreenPosition.of(this.screen.getGuiLeft(), this.screen.getGuiTop()).offset(19 + x * 80, 10 + y * 46), this, this.supplierForIndex(y * 2 + x)));
                w.addChildren(this.screen::addRenderableTabWidget);
                this.editWidgets.add(w);
            }
        }
        this.screen.addRenderableTabWidget(new ScrollBarWidget(this.screen.getGuiLeft() + 19 + 160, this.screen.getGuiTop() + 10, 138, this));
        this.buttonAddEntry = this.screen.addRenderableTabWidget(new PlainButton(this.screen.getGuiLeft() + this.screen.getImageWidth() - 14, this.screen.getGuiTop() + 4, 10, 10, this::AddEntry, TraderScreen.GUI_TEXTURE, 224, 20));
        this.tick();
    }

    public SlotMachineEntry getEntry(int entryIndex) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            List<SlotMachineEntry> entries = trader.getAllEntries();
            if (entryIndex < 0 || entryIndex >= entries.size()) {
                return null;
            }
            return entries.get(entryIndex);
        }
        return null;
    }

    private Supplier<Integer> supplierForIndex(int index) {
        return () -> this.scroll * 2 + index;
    }

    @Override
    public void tick() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            trader.clearEntriesChangedCache();
        }
        this.validateScroll();
        this.buttonAddEntry.field_22764 = this.menu.hasPermission("editTrades");
        for (SlotMachineEntryEditWidget w : new ArrayList<SlotMachineEntryEditWidget>(this.editWidgets)) {
            w.tick();
        }
    }

    private void validateScroll() {
        if (this.scroll > this.getMaxScroll() && this.scroll > 0) {
            this.setScroll(Math.max(this.getMaxScroll(), 0));
        }
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
        for (SlotMachineEntryEditWidget w : new ArrayList<SlotMachineEntryEditWidget>(this.editWidgets)) {
            w.renderTooltips(gui, mouseX, mouseY);
        }
    }

    private void AddEntry(class_4185 button) {
        ((SlotMachineEntryTab)this.commonTab).AddEntry();
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = MathUtil.clamp(newScroll, 0, this.getMaxScroll());
    }

    private int getEntryCount() {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            return trader.getAllEntries().size();
        }
        return 0;
    }

    @Override
    public int getMaxScroll() {
        return ScrollBarWidget.IScrollable.calculateMaxScroll(6, 2, this.getEntryCount());
    }
}

