/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.slot_machine.SlotMachinePriceTab;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class SlotMachinePriceClientTab
extends TraderStorageClientTab<SlotMachinePriceTab> {
    private CoinValueInput priceInput;

    public SlotMachinePriceClientTab(TraderStorageScreen screen, SlotMachinePriceTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)ModItems.COIN_GOLD);
    }

    @Override
    public class_5250 getTooltip() {
        return EasyText.translatable("tooltip.lightmanscurrency.trader.slot_machine.edit_price", new Object[0]);
    }

    @Override
    public boolean tabButtonVisible() {
        return true;
    }

    @Override
    public boolean blockInventoryClosing() {
        return false;
    }

    @Override
    public void onOpen() {
        CoinValue startingPrice = CoinValue.EMPTY;
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            startingPrice = trader.getPrice();
        }
        this.priceInput = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft() + this.screen.getImageWidth() / 2 - 88, this.screen.getGuiTop() + 12, (class_2561)EasyText.empty(), startingPrice, this.font, this::ChangePrice, this.screen::addRenderableTabWidget));
        this.priceInput.init();
        this.priceInput.drawBG = false;
    }

    @Override
    public void tick() {
        this.priceInput.tick();
    }

    @Override
    public void renderBG(class_332 gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void renderTooltips(class_332 gui, int mouseX, int mouseY) {
    }

    private void ChangePrice(CoinValue newPrice) {
        ((SlotMachinePriceTab)this.commonTab).SetPrice(newPrice);
    }
}

