/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletBankScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.walletbank.WalletBankTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.menu.wallet.WalletBankMenu;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.network.server.messages.bank.CMessageSelectBankAccount;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class SelectionTab
extends WalletBankTab {
    class_4185 buttonPersonalAccount;
    TeamSelectWidget teamSelection;

    public SelectionTab(WalletBankScreen screen) {
        super(screen);
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of((class_1935)class_1802.field_8407);
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.atm.selection");
    }

    @Override
    public void init() {
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 79, this.screen.getGuiTop() + 15, 5, TeamButton.Size.NARROW, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.screen.getFont());
        this.buttonPersonalAccount = this.screen.addRenderableTabWidget(new VanillaButton(this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 15, 70, 20, (class_2561)class_2561.method_43471((String)"gui.button.bank.playeraccount"), this::PressPersonalAccount));
        this.tick();
    }

    private boolean isTeamSelected() {
        return ((WalletBankMenu)this.screen.method_17577()).getBankAccountReference().accountType == BankAccount.AccountType.Team;
    }

    private boolean isSelfSelected() {
        return ((WalletBankMenu)this.screen.method_17577()).getBankAccount() == BankAccount.GenerateReference(((WalletBankMenu)this.screen.method_17577()).getPlayer()).get();
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        for (Team team : TeamSaveData.GetAllTeams(true)) {
            if (!team.hasBankAccount() || !team.canAccessBankAccount(((WalletBankMenu)this.screen.method_17577()).getPlayer())) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.isTeamSelected()) {
            return TeamSaveData.GetTeam(true, ((WalletBankMenu)this.screen.method_17577()).getBankAccountReference().teamID);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            Team selectedTeam = this.selectedTeam();
            if (selectedTeam != null && team.getID() == this.selectedTeam().getID()) {
                return;
            }
            BankAccount.AccountReference account = BankAccount.GenerateReference(true, team);
            new CMessageSelectBankAccount(account).sendToServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PressPersonalAccount(class_4185 button) {
        BankAccount.AccountReference account = BankAccount.GenerateReference(((WalletBankMenu)this.screen.method_17577()).getPlayer());
        new CMessageSelectBankAccount(account).sendToServer();
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        gui.method_51439(this.screen.getFont(), (class_2561)this.getTooltip(), this.screen.getGuiLeft() + 8, this.screen.getGuiTop() + 6, 0x404040, false);
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY) {
        if (this.getTeamList().size() == 0) {
            TextRenderUtil.drawVerticallyCenteredMultilineText(gui, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.bank.noteamsavailable"), this.teamSelection.method_46426() + 1, TeamButton.Size.NARROW.width - 2, this.teamSelection.method_46427() + 1, this.teamSelection.method_25364() - 2, 0xFFFFFF);
        }
    }

    @Override
    public void tick() {
        this.buttonPersonalAccount.field_22763 = !this.isSelfSelected();
    }

    @Override
    public void onClose() {
    }
}

