/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.settings.core;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class OwnershipTab
extends SettingsTab {
    public static final OwnershipTab INSTANCE = new OwnershipTab();
    class_342 newOwnerInput;
    class_4185 buttonSetOwner;
    TeamSelectWidget teamSelection;
    class_4185 buttonSetTeamOwner;
    long selectedTeam = -1L;
    List<Team> teamList = Lists.newArrayList();

    @Override
    public int getColor() {
        return 0xFFFFFF;
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of(ItemRenderUtil.getAlexHead());
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.settings.owner");
    }

    private OwnershipTab() {
    }

    @Override
    public boolean canOpen() {
        return this.hasPermissions("transferOwnership");
    }

    @Override
    public void initTab() {
        TraderSettingsScreen screen = this.getScreen();
        this.newOwnerInput = screen.addRenderableTabWidget(new class_342(screen.getFont(), screen.guiLeft() + 20, screen.guiTop() + 20, 160, 20, (class_2561)class_2561.method_43473()));
        this.newOwnerInput.method_1880(16);
        this.buttonSetOwner = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 20, screen.guiTop() + 41, 160, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.set_owner"), this::setOwner));
        this.buttonSetOwner.field_22763 = false;
        this.teamSelection = screen.addRenderableTabWidget(new TeamSelectWidget(screen.guiLeft() + 10, screen.guiTop() + 65, 5, () -> this.teamList, this::getSelectedTeam, this::selectTeam));
        this.teamSelection.init(screen::addRenderableTabWidget, this.getFont());
        this.buttonSetTeamOwner = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 20, screen.guiTop() + 170, 160, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.set_owner"), this::setTeamOwner));
        this.buttonSetTeamOwner.field_22763 = false;
    }

    private Team getTeam(int teamIndex) {
        if (teamIndex < this.teamList.size()) {
            return this.teamList.get(teamIndex);
        }
        return null;
    }

    private Team getSelectedTeam() {
        if (this.selectedTeam < 0L) {
            return null;
        }
        return TeamSaveData.GetTeam(true, this.selectedTeam);
    }

    private void refreshTeamList() {
        this.teamList = Lists.newArrayList();
        List<Team> allTeams = TeamSaveData.GetAllTeams(true);
        allTeams.forEach(team -> {
            if (team.isMember(this.getPlayer())) {
                this.teamList.add((Team)team);
            }
        });
        this.teamList.sort(Team.sorterFor(this.getPlayer()));
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        TraderSettingsScreen screen = this.getScreen();
        gui.method_51439(this.getFont(), (class_2561)class_2561.method_43469((String)"gui.button.lightmanscurrency.team.owner", (Object[])new Object[]{this.getScreen().getTrader().getOwner().getOwnerName(true)}), screen.guiLeft() + 20, screen.guiTop() + 10, 0x404040, false);
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        if (this.buttonSetOwner.method_25405((double)mouseX, (double)mouseY) || this.buttonSetTeamOwner.method_25405((double)mouseX, (double)mouseY)) {
            gui.method_51438(this.getFont(), (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.warning").method_27695(new class_124[]{class_124.field_1067, class_124.field_1054}), mouseX, mouseY);
        }
    }

    @Override
    public void tick() {
        this.refreshTeamList();
        this.newOwnerInput.method_1865();
        this.buttonSetOwner.field_22763 = !this.newOwnerInput.method_1882().isBlank();
        this.buttonSetTeamOwner.field_22763 = this.getSelectedTeam() != null;
    }

    @Override
    public void closeTab() {
        this.selectedTeam = -1L;
        this.teamList = Lists.newArrayList();
    }

    private void selectTeam(int teamIndex) {
        Team newTeam = this.getTeam(teamIndex);
        if (newTeam != null) {
            this.selectedTeam = newTeam.getID() == this.selectedTeam ? -1L : newTeam.getID();
        }
    }

    private void setOwner(class_4185 button) {
        if (this.newOwnerInput.method_1882().isBlank()) {
            return;
        }
        class_2487 message = new class_2487();
        message.method_10582("ChangePlayerOwner", this.newOwnerInput.method_1882());
        this.getScreen().getTrader().sendNetworkMessage(message);
        this.newOwnerInput.method_1852("");
    }

    private void setTeamOwner(class_4185 button) {
        if (this.getSelectedTeam() == null) {
            return;
        }
        class_2487 message = new class_2487();
        message.method_10544("ChangeTeamOwner", this.selectedTeam);
        this.getScreen().getTrader().sendNetworkMessage(message);
        this.selectedTeam = -1L;
    }
}

