/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TeamManagerScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.team.TeamTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollTextDisplay;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VanillaButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.network.server.messages.team.CMessageEditTeam;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_4185;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

public class TeamMemberEditTab
extends TeamTab {
    public static final TeamMemberEditTab INSTANCE = new TeamMemberEditTab();
    ScrollTextDisplay memberDisplay;
    class_342 memberNameInput;
    class_4185 buttonAddMember;
    class_4185 buttonPromoteMember;
    class_4185 buttonRemoveMember;

    private TeamMemberEditTab() {
    }

    @Override
    @NotNull
    public IconData getIcon() {
        return IconData.of(ItemRenderUtil.getAlexHead());
    }

    @Override
    public class_5250 getTooltip() {
        return class_2561.method_43471((String)"tooltip.lightmanscurrency.team.member_edit");
    }

    @Override
    public boolean allowViewing(class_1657 player, Team team) {
        return team != null;
    }

    @Override
    public void initTab() {
        TeamManagerScreen screen = this.getScreen();
        this.memberNameInput = screen.addRenderableTabWidget(new class_342(this.getFont(), screen.guiLeft() + 11, screen.guiTop() + 9, 178, 20, (class_2561)class_2561.method_43473()));
        this.memberNameInput.method_1880(16);
        this.buttonAddMember = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 10, screen.guiTop() + 30, 60, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.team.member.add"), this::addMember));
        this.buttonPromoteMember = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 70, screen.guiTop() + 30, 60, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.team.member.promote"), this::addAdmin));
        this.buttonRemoveMember = screen.addRenderableTabWidget(new VanillaButton(screen.guiLeft() + 130, screen.guiTop() + 30, 60, 20, (class_2561)class_2561.method_43471((String)"gui.button.lightmanscurrency.team.member.remove"), this::removeMember));
        this.buttonRemoveMember.field_22763 = false;
        this.buttonPromoteMember.field_22763 = false;
        this.buttonAddMember.field_22763 = false;
        int n = screen.guiLeft() + 10;
        int n2 = screen.guiTop() + 55;
        Objects.requireNonNull(screen);
        Objects.requireNonNull(screen);
        this.memberDisplay = screen.addRenderableTabWidget(new ScrollTextDisplay(n, n2, 200 - 20, 200 - 65, this.getFont(), (Supplier<List<? extends class_2561>>)((Supplier)this::getMemberList)));
        this.memberDisplay.setColumnCount(2);
    }

    private List<class_2561> getMemberList() {
        ArrayList list = Lists.newArrayList();
        Team team = this.getActiveTeam();
        if (team != null) {
            team.getAdmins().forEach(admin -> list.add(admin.getNameComponent(true).method_27692(class_124.field_1077)));
            team.getMembers().forEach(member -> list.add(member.getNameComponent(true)));
        }
        return list;
    }

    @Override
    public void preRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void postRender(class_332 gui, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        if (this.getActiveTeam().isAdmin(this.getPlayer())) {
            this.buttonRemoveMember.field_22763 = !this.memberNameInput.method_1882().isBlank();
            this.buttonPromoteMember.field_22763 = this.buttonRemoveMember.field_22763;
            this.buttonAddMember.field_22763 = this.buttonRemoveMember.field_22763;
        } else {
            this.buttonPromoteMember.field_22763 = false;
            this.buttonAddMember.field_22763 = false;
            this.buttonRemoveMember.field_22763 = this.getPlayer().method_7334().getName().equalsIgnoreCase(this.memberNameInput.method_1882().toLowerCase());
        }
    }

    @Override
    public void closeTab() {
    }

    private void addMember(class_4185 button) {
        if (this.memberNameInput.method_1882().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeAddMember(this.getPlayer(), this.memberNameInput.method_1882());
        new CMessageEditTeam(team.getID(), this.memberNameInput.method_1882(), 0).sendToServer();
        this.memberNameInput.method_1852("");
    }

    private void addAdmin(class_4185 button) {
        if (this.memberNameInput.method_1882().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeAddAdmin(this.getPlayer(), this.memberNameInput.method_1882());
        new CMessageEditTeam(team.getID(), this.memberNameInput.method_1882(), 1).sendToServer();
        this.memberNameInput.method_1852("");
    }

    private void removeMember(class_4185 button) {
        if (this.memberNameInput.method_1882().isBlank() || this.getActiveTeam() == null) {
            return;
        }
        Team team = this.getActiveTeam();
        team.changeRemoveMember(this.getPlayer(), this.memberNameInput.method_1882());
        new CMessageEditTeam(team.getID(), this.memberNameInput.method_1882(), 2).sendToServer();
        this.memberNameInput.method_1852("");
    }
}

