/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.minecraft.class_1761;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_5321;
import net.minecraft.class_6382;
import net.minecraft.class_7225;
import net.minecraft.class_746;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_7923;

public class ItemEditWidget
extends class_339
implements ScrollBarWidget.IScrollable {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/item_edit.png");
    private static final List<Function<class_1761, Boolean>> ITEM_GROUP_BLACKLIST = new ArrayList<Function<class_1761, Boolean>>();
    private int scroll = 0;
    private int stackCount = 1;
    private final int columns;
    private final int rows;
    public int searchOffX;
    public int searchOffY;
    public int stackSizeOffX;
    public int stackSizeOffY;
    private static final List<class_1799> allItems = new ArrayList<class_1799>();
    private List<class_1799> searchResultItems;
    private String searchString;
    class_342 searchInput;
    ScrollListener stackScrollListener;
    private final IItemEditListener listener;
    private final class_327 font;

    public static void BlacklistCreativeTabs(class_1761 ... tabs) {
        for (class_1761 tab : tabs) {
            ItemEditWidget.BlacklistCreativeTab(t -> tab == t);
        }
    }

    @SafeVarargs
    public static void BlacklistCreativeTabs(class_5321<class_1761> ... tabs) {
        for (class_5321<class_1761> tab : tabs) {
            ItemEditWidget.BlacklistCreativeTab(t -> class_7923.field_44687.method_29107(tab) == t);
        }
    }

    public static void BlacklistCreativeTab(Function<class_1761, Boolean> tabMatcher) {
        if (!ITEM_GROUP_BLACKLIST.contains(tabMatcher)) {
            ITEM_GROUP_BLACKLIST.add(tabMatcher);
        }
    }

    public static boolean IsCreativeTabAllowed(class_1761 tab) {
        for (Function<class_1761, Boolean> test : ITEM_GROUP_BLACKLIST) {
            if (!test.apply(tab).booleanValue()) continue;
            return false;
        }
        return true;
    }

    public ItemEditWidget(int x, int y, int columns, int rows, IItemEditListener listener) {
        super(x, y, columns * 18, rows * 18, (class_2561)class_2561.method_43473());
        this.listener = listener;
        this.columns = columns;
        this.rows = rows;
        this.searchOffX = this.field_22758 - 90;
        this.searchOffY = -13;
        this.stackSizeOffX = this.field_22758 + 13;
        this.stackSizeOffY = 0;
        class_310 mc = class_310.method_1551();
        this.font = mc.field_1772;
        this.modifySearch("");
    }

    public static void initItemList() {
        allItems.clear();
        class_310 client = class_310.method_1551();
        class_746 player = client.field_1724;
        if (player == null) {
            return;
        }
        class_7706.method_47330((class_7699)player.field_3944.method_45735(), (boolean)((Boolean)client.field_1690.method_47395().method_41753()), (class_7225.class_7874)player.field_17892.method_30349());
        for (class_1761 group : class_7923.field_44687.method_10220().toList()) {
            if (!ItemEditWidget.IsCreativeTabAllowed(group)) continue;
            Collection items = group.method_47313();
            for (class_1799 stack : items) {
                if (!ItemEditWidget.itemListAlreadyContains(stack)) {
                    allItems.add(stack);
                }
                if (stack.method_7909() != class_1802.field_8598) continue;
                Map enchantments = class_1890.method_8222((class_1799)stack);
                enchantments.forEach((enchantment, level) -> {
                    for (int newLevel = level - 1; newLevel > 0; --newLevel) {
                        class_1799 newBook = new class_1799((class_1935)class_1802.field_8598);
                        class_1890.method_8214((Map)ImmutableMap.of((Object)enchantment, (Object)newLevel), (class_1799)newBook);
                        if (ItemEditWidget.itemListAlreadyContains(newBook)) continue;
                        allItems.add(newBook);
                    }
                });
            }
        }
    }

    private static boolean itemListAlreadyContains(class_1799 stack) {
        for (class_1799 s : allItems) {
            if (!InventoryUtil.ItemMatches(s, stack)) continue;
            return true;
        }
        return false;
    }

    private List<class_1799> getFilteredItems() {
        ArrayList results = Lists.newArrayList();
        ItemTradeData trade = this.listener.getTrade();
        ItemTradeRestriction restriction = trade == null ? ItemTradeRestriction.NONE : this.listener.getTrade().getRestriction();
        for (class_1799 allItem : allItems) {
            if (!restriction.allowItemSelectItem(allItem)) continue;
            results.add(allItem);
        }
        return results;
    }

    @Override
    public int getMaxScroll() {
        return Math.max((this.searchResultItems.size() - 1) / this.columns - this.rows + 1, 0);
    }

    public void refreshPage() {
        if (this.scroll < 0) {
            this.scroll = 0;
        }
        if (this.scroll > this.getMaxScroll()) {
            this.scroll = this.getMaxScroll();
        }
        int startIndex = this.scroll * this.columns;
        for (int i = 0; i < this.rows * this.columns; ++i) {
            int thisIndex = startIndex + i;
            if (thisIndex >= this.searchResultItems.size()) continue;
            class_1799 stack = this.searchResultItems.get(thisIndex).method_7972();
            stack.method_7939(MathUtil.clamp(this.stackCount, 1, stack.method_7914()));
        }
    }

    public void refreshSearch() {
        this.modifySearch(this.searchString);
    }

    public void modifySearch(String newSearch) {
        this.searchString = newSearch.toLowerCase();
        if (this.searchString.length() > 0) {
            this.searchResultItems = new ArrayList<class_1799>();
            List<class_1799> validItems = this.listener.restrictItemEditItems() ? this.getFilteredItems() : allItems;
            for (class_1799 stack : validItems) {
                if (stack.method_7964().getString().toLowerCase().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                if (class_7923.field_41178.method_10221((Object)stack.method_7909()).toString().contains(this.searchString)) {
                    this.searchResultItems.add(stack);
                    continue;
                }
                AtomicReference<Boolean> enchantmentMatch = new AtomicReference<Boolean>(false);
                Map enchantments = class_1890.method_8222((class_1799)stack);
                enchantments.forEach((enchantment, level) -> {
                    if (class_7923.field_41176.method_10221(enchantment).toString().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    } else if (enchantment.method_8179(level.intValue()).getString().toLowerCase().contains(this.searchString)) {
                        enchantmentMatch.set(true);
                    }
                });
                if (!enchantmentMatch.get().booleanValue()) continue;
                this.searchResultItems.add(stack);
            }
        } else {
            this.searchResultItems = this.listener.restrictItemEditItems() ? this.getFilteredItems() : allItems;
        }
        this.refreshPage();
    }

    public void init(Function<class_342, class_342> addWidget, Function<ScrollListener, ScrollListener> addListener) {
        this.searchInput = addWidget.apply(new class_342(this.font, this.method_46426() + this.searchOffX + 2, this.method_46427() + this.searchOffY + 2, 79, 9, (class_2561)class_2561.method_43471((String)"gui.lightmanscurrency.item_edit.search")));
        this.searchInput.method_1858(false);
        this.searchInput.method_1880(32);
        this.searchInput.method_1868(0xFFFFFF);
        this.stackScrollListener = addListener.apply(new ScrollListener(this.method_46426() + this.stackSizeOffX, this.method_46427() + this.stackSizeOffY, 18, 18, this::stackCountScroll));
    }

    public void method_25394(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.searchInput.field_22764 = this.field_22764;
        this.stackScrollListener.active = this.field_22764;
        super.method_25394(gui, mouseX, mouseY, partialTicks);
    }

    protected void method_48579(class_332 gui, int mouseX, int mouseY, float delta) {
        if (!this.searchInput.method_1882().toLowerCase().contentEquals(this.searchString)) {
            this.modifySearch(this.searchInput.method_1882());
        }
        int index = this.scroll * this.columns;
        for (int y = 0; y < this.rows && index < this.searchResultItems.size(); ++y) {
            int yPos = this.method_46427() + y * 18;
            for (int x = 0; x < this.columns && index < this.searchResultItems.size(); ++index, ++x) {
                int xPos = this.method_46426() + x * 18;
                gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                gui.method_25302(GUI_TEXTURE, xPos, yPos, 0, 0, 18, 18);
                ItemRenderUtil.drawItemStack(gui, this.font, this.getQuantityFixedStack(this.searchResultItems.get(index)), xPos + 1, yPos + 1);
            }
        }
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
        gui.method_25302(GUI_TEXTURE, this.method_46426() + this.searchOffX, this.method_46427() + this.searchOffY, 18, 0, 90, 12);
        gui.method_25302(GUI_TEXTURE, this.method_46426() + this.stackSizeOffX, this.method_46427() + this.stackSizeOffY, 108, 0, 18, 18);
    }

    public void tick() {
        this.searchInput.method_1865();
    }

    private class_1799 getQuantityFixedStack(class_1799 stack) {
        class_1799 copy = stack.method_7972();
        copy.method_7939(Math.min(stack.method_7914(), this.stackCount));
        return copy;
    }

    public void renderTooltips(class_332 gui, class_327 font, int mouseX, int mouseY) {
        if (!this.field_22764) {
            return;
        }
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultItems.size()) {
            gui.method_51434(font, ItemRenderUtil.getTooltipFromItem(this.searchResultItems.get(hoveredSlot)), mouseX, mouseY);
        }
        if (this.isMouseOverStackSizeScroll(mouseX, mouseY)) {
            gui.method_51438(font, (class_2561)class_2561.method_43471((String)"tooltip.lightmanscurrency.item_edit.scroll"), mouseX, mouseY);
        }
    }

    private boolean isMouseOverStackSizeScroll(int mouseX, int mouseY) {
        return mouseX >= this.method_46426() + this.stackSizeOffX && mouseX < this.method_46426() + this.stackSizeOffX + 18 && mouseY >= this.method_46427() + this.stackSizeOffY && mouseY < this.method_46427() + this.stackSizeOffY + 18;
    }

    private int isMouseOverSlot(double mouseX, double mouseY) {
        int foundColumn = -1;
        int foundRow = -1;
        for (int x = 0; x < this.columns && foundColumn < 0; ++x) {
            if (!(mouseX >= (double)(this.method_46426() + x * 18)) || !(mouseX < (double)(this.method_46426() + x * 18 + 18))) continue;
            foundColumn = x;
        }
        for (int y = 0; y < this.rows && foundRow < 0; ++y) {
            if (!(mouseY >= (double)(this.method_46427() + y * 18)) || !(mouseY < (double)(this.method_46427() + y * 18 + 18))) continue;
            foundRow = y;
        }
        if (foundColumn < 0 || foundRow < 0) {
            return -1;
        }
        return foundRow * this.columns + foundColumn;
    }

    public void method_47399(class_6382 builder) {
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int hoveredSlot = this.isMouseOverSlot(mouseX, mouseY);
        if (hoveredSlot >= 0 && (hoveredSlot += this.scroll * this.columns) < this.searchResultItems.size()) {
            class_1799 stack = this.getQuantityFixedStack(this.searchResultItems.get(hoveredSlot));
            this.listener.onItemClicked(stack);
            return true;
        }
        return false;
    }

    public boolean stackCountScroll(double mouseX, double mouseY, double delta) {
        if (delta > 0.0) {
            if (this.stackCount < 64) {
                ++this.stackCount;
            }
        } else if (delta < 0.0 && this.stackCount > 1) {
            --this.stackCount;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (delta < 0.0) {
            if (this.scroll >= this.getMaxScroll()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.refreshPage();
    }

    public static interface IItemEditListener {
        public ItemTradeData getTrade();

        public boolean restrictItemEditItems();

        public void onItemClicked(class_1799 var1);
    }
}

