/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5348;

public abstract class DisplayEntry {
    public static final DisplayEntry EMPTY = DisplayEntry.of((class_2561)class_2561.method_43473(), TextRenderUtil.TextFormatting.create());
    private final List<class_2561> tooltip;

    @Deprecated
    protected DisplayEntry() {
        this.tooltip = null;
    }

    protected DisplayEntry(List<class_2561> tooltip) {
        this.tooltip = tooltip;
    }

    protected final class_327 getFont() {
        class_310 m = class_310.method_1551();
        return m.field_1772;
    }

    protected List<class_2561> getTooltip() {
        if (this.tooltip == null) {
            return new ArrayList<class_2561>();
        }
        return this.tooltip;
    }

    public abstract void render(class_339 var1, class_332 var2, int var3, int var4, DisplayData var5);

    public abstract boolean isMouseOver(int var1, int var2, DisplayData var3, int var4, int var5);

    public static DisplayEntry of(class_1799 item, int count) {
        return new ItemEntry(item, count, null);
    }

    public static DisplayEntry of(class_1799 item, int count, List<class_2561> tooltip) {
        return new ItemEntry(item, count, tooltip);
    }

    public static DisplayEntry of(Pair<class_2960, class_2960> background) {
        return new EmptySlotEntry(background, null);
    }

    public static DisplayEntry of(Pair<class_2960, class_2960> background, List<class_2561> tooltip) {
        return new EmptySlotEntry(background, tooltip);
    }

    public static DisplayEntry of(class_2561 text, TextRenderUtil.TextFormatting format) {
        return new TextEntry(text, format, null);
    }

    public static DisplayEntry of(class_2561 text, TextRenderUtil.TextFormatting format, List<class_2561> tooltip) {
        return new TextEntry(text, format, tooltip);
    }

    public static DisplayEntry of(CoinValue price) {
        return new PriceEntry(price, null, false);
    }

    public static DisplayEntry of(CoinValue price, List<class_2561> additionalTooltips) {
        return new PriceEntry(price, additionalTooltips, false);
    }

    public static DisplayEntry of(CoinValue price, List<class_2561> additionalTooltips, boolean tooltipOverride) {
        return new PriceEntry(price, additionalTooltips, tooltipOverride);
    }

    private static class ItemEntry
    extends DisplayEntry {
        private final class_1799 item;

        private ItemEntry(class_1799 item, int count, List<class_2561> tooltip) {
            super(tooltip);
            this.item = item.method_7972();
            this.item.method_7939(count);
        }

        private int getTopLeft(int xOrY, int availableWidthOrHeight) {
            return xOrY + availableWidthOrHeight / 2 - 8;
        }

        @Override
        public void render(class_339 widget, class_332 gui, int x, int y, DisplayData area) {
            if (this.item.method_7960()) {
                return;
            }
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            class_327 font = this.getFont();
            int left = this.getTopLeft(x + area.xOffset, area.width);
            int top = this.getTopLeft(y + area.yOffset, area.height);
            ItemRenderUtil.drawItemStack(gui, font, this.item, left, top);
        }

        @Override
        public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
            int left = this.getTopLeft(x + area.xOffset, area.width);
            int top = this.getTopLeft(y + area.yOffset, area.height);
            return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
        }
    }

    private static class EmptySlotEntry
    extends DisplayEntry {
        private final Pair<class_2960, class_2960> background;

        private EmptySlotEntry(Pair<class_2960, class_2960> background, List<class_2561> tooltip) {
            super(tooltip);
            this.background = background;
        }

        private int getTopLeft(int xOrY, int availableWidthOrHeight) {
            return xOrY + availableWidthOrHeight / 2 - 8;
        }

        @Override
        public void render(class_339 widget, class_332 gui, int x, int y, DisplayData area) {
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            int left = this.getTopLeft(x + area.xOffset, area.width);
            int top = this.getTopLeft(y + area.yOffset, area.height);
            ItemRenderUtil.drawSlotBackground(gui, left, top, this.background);
        }

        @Override
        public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
            int left = this.getTopLeft(x + area.xOffset, area.width);
            int top = this.getTopLeft(y + area.yOffset, area.height);
            return mouseX >= left && mouseX < left + 16 && mouseY >= top && mouseY < top + 16;
        }
    }

    private static class TextEntry
    extends DisplayEntry {
        private final class_2561 text;
        private final TextRenderUtil.TextFormatting format;

        private TextEntry(class_2561 text, TextRenderUtil.TextFormatting format, List<class_2561> tooltip) {
            super(tooltip);
            this.text = text;
            this.format = format;
        }

        protected int getTextLeft(int x, int availableWidth) {
            if (this.format.centering().isCenter()) {
                return x + availableWidth / 2 - this.getTextWidth() / 2;
            }
            if (this.format.centering().isRight()) {
                return x + availableWidth - this.getTextWidth();
            }
            return x;
        }

        protected int getTextTop(int y, int availableHeight) {
            if (this.format.centering().isMiddle()) {
                int n = y + availableHeight / 2;
                Objects.requireNonNull(this.getFont());
                return n - 9 / 2;
            }
            if (this.format.centering().isBottom()) {
                Objects.requireNonNull(this.getFont());
                return y + availableHeight - 9;
            }
            return y;
        }

        protected int getTextWidth() {
            return this.getFont().method_27525((class_5348)this.text);
        }

        @Override
        public void render(class_339 widget, class_332 gui, int x, int y, DisplayData area) {
            if (this.text.getString().isBlank()) {
                return;
            }
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            class_327 font = this.getFont();
            int left = this.getTextLeft(x + area.xOffset, area.width);
            int top = this.getTextTop(y + area.yOffset, area.height);
            gui.method_51439(font, this.text, left, top, this.format.color(), true);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
            int left = this.getTextLeft(x + area.xOffset, area.width);
            int top = this.getTextTop(y + area.yOffset, area.height);
            if (mouseX < left) return false;
            if (mouseX >= left + this.getTextWidth()) return false;
            if (mouseY < top) return false;
            Objects.requireNonNull(this.getFont());
            if (mouseY >= top + 9) return false;
            return true;
        }
    }

    private static class PriceEntry
    extends DisplayEntry {
        private final CoinValue price;

        public PriceEntry(CoinValue price, List<class_2561> additionalTooltips, boolean tooltipOverride) {
            super(PriceEntry.getTooltip(price, additionalTooltips, tooltipOverride));
            this.price = price;
        }

        private int getTopLeft(int xOrY, int availableWidthOrHeight) {
            return xOrY + availableWidthOrHeight / 2 - 8;
        }

        private static List<class_2561> getTooltip(CoinValue price, List<class_2561> additionalTooltips, boolean tooltipOverride) {
            ArrayList<class_2561> tooltips = new ArrayList<class_2561>();
            if (tooltipOverride && additionalTooltips != null) {
                return additionalTooltips;
            }
            if (!price.isFree() && price.isValid()) {
                tooltips.add((class_2561)class_2561.method_43470((String)price.getString()));
            }
            if (additionalTooltips != null) {
                tooltips.addAll(additionalTooltips);
            }
            return tooltips;
        }

        @Override
        public void render(class_339 widget, class_332 gui, int x, int y, DisplayData area) {
            block3: {
                List<CoinValue.CoinValuePair> entries;
                block4: {
                    block2: {
                        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                        if (!this.price.isFree()) break block2;
                        class_327 font = this.getFont();
                        int left = x + area.xOffset + area.width / 2 - font.method_1727(this.price.getString()) / 2;
                        int n = y + area.yOffset + area.height / 2;
                        Objects.requireNonNull(font);
                        int top = n - 9 / 2;
                        gui.method_51439(font, (class_2561)class_2561.method_43470((String)this.price.getString()), left, top, 0xFFFFFF, false);
                        break block3;
                    }
                    entries = this.price.getEntries();
                    if (entries.size() * 16 > area.width) break block4;
                    List<DisplayData> entryPositions = area.divide(entries.size());
                    for (int i = 0; i < entryPositions.size() && i < entries.size(); ++i) {
                        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                        DisplayData pos = entryPositions.get(i);
                        int left = this.getTopLeft(x + pos.xOffset, pos.width);
                        int top = this.getTopLeft(y + pos.yOffset, pos.height);
                        class_1799 stack = new class_1799((class_1935)entries.get((int)i).coin);
                        stack.method_7939(entries.get((int)i).amount);
                        ItemRenderUtil.drawItemStack(gui, this.getFont(), stack, left, top);
                    }
                    break block3;
                }
                if (entries.size() <= 0) break block3;
                gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
                int spacing = (area.width - 16) / entries.size();
                int top = this.getTopLeft(y + area.yOffset, area.height);
                int left = x + area.xOffset + area.width - 16;
                for (int i = entries.size() - 1; i >= 0; --i) {
                    class_1799 stack = new class_1799((class_1935)entries.get((int)i).coin);
                    stack.method_7939(entries.get((int)i).amount);
                    ItemRenderUtil.drawItemStack(gui, this.getFont(), stack, left, top);
                    left -= spacing;
                }
            }
        }

        @Override
        public boolean isMouseOver(int x, int y, DisplayData area, int mouseX, int mouseY) {
            int left = x + area.xOffset;
            int top = y + area.yOffset;
            return mouseX >= left && mouseX < left + area.width && mouseY >= top && mouseY < top + area.height;
        }
    }
}

