/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.notifications;

import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollBarWidget;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1144;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6382;

public class NotificationDisplayWidget
extends class_339
implements ScrollBarWidget.IScrollable {
    public static final class_2960 GUI_TEXTURE = new class_2960("lightmanscurrency", "textures/gui/notifications.png");
    public static final int HEIGHT_PER_ROW = 22;
    private final Supplier<List<Notification>> notificationSource;
    private final class_327 font;
    private final int rowCount;
    public boolean colorIfUnseen = false;
    public int backgroundColor = -3750202;
    class_2561 tooltip = null;
    private int scroll = 0;

    public static int CalculateHeight(int rowCount) {
        return rowCount * 22;
    }

    private List<Notification> getNotifications() {
        return this.notificationSource.get();
    }

    public NotificationDisplayWidget(int x, int y, int width, int rowCount, class_327 font, Supplier<List<Notification>> notificationSource) {
        super(x, y, width, NotificationDisplayWidget.CalculateHeight(rowCount), (class_2561)class_2561.method_43473());
        this.notificationSource = notificationSource;
        this.font = font;
        this.rowCount = rowCount;
    }

    public void method_48579(class_332 gui, int mouseX, int mouseY, float partialTicks) {
        this.validateScroll();
        this.tooltip = null;
        List<Notification> notifications = this.getNotifications();
        int index = this.scroll;
        gui.method_25294(this.method_46426(), this.method_46427(), this.method_46426() + this.field_22758, this.method_46427() + this.field_22759, this.backgroundColor);
        for (int y = 0; y < this.rowCount && index < notifications.size(); ++y) {
            class_5250 message;
            List lines;
            int textColor;
            int thisWidth;
            int yPos = this.method_46427() + y * 22;
            Notification n = notifications.get(index++);
            gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
            int vPos = n.wasSeen() && this.colorIfUnseen ? 222 : 200;
            gui.method_25302(GUI_TEXTURE, this.method_46426(), yPos, 0, vPos, 2, 22);
            for (int xPos = this.method_46426() + 2; xPos < this.method_46426() + this.field_22758 - 2; xPos += thisWidth) {
                thisWidth = Math.min(166, this.method_46426() + this.field_22758 - 2 - xPos);
                gui.method_25302(GUI_TEXTURE, xPos, yPos, 2, vPos, thisWidth, 22);
            }
            gui.method_25302(GUI_TEXTURE, this.method_46426() + this.field_22758 - 2, yPos, 168, 200, 2, 22);
            int textXPos = this.method_46426() + 2;
            int textWidth = this.field_22758 - 4;
            int n2 = textColor = n.wasSeen() ? 0xFFFFFF : 0;
            if (n.getCount() > 1) {
                String countText = String.valueOf(n.getCount());
                int quantityWidth = this.font.method_1727(countText);
                gui.method_25302(GUI_TEXTURE, this.method_46426() + 1 + quantityWidth, yPos, 170, vPos, 3, 22);
                Objects.requireNonNull(this.font);
                gui.method_51433(this.font, countText, textXPos, yPos + 11 - 9 / 2, textColor, false);
                textXPos += quantityWidth + 2;
                textWidth -= quantityWidth + 2;
            }
            if ((lines = this.font.method_1728((class_5348)(message = n.getMessage()), textWidth)).size() == 1) {
                class_5481 class_54812 = (class_5481)lines.get(0);
                Objects.requireNonNull(this.font);
                gui.method_51430(this.font, class_54812, textXPos, yPos + 11 - 9 / 2, textColor, false);
                continue;
            }
            for (int l = 0; l < lines.size() && l < 2; ++l) {
                gui.method_51430(this.font, (class_5481)lines.get(l), textXPos, yPos + 2 + l * 10, textColor, false);
            }
            if (lines.size() <= 2 || this.tooltip != null || mouseX < this.method_46426() || mouseX >= this.method_46426() + this.field_22758 || mouseY < yPos || mouseY >= yPos + 22) continue;
            this.tooltip = message;
        }
        gui.method_51422(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public void tryRenderTooltip(class_332 gui, int mouseX, int mouseY) {
        if (this.tooltip != null) {
            gui.method_51447(this.font, this.font.method_1728((class_5348)this.tooltip, this.field_22758), mouseX, mouseY);
            this.tooltip = null;
        }
    }

    @Override
    public int currentScroll() {
        return this.scroll;
    }

    @Override
    public void setScroll(int newScroll) {
        this.scroll = newScroll;
        this.validateScroll();
    }

    private void validateScroll() {
        this.scroll = MathUtil.clamp(this.scroll, 0, this.getMaxScroll());
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.getNotifications().size() - this.rowCount);
    }

    public void method_47399(class_6382 builder) {
    }

    public boolean method_25401(double mouseX, double mouseY, double scroll) {
        if (scroll < 0.0) {
            this.setScroll(this.scroll + 1);
        } else if (scroll > 0.0) {
            this.setScroll(this.scroll - 1);
        }
        return true;
    }

    public void method_25354(class_1144 manager) {
    }
}

