/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.util;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.gui.widget.util.IScreen;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_339;

public class LazyWidgetPositioner {
    public static final Function<LazyWidgetPositioner, Pair<Integer, Integer>> MODE_TOPDOWN = positioner -> Pair.of((Object)positioner.startX(), (Object)(positioner.startY() + positioner.widgetSize * positioner.getPositionIndex()));
    public static final Function<LazyWidgetPositioner, Pair<Integer, Integer>> MODE_BOTTOMUP = positioner -> Pair.of((Object)positioner.startX(), (Object)(positioner.startY() - positioner.widgetSize * positioner.getPositionIndex()));
    private final IScreen screen;
    private final Function<LazyWidgetPositioner, Pair<Integer, Integer>> mode;
    private final List<class_339> widgetList = new ArrayList<class_339>();
    private final int x1;
    private final int y1;
    public final int widgetSize;
    private int posIndex;

    public final int startX() {
        return this.screen.getGuiLeft() + this.x1;
    }

    public final int startY() {
        return this.screen.getGuiTop() + this.y1;
    }

    public int getPositionIndex() {
        return this.posIndex;
    }

    @SafeVarargs
    public static LazyWidgetPositioner create(IScreen screen, Function<LazyWidgetPositioner, Pair<Integer, Integer>> mode, int x1, int y1, int widgetSize, class_339 ... widgets) {
        return new LazyWidgetPositioner(screen, mode, x1, y1, widgetSize, widgets);
    }

    @SafeVarargs
    private LazyWidgetPositioner(IScreen screen, Function<LazyWidgetPositioner, Pair<Integer, Integer>> mode, int x1, int y1, int widgetSize, class_339 ... widgets) {
        this.screen = Objects.requireNonNull(screen);
        this.mode = Objects.requireNonNull(mode);
        this.x1 = x1;
        this.y1 = y1;
        this.widgetSize = widgetSize;
        this.screen.addTickListener(this::reposition);
        for (class_339 w : widgets) {
            this.addWidget(w);
        }
    }

    public <T extends class_339> T addWidget(T widget) {
        if (widget != null && !this.widgetList.contains(widget)) {
            this.widgetList.add(widget);
        }
        return widget;
    }

    public void addWidgets(Object ... widgets) {
        for (Object w : widgets) {
            if (!(w instanceof class_339)) continue;
            class_339 cw = (class_339)w;
            this.addWidget(cw);
        }
    }

    public void reposition() {
        this.posIndex = 0;
        for (class_339 w : new ArrayList<class_339>(this.widgetList)) {
            if (!w.field_22764) continue;
            Pair<Integer, Integer> pos = this.mode.apply(this);
            w.method_48229(((Integer)pos.getFirst()).intValue(), ((Integer)pos.getSecond()).intValue());
            ++this.posIndex;
        }
    }

    public void clear() {
        this.widgetList.clear();
    }
}

