/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.util;

import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class TextRenderUtil {
    public static class_327 getFont() {
        class_310 mc = class_310.method_1551();
        return mc.field_1772;
    }

    public static class_2561 fitString(String text, int width) {
        return TextRenderUtil.fitString(text, width, "...");
    }

    public static class_2561 fitString(String text, int width, class_2583 style) {
        return TextRenderUtil.fitString(text, width, "...", style);
    }

    public static class_2561 fitString(String text, int width, String edge) {
        return TextRenderUtil.fitString((class_2561)class_2561.method_43470((String)text), width, edge);
    }

    public static class_2561 fitString(class_2561 component, int width) {
        return TextRenderUtil.fitString(component.getString(), width, "...", component.method_10866());
    }

    public static class_2561 fitString(class_2561 component, int width, String edge) {
        return TextRenderUtil.fitString(component.getString(), width, edge, component.method_10866());
    }

    public static class_2561 fitString(class_2561 component, int width, class_2583 style) {
        return TextRenderUtil.fitString(component.getString(), width, "...", style);
    }

    public static class_2561 fitString(class_2561 component, int width, String edge, class_2583 style) {
        return TextRenderUtil.fitString(component.getString(), width, edge, style);
    }

    public static class_2561 fitString(String text, int width, String edge, class_2583 style) {
        class_327 font = TextRenderUtil.getFont();
        if (font.method_27525((class_5348)class_2561.method_43470((String)text).method_10862(style)) <= width) {
            return class_2561.method_43470((String)text).method_10862(style);
        }
        while (font.method_27525((class_5348)class_2561.method_43470((String)(text + edge)).method_10862(style)) > width && text.length() > 0) {
            text = text.substring(0, text.length() - 1);
        }
        return class_2561.method_43470((String)(text + edge)).method_10862(style);
    }

    public static void drawCenteredText(class_332 gui, String string, int centerX, int yPos, int color) {
        TextRenderUtil.drawCenteredText(gui, (class_2561)class_2561.method_43470((String)string), centerX, yPos, color);
    }

    public static void drawCenteredText(class_332 gui, class_2561 component, int centerX, int yPos, int color) {
        class_327 font = TextRenderUtil.getFont();
        int width = font.method_27525((class_5348)component);
        gui.method_51439(font, component, centerX - width / 2, yPos, color, false);
    }

    public static void drawRightEdgeText(class_332 gui, String string, int rightPos, int yPos, int color) {
        TextRenderUtil.drawRightEdgeText(gui, (class_2561)class_2561.method_43470((String)string), rightPos, yPos, color);
    }

    public static void drawRightEdgeText(class_332 gui, class_2561 component, int rightPos, int yPos, int color) {
        class_327 font = TextRenderUtil.getFont();
        int width = font.method_27525((class_5348)component);
        gui.method_51439(font, component, rightPos, yPos - width, color, false);
    }

    public static void drawCenteredMultilineText(class_332 gui, String string, int leftPos, int width, int topPos, int color) {
        TextRenderUtil.drawCenteredMultilineText(gui, (class_2561)class_2561.method_43470((String)string), leftPos, width, topPos, color);
    }

    public static void drawCenteredMultilineText(class_332 gui, class_2561 component, int leftPos, int width, int topPos, int color) {
        class_327 font = TextRenderUtil.getFont();
        List lines = font.method_1728((class_5348)component, width);
        int centerPos = leftPos + width / 2;
        for (int i = 0; i < lines.size(); ++i) {
            class_5481 line = (class_5481)lines.get(i);
            int lineWidth = font.method_30880(line);
            int n = centerPos - lineWidth / 2;
            Objects.requireNonNull(font);
            gui.method_51430(font, line, n, topPos + 9 * i, color, false);
        }
    }

    public static void drawVerticallyCenteredMultilineText(class_332 gui, String string, int leftPos, int width, int topPos, int height, int color) {
        TextRenderUtil.drawVerticallyCenteredMultilineText(gui, (class_2561)class_2561.method_43470((String)string), leftPos, width, topPos, height, color);
    }

    public static void drawVerticallyCenteredMultilineText(class_332 gui, class_2561 component, int leftPos, int width, int topPos, int height, int color) {
        class_327 font = TextRenderUtil.getFont();
        List lines = font.method_1728((class_5348)component, width);
        int centerPos = leftPos + width / 2;
        int n = topPos + height / 2;
        Objects.requireNonNull(font);
        int startHeight = n - 9 * lines.size() / 2;
        for (int i = 0; i < lines.size(); ++i) {
            class_5481 line = (class_5481)lines.get(i);
            int lineWidth = font.method_30880(line);
            int n2 = centerPos - lineWidth / 2;
            Objects.requireNonNull(font);
            gui.method_51430(font, line, n2, startHeight + 9 * i, color, false);
        }
    }

    public static class_5250 changeStyle(class_2561 component, UnaryOperator<class_2583> styleChanges) {
        if (component instanceof class_5250) {
            class_5250 mc = (class_5250)component;
            return mc.method_27694(styleChanges);
        }
        return class_2561.method_43473().method_10852(component).method_10862(component.method_10866()).method_27694(styleChanges);
    }

    public static class TextFormatting {
        private Centering centering = Centering.MIDDLE_CENTER;
        private int color = 0xFFFFFF;

        public Centering centering() {
            return this.centering;
        }

        public int color() {
            return this.color;
        }

        private TextFormatting() {
        }

        public static TextFormatting create() {
            return new TextFormatting();
        }

        public TextFormatting topEdge() {
            this.centering = this.centering.makeTop();
            return this;
        }

        public TextFormatting middle() {
            this.centering = this.centering.makeMiddle();
            return this;
        }

        public TextFormatting bottomEdge() {
            this.centering = this.centering.makeBottom();
            return this;
        }

        public TextFormatting leftEdge() {
            this.centering = this.centering.makeLeft();
            return this;
        }

        public TextFormatting centered() {
            this.centering = this.centering.makeCenter();
            return this;
        }

        public TextFormatting rightEdge() {
            this.centering = this.centering.makeRight();
            return this;
        }

        public TextFormatting color(int color) {
            this.color = color;
            return this;
        }

        public static enum Centering {
            TOP_LEFT(-1, 1),
            TOP_CENTER(0, 1),
            TOP_RIGHT(1, 1),
            MIDDLE_LEFT(-1, 0),
            MIDDLE_CENTER(0, 0),
            MIDDLE_RIGHT(1, 0),
            BOTTOM_LEFT(-1, -1),
            BOTTOM_CENTER(0, -1),
            BOTTOM_RIGHT(1, -1);

            private final int horiz;
            private final int vert;

            private Centering(int horiz, int vert) {
                this.horiz = horiz;
                this.vert = vert;
            }

            public boolean isTop() {
                return this.vert > 0;
            }

            public boolean isMiddle() {
                return this.vert == 0;
            }

            public boolean isBottom() {
                return this.vert < 0;
            }

            public boolean isLeft() {
                return this.horiz < 0;
            }

            public boolean isCenter() {
                return this.horiz == 0;
            }

            public boolean isRight() {
                return this.horiz > 1;
            }

            public Centering makeTop() {
                return this.of(this.horiz, 1);
            }

            public Centering makeMiddle() {
                return this.of(this.horiz, 0);
            }

            public Centering makeBottom() {
                return this.of(this.horiz, -1);
            }

            public Centering makeLeft() {
                return this.of(-1, this.vert);
            }

            public Centering makeCenter() {
                return this.of(0, this.vert);
            }

            public Centering makeRight() {
                return this.of(1, this.vert);
            }

            private Centering of(int horiz, int vert) {
                for (Centering c : Centering.values()) {
                    if (c.horiz != horiz || c.vert != vert) continue;
                    return c;
                }
                return this;
            }
        }
    }
}

