/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.blocks.traderblocks;

import io.github.lightman314.lightmanscurrency.common.blockentity.trader.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.templates.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.common.blocks.util.LazyShapes;
import io.github.lightman314.lightmanscurrency.common.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.common.items.tooltips.LCTooltips;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_4970;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class ShelfBlock
extends TraderBlockRotatable
implements IItemTraderBlock {
    public static final int TRADECOUNT = 1;
    private static final class_265 SHAPE_NORTH = ShelfBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)5.0);
    private static final class_265 SHAPE_SOUTH = ShelfBlock.method_9541((double)0.0, (double)0.0, (double)11.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SHAPE_EAST = ShelfBlock.method_9541((double)11.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final class_265 SHAPE_WEST = ShelfBlock.method_9541((double)0.0, (double)0.0, (double)0.0, (double)5.0, (double)16.0, (double)16.0);

    public ShelfBlock(class_4970.class_2251 properties) {
        super(properties, LazyShapes.lazyDirectionalShape(SHAPE_NORTH, SHAPE_EAST, SHAPE_SOUTH, SHAPE_WEST));
    }

    @Override
    public class_2586 makeTrader(class_2338 pos, class_2680 state) {
        return new ItemTraderBlockEntity(pos, state, 1);
    }

    @Override
    public class_2591<?> traderType() {
        return ModBlockEntities.ITEM_TRADER;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, class_2680 state, boolean isDoubleTrade) {
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(1);
        if (tradeSlot == 0) {
            class_2350 facing = this.getFacing(state);
            Vector3f forward = IRotatableBlock.getForwardVect(facing);
            Vector3f right = IRotatableBlock.getRightVect(facing);
            Vector3f up = MathUtil.YP();
            Vector3f offset = IRotatableBlock.getOffsetVect(facing);
            posList.add(MathUtil.VectorAdd(offset, MathUtil.VectorMult(right, 0.5f), MathUtil.VectorMult(forward, 0.90625f), MathUtil.VectorMult(up, 0.5625f)));
        }
        return posList;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public List<Quaternionf> GetStackRenderRot(int tradeSlot, class_2680 state) {
        ArrayList<Quaternionf> rotation = new ArrayList<Quaternionf>();
        int facing = this.getFacing(state).method_10161();
        rotation.add(MathUtil.getRotationDegrees((float)facing * -90.0f));
        return rotation;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public float GetStackRenderScale(int tradeSlot, class_2680 state) {
        return 0.875f;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public int maxRenderIndex() {
        return 1;
    }

    @Override
    protected Supplier<List<class_2561>> getItemTooltips() {
        return LCTooltips.ITEM_TRADER;
    }
}

