/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.core;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.common.Reference;
import io.github.lightman314.lightmanscurrency.common.blocks.ATMBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CashRegisterBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinJarBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinMintBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.CoinpileBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TerminalBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.TicketMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.ArmorDisplayBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.CardDisplayBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.DisplayCaseBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.NetworkItemTraderBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.ShelfBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.SlotMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.TicketKioskBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.VendingMachineBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.VendingMachineLargeBlock;
import io.github.lightman314.lightmanscurrency.common.blocks.traderinterface.ItemTraderInterfaceBlock;
import io.github.lightman314.lightmanscurrency.common.core.ModItems;
import io.github.lightman314.lightmanscurrency.common.core.groups.BlockBundle;
import io.github.lightman314.lightmanscurrency.common.core.groups.BlockItemPair;
import io.github.lightman314.lightmanscurrency.common.core.groups.ObjectBundle;
import io.github.lightman314.lightmanscurrency.common.items.CashRegisterItem;
import io.github.lightman314.lightmanscurrency.common.items.CoinBlockItem;
import io.github.lightman314.lightmanscurrency.common.items.CoinJarItem;
import java.util.Locale;
import java.util.function.Function;
import net.fabricmc.fabric.api.item.v1.FabricItemSettings;
import net.fabricmc.fabric.api.object.builder.v1.block.FabricBlockSettings;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_4970;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ModBlocks {
    public static final Function<class_2248, class_1792> BASIC_ITEM = block -> new class_1747(block, (class_1792.class_1793)new FabricItemSettings());
    public static final Function<class_2248, class_1792> COINBLOCK_ITEM = block -> new CoinBlockItem((class_2248)block, (class_1792.class_1793)new FabricItemSettings());
    public static final Function<class_2248, class_1792> COINBLOCK_ITEM_FIREPROOF = block -> new CoinBlockItem((class_2248)block, (class_1792.class_1793)new FabricItemSettings().fireproof());
    public static final Function<class_2248, class_1792> CASH_REGISTER_ITEM = block -> new CashRegisterItem((class_2248)block, (class_1792.class_1793)new FabricItemSettings());
    public static final Function<class_2248, class_1792> COIN_JAR_ITEM = block -> new CoinJarItem((class_2248)block, (class_1792.class_1793)new FabricItemSettings());
    public static final BlockItemPair COINPILE_COPPER = ModBlocks.build((class_2248)new CoinpileBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque(), (class_1935)ModItems.COIN_COPPER), COINBLOCK_ITEM);
    public static final BlockItemPair COINPILE_IRON = ModBlocks.build((class_2248)new CoinpileBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque(), (class_1935)ModItems.COIN_IRON), COINBLOCK_ITEM);
    public static final BlockItemPair COINPILE_GOLD = ModBlocks.build((class_2248)new CoinpileBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque(), (class_1935)ModItems.COIN_GOLD), COINBLOCK_ITEM);
    public static final BlockItemPair COINPILE_EMERALD = ModBlocks.build((class_2248)new CoinpileBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque(), (class_1935)ModItems.COIN_EMERALD), COINBLOCK_ITEM);
    public static final BlockItemPair COINPILE_DIAMOND = ModBlocks.build((class_2248)new CoinpileBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque(), (class_1935)ModItems.COIN_DIAMOND), COINBLOCK_ITEM);
    public static final BlockItemPair COINPILE_NETHERITE = ModBlocks.build((class_2248)new CoinpileBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque(), (class_1935)ModItems.COIN_NETHERITE), COINBLOCK_ITEM_FIREPROOF);
    public static final BlockItemPair COINBLOCK_COPPER = ModBlocks.build((class_2248)new CoinBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533), (class_1935)ModItems.COIN_COPPER), COINBLOCK_ITEM);
    public static final BlockItemPair COINBLOCK_IRON = ModBlocks.build((class_2248)new CoinBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533), (class_1935)ModItems.COIN_IRON), COINBLOCK_ITEM);
    public static final BlockItemPair COINBLOCK_GOLD = ModBlocks.build((class_2248)new CoinBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533), (class_1935)ModItems.COIN_GOLD), COINBLOCK_ITEM);
    public static final BlockItemPair COINBLOCK_EMERALD = ModBlocks.build((class_2248)new CoinBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533), (class_1935)ModItems.COIN_EMERALD), COINBLOCK_ITEM);
    public static final BlockItemPair COINBLOCK_DIAMOND = ModBlocks.build((class_2248)new CoinBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533), (class_1935)ModItems.COIN_DIAMOND), COINBLOCK_ITEM);
    public static final BlockItemPair COINBLOCK_NETHERITE = ModBlocks.build((class_2248)new CoinBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533), (class_1935)ModItems.COIN_NETHERITE), COINBLOCK_ITEM_FIREPROOF);
    public static final BlockItemPair MACHINE_ATM = ModBlocks.build(new ATMBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque()));
    public static final BlockItemPair MACHINE_MINT = ModBlocks.build(new CoinMintBlock((class_4970.class_2251)FabricBlockSettings.create().strength(2.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque()));
    public static final BlockItemPair CASH_REGISTER = ModBlocks.build(new CashRegisterBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque(), class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0)), CASH_REGISTER_ITEM);
    public static final BlockItemPair DISPLAY_CASE = ModBlocks.build(new DisplayCaseBlock((class_4970.class_2251)FabricBlockSettings.create().strength(2.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11537).nonOpaque()));
    public static final BlockBundle<Reference.Color> VENDING_MACHINE = ModBlocks.build((Supplier<class_2248>)((Supplier)() -> new VendingMachineBlock((class_4970.class_2251)FabricBlockSettings.create().strength(5.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque())), Reference.Color.values());
    public static final BlockBundle<Reference.Color> VENDING_MACHINE_LARGE = ModBlocks.build((Supplier<class_2248>)((Supplier)() -> new VendingMachineLargeBlock((class_4970.class_2251)FabricBlockSettings.create().strength(5.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque())), Reference.Color.values());
    public static final BlockBundle<Reference.WoodType> SHELF = ModBlocks.build((Supplier<class_2248>)((Supplier)() -> new ShelfBlock((class_4970.class_2251)FabricBlockSettings.create().strength(2.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11547).nonOpaque())), Reference.WoodType.values());
    public static final BlockBundle<Reference.WoodType> CARD_DISPLAY = ModBlocks.build((Supplier<class_2248>)((Supplier)() -> new CardDisplayBlock((class_4970.class_2251)FabricBlockSettings.create().strength(2.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11547).nonOpaque())), Reference.WoodType.values());
    public static final BlockItemPair ARMOR_DISPLAY = ModBlocks.build(new ArmorDisplayBlock((class_4970.class_2251)FabricBlockSettings.create().strength(5.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque()));
    public static final BlockItemPair FREEZER = ModBlocks.build(new FreezerBlock((class_4970.class_2251)FabricBlockSettings.create().strength(5.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque()));
    public static final BlockItemPair TICKET_KIOSK = ModBlocks.build(new TicketKioskBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque()));
    public static final BlockItemPair SLOT_MACHINE = ModBlocks.build(new SlotMachineBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque()));
    public static final BlockItemPair ITEM_NETWORK_TRADER_1 = ModBlocks.build(new NetworkItemTraderBlock((class_4970.class_2251)FabricBlockSettings.create().strength(5.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque(), 4));
    public static final BlockItemPair ITEM_NETWORK_TRADER_2 = ModBlocks.build(new NetworkItemTraderBlock((class_4970.class_2251)FabricBlockSettings.create().strength(5.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque(), 8));
    public static final BlockItemPair ITEM_NETWORK_TRADER_3 = ModBlocks.build(new NetworkItemTraderBlock((class_4970.class_2251)FabricBlockSettings.create().strength(5.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque(), 12));
    public static final BlockItemPair ITEM_NETWORK_TRADER_4 = ModBlocks.build(new NetworkItemTraderBlock((class_4970.class_2251)FabricBlockSettings.create().strength(5.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533).nonOpaque(), 16));
    public static final BlockItemPair ITEM_TRADER_INTERFACE = ModBlocks.build(new ItemTraderInterfaceBlock((class_4970.class_2251)FabricBlockSettings.create().strength(5.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533)));
    public static final BlockItemPair TERMINAL = ModBlocks.build(new TerminalBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque(), class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0)));
    public static final BlockItemPair GEM_TERMINAL = ModBlocks.build(new TerminalBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_27198).nonOpaque(), class_2248.method_9541((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)12.0, (double)14.0)));
    public static final BlockItemPair PAYGATE = ModBlocks.build(new PaygateBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, Float.POSITIVE_INFINITY).sounds(class_2498.field_11533)));
    public static final BlockItemPair TICKET_MACHINE = ModBlocks.build(new TicketMachineBlock((class_4970.class_2251)FabricBlockSettings.create().strength(3.0f, 6.0f).sounds(class_2498.field_11533).nonOpaque()));
    public static final BlockItemPair PIGGY_BANK = ModBlocks.build(new CoinJarBlock((class_4970.class_2251)FabricBlockSettings.create().strength(0.1f, 2.0f).sounds(class_2498.field_11544).nonOpaque(), class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)), COIN_JAR_ITEM);
    public static final BlockItemPair COINJAR_BLUE = ModBlocks.build(new CoinJarBlock((class_4970.class_2251)FabricBlockSettings.create().strength(0.1f, 2.0f).sounds(class_2498.field_11544).nonOpaque(), class_2248.method_9541((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0)), COIN_JAR_ITEM);

    public static <T> Function<T, class_2960> BasicIDGeneration(String namespace, String name) {
        return ModBlocks.BasicIDGeneration(namespace, name, null);
    }

    public static <T> Function<T, class_2960> BasicIDGeneration(String namespace, String name, @Nullable T ignoreEntry) {
        return val -> val == ignoreEntry ? new class_2960(namespace, name) : new class_2960(namespace, name + "_" + val.toString().toLowerCase(Locale.ENGLISH));
    }

    public static void registerBlocks() {
        ModBlocks.register(new class_2960("lightmanscurrency", "coinpile_copper"), COINPILE_COPPER);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinpile_iron"), COINPILE_IRON);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinpile_gold"), COINPILE_GOLD);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinpile_emerald"), COINPILE_EMERALD);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinpile_diamond"), COINPILE_DIAMOND);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinpile_netherite"), COINPILE_NETHERITE);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinblock_copper"), COINBLOCK_COPPER);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinblock_iron"), COINBLOCK_IRON);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinblock_gold"), COINBLOCK_GOLD);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinblock_emerald"), COINBLOCK_EMERALD);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinblock_diamond"), COINBLOCK_DIAMOND);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinblock_netherite"), COINBLOCK_NETHERITE);
        ModBlocks.register(new class_2960("lightmanscurrency", "atm"), MACHINE_ATM);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinmint"), MACHINE_MINT);
        ModBlocks.register(new class_2960("lightmanscurrency", "cash_register"), CASH_REGISTER);
        ModBlocks.register(new class_2960("lightmanscurrency", "display_case"), DISPLAY_CASE);
        ModBlocks.register(VENDING_MACHINE, ModBlocks.BasicIDGeneration("lightmanscurrency", "vending_machine", Reference.Color.WHITE));
        ModBlocks.register(VENDING_MACHINE_LARGE, ModBlocks.BasicIDGeneration("lightmanscurrency", "vending_machine_large", Reference.Color.WHITE));
        ModBlocks.register(SHELF, ModBlocks.BasicIDGeneration("lightmanscurrency", "shelf"));
        ModBlocks.register(CARD_DISPLAY, ModBlocks.BasicIDGeneration("lightmanscurrency", "card_display"));
        ModBlocks.register(new class_2960("lightmanscurrency", "armor_display"), ARMOR_DISPLAY);
        ModBlocks.register(new class_2960("lightmanscurrency", "freezer"), FREEZER);
        ModBlocks.register(new class_2960("lightmanscurrency", "ticket_kiosk"), TICKET_KIOSK);
        ModBlocks.register(new class_2960("lightmanscurrency", "slot_machine"), SLOT_MACHINE);
        ModBlocks.register(new class_2960("lightmanscurrency", "item_trader_server_sml"), ITEM_NETWORK_TRADER_1);
        ModBlocks.register(new class_2960("lightmanscurrency", "item_trader_server_med"), ITEM_NETWORK_TRADER_2);
        ModBlocks.register(new class_2960("lightmanscurrency", "item_trader_server_lrg"), ITEM_NETWORK_TRADER_3);
        ModBlocks.register(new class_2960("lightmanscurrency", "item_trader_server_xlrg"), ITEM_NETWORK_TRADER_4);
        ModBlocks.register(new class_2960("lightmanscurrency", "item_trader_interface"), ITEM_TRADER_INTERFACE);
        ModBlocks.register(new class_2960("lightmanscurrency", "terminal"), TERMINAL);
        ModBlocks.register(new class_2960("lightmanscurrency", "gem_terminal"), GEM_TERMINAL);
        ModBlocks.register(new class_2960("lightmanscurrency", "paygate"), PAYGATE);
        ModBlocks.register(new class_2960("lightmanscurrency", "ticket_machine"), TICKET_MACHINE);
        ModBlocks.register(new class_2960("lightmanscurrency", "piggy_bank"), PIGGY_BANK);
        ModBlocks.register(new class_2960("lightmanscurrency", "coinjar_blue"), COINJAR_BLUE);
    }

    private static BlockItemPair build(class_2248 block) {
        return ModBlocks.build(block, BASIC_ITEM);
    }

    private static BlockItemPair build(class_2248 block, Function<class_2248, class_1792> itemGenerator) {
        class_1792 item = itemGenerator.apply(block);
        return new BlockItemPair(block, item);
    }

    private static <L> BlockBundle<L> build(Supplier<class_2248> blockSupplier, L[] types) {
        return ModBlocks.build(blockSupplier, types, BASIC_ITEM);
    }

    private static <L> BlockBundle<L> build(Supplier<class_2248> blockSupplier, L[] types, Function<class_2248, class_1792> itemGenerator) {
        BlockBundle<L> result = new BlockBundle<L>();
        for (L type : types) {
            class_2248 block = (class_2248)blockSupplier.get();
            class_1792 item = itemGenerator.apply(block);
            result.put(type, new BlockItemPair(block, item));
        }
        return result;
    }

    private static void register(class_2960 type, BlockItemPair pair) {
        if (pair.block != null) {
            class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)type, (Object)pair.block);
        }
        if (pair.item != null) {
            class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)type, (Object)pair.item);
        }
    }

    private static <L> void register(ObjectBundle<BlockItemPair, L> group, Function<L, class_2960> idGenerator) {
        group.foreach((key, pair) -> ModBlocks.register((class_2960)idGenerator.apply(key), pair));
    }
}

