/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import io.github.lightman314.lightmanscurrency.common.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import net.minecraft.class_1662;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3955;
import net.minecraft.class_5455;
import net.minecraft.class_7710;
import net.minecraft.class_8566;

public class WalletUpgradeRecipe
implements class_3955 {
    private final class_2960 id;
    private final String group;
    private final class_1799 recipeOutput;
    private final class_2371<class_1856> ingredients;

    public WalletUpgradeRecipe(class_2960 idIn, String groupIn, class_1799 recipeOutputIn, class_2371<class_1856> ingredients) {
        this.id = idIn;
        this.group = groupIn;
        this.recipeOutput = recipeOutputIn;
        this.ingredients = ingredients;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return ModRecipes.WALLET_UPGRADE;
    }

    public String method_8112() {
        return this.group;
    }

    public class_1799 method_8110(class_5455 manager) {
        return this.recipeOutput;
    }

    public class_2371<class_1856> method_8117() {
        return this.ingredients;
    }

    public class_7710 method_45441() {
        return class_7710.field_40251;
    }

    public boolean matches(class_8566 craftingInventory, class_1937 world) {
        class_1662 recipeMatcher = new class_1662();
        int i = 0;
        for (int j = 0; j < craftingInventory.method_5439(); ++j) {
            class_1799 itemStack = craftingInventory.method_5438(j);
            if (itemStack.method_7960()) continue;
            ++i;
            recipeMatcher.method_20478(itemStack, 1);
        }
        return i == this.ingredients.size() && recipeMatcher.method_7402((class_1860)this, null);
    }

    public class_1799 craft(class_8566 inv, class_5455 manager) {
        class_1799 output = this.recipeOutput.method_7972();
        class_1799 walletStack = this.getWalletStack(inv);
        if (!walletStack.method_7960()) {
            WalletItem.CopyWalletContents(walletStack, output);
        }
        return output;
    }

    private class_1799 getWalletStack(class_8566 inv) {
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (!(stack.method_7909() instanceof WalletItem)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.ingredients.size();
    }

    public static class Serializer
    implements class_1865<WalletUpgradeRecipe> {
        public WalletUpgradeRecipe read(class_2960 recipeId, JsonObject json) {
            String s = class_3518.method_15253((JsonObject)json, (String)"group", (String)"");
            class_2371<class_1856> nonnulllist = Serializer.readIngredients(class_3518.method_15261((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            class_1799 itemstack = new class_1799((class_1935)class_1869.method_8155((JsonObject)class_3518.method_15296((JsonObject)json, (String)"result")));
            return new WalletUpgradeRecipe(recipeId, s, itemstack, nonnulllist);
        }

        private static class_2371<class_1856> readIngredients(JsonArray ingredientArray) {
            class_2371 nonnulllist = class_2371.method_10211();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                class_1856 ingredient = class_1856.method_52177((JsonElement)ingredientArray.get(i));
                if (ingredient.method_8103()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public WalletUpgradeRecipe read(class_2960 recipeId, class_2540 buffer) {
            String s = buffer.method_10800(Short.MAX_VALUE);
            int i = buffer.method_10816();
            class_2371 nonnulllist = class_2371.method_10213((int)i, (Object)class_1856.field_9017);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)class_1856.method_8086((class_2540)buffer));
            }
            class_1799 itemstack = buffer.method_10819();
            return new WalletUpgradeRecipe(recipeId, s, itemstack, (class_2371<class_1856>)nonnulllist);
        }

        public void write(class_2540 buffer, WalletUpgradeRecipe recipe) {
            buffer.method_10814(recipe.group);
            buffer.method_10804(recipe.ingredients.size());
            for (class_1856 ingredient : recipe.ingredients) {
                ingredient.method_8088(buffer);
            }
            buffer.method_10793(recipe.recipeOutput);
        }
    }
}

