/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.emergency_ejection;

import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionSaveData;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.IDumpable;
import io.github.lightman314.lightmanscurrency.common.ownership.OwnerData;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_5250;

public class EjectionData
implements class_1263,
IClientTracker {
    private final OwnerData owner;
    class_5250 traderName;
    List<class_1799> items;
    private boolean isClient;

    public class_5250 getTraderName() {
        return this.traderName;
    }

    public void flagAsClient() {
        this.isClient = true;
    }

    @Override
    public boolean isClient() {
        return this.isClient;
    }

    private EjectionData() {
        this.owner = new OwnerData(this, o -> {});
        this.traderName = class_2561.method_43473();
        this.items = new ArrayList<class_1799>();
        this.isClient = false;
    }

    private EjectionData(OwnerData owner, class_5250 traderName, List<class_1799> items) {
        this.owner = new OwnerData(this, o -> {});
        this.traderName = class_2561.method_43473();
        this.items = new ArrayList<class_1799>();
        this.isClient = false;
        this.owner.copyFrom(owner);
        this.traderName = traderName;
        this.items = items;
    }

    public boolean canAccess(class_1657 player) {
        if (CommandLCAdmin.isAdminPlayer(player)) {
            return true;
        }
        return this.owner.isMember(player);
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        compound.method_10566("Owner", (class_2520)this.owner.save());
        compound.method_10582("Name", class_2561.class_2562.method_10867((class_2561)this.traderName));
        class_2499 itemList = new class_2499();
        for (class_1799 item : this.items) {
            itemList.add((Object)item.method_7953(new class_2487()));
        }
        compound.method_10566("Items", (class_2520)itemList);
        return compound;
    }

    public void load(class_2487 compound) {
        if (compound.method_10545("Owner")) {
            this.owner.load(compound.method_10562("Owner"));
        }
        if (compound.method_10545("Name")) {
            this.traderName = class_2561.class_2562.method_10877((String)compound.method_10558("Name"));
        }
        if (compound.method_10545("Items")) {
            class_2499 itemList = compound.method_10554("Items", 10);
            this.items = new ArrayList<class_1799>();
            for (int i = 0; i < itemList.size(); ++i) {
                this.items.add(class_1799.method_7915((class_2487)itemList.method_10602(i)));
            }
        }
    }

    public static EjectionData create(class_1937 level, class_2338 pos, class_2680 state, IDumpable trader) {
        return EjectionData.create(level, pos, state, trader, true);
    }

    public static EjectionData create(class_1937 level, class_2338 pos, class_2680 state, IDumpable trader, boolean dropBlock) {
        OwnerData owner = trader.getOwner();
        class_5250 traderName = trader.getName();
        List<class_1799> items = trader.getContents(level, pos, state, dropBlock);
        return new EjectionData(owner, traderName, items);
    }

    public static EjectionData loadData(class_2487 compound) {
        EjectionData data = new EjectionData();
        data.load(compound);
        return data;
    }

    public void method_5448() {
        this.items.clear();
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        if (slot >= this.items.size() || slot < 0) {
            return class_1799.field_8037;
        }
        return this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int count) {
        if (slot >= this.items.size() || slot < 0) {
            return class_1799.field_8037;
        }
        return this.items.get(slot).method_7971(count);
    }

    public class_1799 method_5441(int slot) {
        if (slot >= this.items.size() || slot < 0) {
            return class_1799.field_8037;
        }
        class_1799 stack = this.items.get(slot);
        this.items.set(slot, class_1799.field_8037);
        return stack;
    }

    public void method_5447(int slot, class_1799 item) {
        if (slot >= this.items.size() || slot < 0) {
            return;
        }
        this.items.set(slot, item);
    }

    private void clearEmptySlots() {
        this.items.removeIf(class_1799::method_7960);
    }

    public void method_5431() {
        if (this.isClient) {
            return;
        }
        this.clearEmptySlots();
        if (this.method_5442()) {
            EjectionSaveData.RemoveEjectionData(this);
        } else {
            EjectionSaveData.MarkEjectionDataDirty();
        }
    }

    public boolean method_5443(class_1657 player) {
        return this.canAccess(player);
    }
}

