/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.enchantments;

import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.common.core.ModSounds;
import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menu.wallet.WalletMenuBase;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import net.minecraft.class_124;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3419;

public final class CoinMagnetEnchantment {
    public static final int MAX_LEVEL = 3;
    public static final int MAX_CALCULATION_LEVEL = 5;

    private CoinMagnetEnchantment() {
    }

    public static void runPlayerTick(class_3222 player) {
        WalletHandler walletHandler = WalletHandler.getWallet((class_1657)player);
        class_1799 wallet = walletHandler.getWallet();
        if (!WalletItem.isWallet(wallet) || !WalletItem.CanPickup((WalletItem)wallet.method_7909())) {
            return;
        }
        int magnetLevel = WalletItem.GetMagnetLevel(wallet);
        if (magnetLevel <= 0) {
            return;
        }
        float range = CoinMagnetEnchantment.getCollectionRange(magnetLevel);
        class_1937 level = player.method_37908();
        if (level == null) {
            return;
        }
        class_238 searchBox = new class_238(player.method_23317() - (double)range, player.method_23318() - (double)range, player.method_23321() - (double)range, player.method_23317() + (double)range, player.method_23318() + (double)range, player.method_23321() + (double)range);
        boolean updateWallet = false;
        for (class_1542 ie : level.method_8390(class_1542.class, searchBox, e -> MoneyUtil.isCoin(e.method_6983()))) {
            class_1799 coinStack = ie.method_6983();
            class_1799 leftovers = WalletItem.PickupCoin(wallet, coinStack);
            if (leftovers.method_7947() == coinStack.method_7947()) continue;
            updateWallet = true;
            if (leftovers.method_7960()) {
                ie.method_31472();
            } else {
                ie.method_6979(leftovers);
            }
            level.method_8396(null, player.method_24515(), ModSounds.COINS_CLINKING, class_3419.field_15248, 0.4f, 1.0f);
        }
        if (updateWallet) {
            walletHandler.setWallet(wallet);
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof WalletMenuBase) {
                WalletMenuBase menu = (WalletMenuBase)class_17032;
                menu.reloadWalletContents();
            }
        }
    }

    public static float getCollectionRange(int enchantLevel) {
        if (--enchantLevel < 0) {
            return 0.0f;
        }
        return (Integer)LCConfig.SERVER.coinMagnetBaseRange.get() + (Integer)LCConfig.SERVER.coinMagnetLeveledRange.get() * Math.min(enchantLevel, 4);
    }

    public static class_2561 getCollectionRangeDisplay(int enchantLevel) {
        float range = CoinMagnetEnchantment.getCollectionRange(enchantLevel);
        String display = range % 1.0f > 0.0f ? String.valueOf(range) : String.valueOf(Math.round(range));
        return class_2561.method_43470((String)display).method_27692(class_124.field_1060);
    }
}

