/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot;

import com.google.common.collect.ImmutableList;
import io.github.lightman314.lightmanscurrency.LCConfig;
import io.github.lightman314.lightmanscurrency.api.config.options.basic.StringListOption;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.loot.EntityLootBlocker;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.fabric.api.loot.v2.LootTableSource;
import net.minecraft.class_117;
import net.minecraft.class_125;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_141;
import net.minecraft.class_151;
import net.minecraft.class_1657;
import net.minecraft.class_176;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1935;
import net.minecraft.class_221;
import net.minecraft.class_225;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3300;
import net.minecraft.class_3730;
import net.minecraft.class_44;
import net.minecraft.class_47;
import net.minecraft.class_52;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_5662;
import net.minecraft.class_60;
import net.minecraft.class_6862;
import net.minecraft.class_77;
import net.minecraft.class_79;
import net.minecraft.class_7923;
import net.minecraft.class_8567;
import org.jetbrains.annotations.NotNull;

public class LootManager {
    public static final float LOOTING_MODIFIER = 0.01f;
    private static final String ENTITY = "minecraft:";
    private static final String CHEST = "minecraft:chests/";
    public static final List<class_2960> ENTITY_COPPER_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:slime"), (Object)new class_2960("minecraft:silverfish"));
    public static final List<class_2960> ENTITY_IRON_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:zombie"), (Object)new class_2960("minecraft:skeleton"), (Object)new class_2960("minecraft:creeper"), (Object)new class_2960("minecraft:spider"), (Object)new class_2960("minecraft:cave_spider"), (Object)new class_2960("minecraft:husk"), (Object)new class_2960("minecraft:stray"), (Object)new class_2960("minecraft:magma_cube"), (Object)new class_2960("minecraft:zombie_villager"), (Object)new class_2960("minecraft:drowned"));
    public static final List<class_2960> ENTITY_GOLD_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:guardian"), (Object)new class_2960("minecraft:elder_guardian"), (Object)new class_2960("minecraft:phantom"), (Object)new class_2960("minecraft:blaze"), (Object)new class_2960("minecraft:ghast"), (Object)new class_2960("minecraft:witch"), (Object)new class_2960("minecraft:hoglin"), (Object)new class_2960("minecraft:piglin_brute"), (Object)new class_2960("minecraft:piglin"), (Object)new class_2960("minecraft:zombified_piglin"));
    public static final List<class_2960> ENTITY_EMERALD_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:enderman"), (Object)new class_2960("minecraft:evoker"), (Object)new class_2960("minecraft:vindicator"), (Object)new class_2960("minecraft:pillager"), (Object)new class_2960("minecraft:ravager"), (Object)new class_2960("minecraft:shulker"));
    public static final List<class_2960> ENTITY_DIAMOND_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:wither_skeleton"));
    public static final List<class_2960> ENTITY_NETHERITE_DROPLIST = ImmutableList.of();
    public static final List<class_2960> ENTITY_BOSS_COPPER_DROPLIST = ImmutableList.of();
    public static final List<class_2960> ENTITY_BOSS_IRON_DROPLIST = ImmutableList.of();
    public static final List<class_2960> ENTITY_BOSS_GOLD_DROPLIST = ImmutableList.of();
    public static final List<class_2960> ENTITY_BOSS_EMERALD_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:warden"));
    public static final List<class_2960> ENTITY_BOSS_DIAMOND_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:ender_dragon"));
    public static final List<class_2960> ENTITY_BOSS_NETHERITE_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:wither"));
    public static final List<class_2960> CHEST_COPPER_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:chests/underwater_ruin_small"), (Object)new class_2960("minecraft:chests/underwater_ruin_big"));
    public static final List<class_2960> CHEST_IRON_DROPLIST = ImmutableList.of();
    public static final List<class_2960> CHEST_GOLD_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:chests/jungle_temple"), (Object)new class_2960("minecraft:chests/nether_bridge"), (Object)new class_2960("minecraft:chests/simple_dungeon"), (Object)new class_2960("minecraft:chests/ruined_portal"));
    public static final List<class_2960> CHEST_EMERALD_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:chests/stronghold_crossing"), (Object)new class_2960("minecraft:chests/stronghold_corridor"), (Object)new class_2960("minecraft:chests/stronghold_library"), (Object)new class_2960("minecraft:chests/ancient_city"));
    public static final List<class_2960> CHEST_DIAMOND_DROPLIST = ImmutableList.of((Object)new class_2960("minecraft:chests/buried_treasure"), (Object)new class_2960("minecraft:chests/bastion_hoglin_stable"), (Object)new class_2960("minecraft:chests/bastion_bridge"), (Object)new class_2960("minecraft:chests/bastion_other"), (Object)new class_2960("minecraft:chests/bastion_treasure"), (Object)new class_2960("minecraft:chests/end_city_treasure"));
    public static final List<class_2960> CHEST_NETHERITE_DROPLIST = ImmutableList.of();
    private static class_55.class_56 ENTITY_LOOT_COPPER = null;
    private static class_55.class_56 ENTITY_LOOT_IRON = null;
    private static class_55.class_56 ENTITY_LOOT_GOLD = null;
    private static class_55.class_56 ENTITY_LOOT_EMERALD = null;
    private static class_55.class_56 ENTITY_LOOT_DIAMOND = null;
    private static class_55.class_56 ENTITY_LOOT_NETHERITE = null;
    private static List<class_55.class_56> ENTITY_LOOT_BOSS_COPPER = null;
    private static List<class_55.class_56> ENTITY_LOOT_BOSS_IRON = null;
    private static List<class_55.class_56> ENTITY_LOOT_BOSS_GOLD = null;
    private static List<class_55.class_56> ENTITY_LOOT_BOSS_EMERALD = null;
    private static List<class_55.class_56> ENTITY_LOOT_BOSS_DIAMOND = null;
    private static List<class_55.class_56> ENTITY_LOOT_BOSS_NETHERITE = null;
    private static class_55.class_56 CHEST_LOOT_COPPER = null;
    private static class_55.class_56 CHEST_LOOT_IRON = null;
    private static class_55.class_56 CHEST_LOOT_GOLD = null;
    private static class_55.class_56 CHEST_LOOT_EMERALD = null;
    private static class_55.class_56 CHEST_LOOT_DIAMOND = null;
    private static class_55.class_56 CHEST_LOOT_NETHERITE = null;

    public static void setup() {
        LCConfig.COMMON.addListener(LootManager::generateLootTables);
    }

    public static boolean isValidSpawnReason(String reasonString) {
        for (class_3730 reason : class_3730.values()) {
            if (reason.toString() != reasonString) continue;
            return true;
        }
        return false;
    }

    public static class_3730 deserializeSpawnReason(String reasonString) {
        return LootManager.deserializeSpawnReason(reasonString, class_3730.field_16459);
    }

    public static class_3730 deserializeSpawnReason(String reasonString, class_3730 defaultReason) {
        for (class_3730 reason : class_3730.values()) {
            if (!reason.toString().contentEquals(reasonString)) continue;
            return reason;
        }
        LightmansCurrency.LogWarning("Reason string \"" + reasonString + "\" could not be properly deserialized. Returning the default spawn reason.");
        return defaultReason;
    }

    public static boolean containsReason(List<? extends String> reasonList, class_3730 reason) {
        for (int i = 0; i < reasonList.size(); ++i) {
            if (!reason.toString().contentEquals(reasonList.get(i))) continue;
            return true;
        }
        return false;
    }

    public static String getSpawnReasonList() {
        StringBuffer output = new StringBuffer();
        for (class_3730 reason : class_3730.values()) {
            if (output.length() > 0) {
                output.append(", ");
            }
            output.append(reason);
        }
        return output.toString();
    }

    private static void generateLootTables() {
        class_1792 t1 = (class_1792)LCConfig.COMMON.lootItem1.get();
        class_1792 t2 = (class_1792)LCConfig.COMMON.lootItem2.get();
        class_1792 t3 = (class_1792)LCConfig.COMMON.lootItem3.get();
        class_1792 t4 = (class_1792)LCConfig.COMMON.lootItem4.get();
        class_1792 t5 = (class_1792)LCConfig.COMMON.lootItem5.get();
        class_1792 t6 = (class_1792)LCConfig.COMMON.lootItem6.get();
        ENTITY_LOOT_COPPER = LootManager.GenerateEntityCoinPool((class_1935)t1, 1.0f, 10.0f, 0.75f, "lightmanscurrency:entityloot_copper", true);
        ENTITY_LOOT_IRON = LootManager.GenerateEntityCoinPool((class_1935)t2, 1.0f, 5.0f, 0.5f, "lightmanscurrency:entityloot_iron", true);
        ENTITY_LOOT_GOLD = LootManager.GenerateEntityCoinPool((class_1935)t3, 1.0f, 5.0f, 0.25f, "lightmanscurrency:entityloot_gold", true);
        ENTITY_LOOT_EMERALD = LootManager.GenerateEntityCoinPool((class_1935)t4, 1.0f, 3.0f, 0.1f, "lightmanscurrency:entityloot_emerald", true);
        ENTITY_LOOT_DIAMOND = LootManager.GenerateEntityCoinPool((class_1935)t5, 1.0f, 3.0f, 0.05f, "lightmanscurrency:entityloot_diamond", true);
        ENTITY_LOOT_NETHERITE = LootManager.GenerateEntityCoinPool((class_1935)t6, 1.0f, 3.0f, 0.025f, "lightmanscurrency:entityloot_netherite", true);
        ENTITY_LOOT_BOSS_COPPER = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((class_1935)t1, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false));
        ENTITY_LOOT_BOSS_IRON = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((class_1935)t1, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t2, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false));
        ENTITY_LOOT_BOSS_GOLD = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((class_1935)t1, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t2, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t3, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false));
        ENTITY_LOOT_BOSS_EMERALD = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((class_1935)t1, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t2, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t3, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t4, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false));
        ENTITY_LOOT_BOSS_DIAMOND = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((class_1935)t1, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t2, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t3, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t4, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t5, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_diamond", false));
        ENTITY_LOOT_BOSS_NETHERITE = ImmutableList.of((Object)LootManager.GenerateEntityCoinPool((class_1935)t1, 10.0f, 30.0f, 1.0f, "lightmanscurrency:entityloot_boss_copper", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t2, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_iron", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t3, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_gold", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t4, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_emerald", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t5, 10.0f, 30.0f, 1.0f, "lightmanscurrency:coinloot_boss_diamond", false), (Object)LootManager.GenerateEntityCoinPool((class_1935)t6, 1.0f, 5.0f, 1.0f, "lightmanscurrency:coinloot_boss_netherite", false));
        CHEST_LOOT_COPPER = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER}, 1.0f, 5.0f, "lightmanscurrency:chestloot_copper");
        CHEST_LOOT_IRON = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON}, 1.0f, 5.0f, "lightmanscurrency:chestloot_iron");
        CHEST_LOOT_GOLD = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD}, 2.0f, 6.0f, "lightmanscurrency:chestloot_gold");
        CHEST_LOOT_EMERALD = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD}, 3.0f, 6.0f, "lightmanscurrency:chestloot_emerald");
        CHEST_LOOT_DIAMOND = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND}, 3.0f, 6.0f, "lightmanscurrency:chestloot_diamond");
        CHEST_LOOT_NETHERITE = LootManager.GenerateChestCoinPool(new ChestLootEntryData[]{ChestLootEntryData.COPPER, ChestLootEntryData.IRON, ChestLootEntryData.GOLD, ChestLootEntryData.EMERALD, ChestLootEntryData.DIAMOND, ChestLootEntryData.NETHERITE}, 3.0f, 6.0f, "lightmanscurrency:chestloot_netherite");
    }

    private static String getValueList(StringListOption option) {
        StringBuilder buffer = new StringBuilder();
        for (String value : (List)option.get()) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("\"").append(value).append("\"");
        }
        return buffer.toString();
    }

    public static void debugLootConfigs() {
        LightmansCurrency.LogDebug("Lightman's Currency common configs have been loaded. Coin loot values are as follows.");
        LightmansCurrency.LogDebug("Chest T1: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT1));
        LightmansCurrency.LogDebug("Chest T2: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT2));
        LightmansCurrency.LogDebug("Chest T3: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT3));
        LightmansCurrency.LogDebug("Chest T4: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT4));
        LightmansCurrency.LogDebug("Chest T5: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT5));
        LightmansCurrency.LogDebug("Chest T6: " + LootManager.getValueList(LCConfig.COMMON.chestDropsT6));
        LightmansCurrency.LogDebug("Entity T1 (Normal): " + LootManager.getValueList(LCConfig.COMMON.entityDropsT1));
        LightmansCurrency.LogDebug("Entity T2 (Normal): " + LootManager.getValueList(LCConfig.COMMON.entityDropsT2));
        LightmansCurrency.LogDebug("Entity T3 (Normal): " + LootManager.getValueList(LCConfig.COMMON.entityDropsT3));
        LightmansCurrency.LogDebug("Entity T4 (Normal): " + LootManager.getValueList(LCConfig.COMMON.entityDropsT4));
        LightmansCurrency.LogDebug("Entity T5 (Normal): " + LootManager.getValueList(LCConfig.COMMON.entityDropsT5));
        LightmansCurrency.LogDebug("Entity T6 (Normal): " + LootManager.getValueList(LCConfig.COMMON.entityDropsT6));
        LightmansCurrency.LogDebug("Entity T1 (Boss): " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT1));
        LightmansCurrency.LogDebug("Entity T2 (Boss): " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT2));
        LightmansCurrency.LogDebug("Entity T3 (Boss): " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT3));
        LightmansCurrency.LogDebug("Entity T4 (Boss): " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT4));
        LightmansCurrency.LogDebug("Entity T5 (Boss): " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT5));
        LightmansCurrency.LogDebug("Entity T6 (Boss): " + LootManager.getValueList(LCConfig.COMMON.bossEntityDropsT6));
    }

    public static void onLootTableLoaded(class_3300 resourceManager, class_60 lootManager, class_2960 id, class_52.class_53 tableBuilder, LootTableSource source) {
        if (!((Boolean)LCConfig.COMMON.enableChestLoot.get()).booleanValue()) {
            return;
        }
        PoolLevel level = LootManager.GetChestPoolLevel(id.toString());
        if (level != null) {
            LootManager.AddChestLootToTable(tableBuilder, level);
        }
    }

    public static void onEntitySpawned(class_1309 entity, class_3730 reason) {
        if (entity instanceof class_1657) {
            return;
        }
        if (reason == class_3730.field_16469) {
            EntityLootBlocker.FlagEntity(entity);
        }
    }

    public static void entityDeath(class_1309 entity, class_1282 damageSource) {
        if (entity.method_37908().field_9236) {
            return;
        }
        if (!((Boolean)LCConfig.COMMON.enableEntityDrops.get()).booleanValue()) {
            return;
        }
        if (!((Boolean)LCConfig.COMMON.allowSpawnerEntityDrops.get()).booleanValue() && EntityLootBlocker.BlockEntityDrops(entity)) {
            return;
        }
        class_1299 killedType = entity.method_5864();
        class_1297 class_12972 = damageSource.method_5529();
        if (class_12972 instanceof class_1657) {
            class_1657 player = (class_1657)class_12972;
            if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT1, killedType)) {
                LootManager.DropEntityLoot((class_1297)entity, player, PoolLevel.COPPER);
            } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT2, killedType)) {
                LootManager.DropEntityLoot((class_1297)entity, player, PoolLevel.IRON);
            } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT3, killedType)) {
                LootManager.DropEntityLoot((class_1297)entity, player, PoolLevel.GOLD);
            } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT4, killedType)) {
                LootManager.DropEntityLoot((class_1297)entity, player, PoolLevel.EMERALD);
            } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT5, killedType)) {
                LootManager.DropEntityLoot((class_1297)entity, player, PoolLevel.DIAMOND);
            } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.entityDropsT6, killedType)) {
                LootManager.DropEntityLoot((class_1297)entity, player, PoolLevel.NETHERITE);
            }
        }
        if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT1, killedType)) {
            LootManager.DropEntityLoot((class_1297)entity, null, PoolLevel.BOSS_COPPER);
        } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT2, killedType)) {
            LootManager.DropEntityLoot((class_1297)entity, null, PoolLevel.BOSS_IRON);
        } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT3, killedType)) {
            LootManager.DropEntityLoot((class_1297)entity, null, PoolLevel.BOSS_GOLD);
        } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT4, killedType)) {
            LootManager.DropEntityLoot((class_1297)entity, null, PoolLevel.BOSS_EMERALD);
        } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT5, killedType)) {
            LootManager.DropEntityLoot((class_1297)entity, null, PoolLevel.BOSS_DIAMOND);
        } else if (LootManager.ConfigContainsEntity(LCConfig.COMMON.bossEntityDropsT6, killedType)) {
            LootManager.DropEntityLoot((class_1297)entity, null, PoolLevel.BOSS_NETHERITE);
        }
    }

    private static String getSafeId(@NotNull class_1297 entity) {
        class_2960 id = class_7923.field_41177.method_10221((Object)entity.method_5864());
        return id.toString().replace(':', '_');
    }

    public static boolean ConfigContainsEntity(@NotNull StringListOption configOption, @NotNull class_1299<?> entityType) {
        class_2960 entityID = class_7923.field_41177.method_10221(entityType);
        Stream entityTags = class_7923.field_41177.method_47983(entityType).method_40228();
        for (String option : (List)configOption.get()) {
            try {
                class_2960 tagKey;
                if (!(option.startsWith("#") ? entityTags.anyMatch(arg_0 -> LootManager.lambda$ConfigContainsEntity$0(tagKey = new class_2960(option.substring(1)), arg_0)) : (option.endsWith(":*") ? new class_2960(option.replace(":*", ":null")).method_12836().equals(entityID.method_12836()) : new class_2960(option).equals((Object)entityID)))) continue;
                return true;
            }
            catch (class_151 class_1512) {
            }
        }
        return false;
    }

    private static void DropEntityLoot(class_1297 entity, class_1657 player, PoolLevel coinPool) {
        if (!((Boolean)LCConfig.COMMON.enableEntityDrops.get()).booleanValue()) {
            return;
        }
        LootManager.generateLootTables();
        class_52.class_53 table = class_52.method_324();
        class_8567.class_8568 parameterBuilder = new class_8567.class_8568((class_3218)entity.method_37908());
        if (player != null) {
            parameterBuilder.method_51874(class_181.field_1230, (Object)player).method_51874(class_181.field_1233, (Object)player);
        }
        class_8567 params = parameterBuilder.method_51875(new class_176.class_177().method_780(class_181.field_1233).method_780(class_181.field_1230).method_782());
        class_47 context = new class_47.class_48(params).method_309(new class_2960("lightmanscurrency", "generated_entity_loot/" + LootManager.getSafeId(entity)));
        try {
            if (coinPool == PoolLevel.BOSS_COPPER) {
                for (class_55.class_56 builder : ENTITY_LOOT_BOSS_COPPER) {
                    table.method_336(builder);
                }
                table.method_338().method_320(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == PoolLevel.BOSS_IRON) {
                for (class_55.class_56 builder : ENTITY_LOOT_BOSS_IRON) {
                    table.method_336(builder);
                }
                table.method_338().method_320(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == PoolLevel.BOSS_GOLD) {
                for (class_55.class_56 builder : ENTITY_LOOT_BOSS_GOLD) {
                    table.method_336(builder);
                }
                table.method_338().method_320(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == PoolLevel.BOSS_EMERALD) {
                for (class_55.class_56 builder : ENTITY_LOOT_BOSS_EMERALD) {
                    table.method_336(builder);
                }
                table.method_338().method_320(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == PoolLevel.BOSS_DIAMOND) {
                for (class_55.class_56 builder : ENTITY_LOOT_BOSS_DIAMOND) {
                    table.method_336(builder);
                }
                table.method_338().method_320(context, LootManager.LootSpawner(entity));
                return;
            }
            if (coinPool == PoolLevel.BOSS_NETHERITE) {
                for (class_55.class_56 builder : ENTITY_LOOT_BOSS_NETHERITE) {
                    table.method_336(builder);
                }
                table.method_338().method_320(context, LootManager.LootSpawner(entity));
                return;
            }
            table.pool(ENTITY_LOOT_COPPER.method_355());
            if (coinPool != PoolLevel.COPPER) {
                table.pool(ENTITY_LOOT_IRON.method_355());
                if (coinPool != PoolLevel.IRON) {
                    table.pool(ENTITY_LOOT_GOLD.method_355());
                    if (coinPool != PoolLevel.GOLD) {
                        table.pool(ENTITY_LOOT_EMERALD.method_355());
                        if (coinPool != PoolLevel.EMERALD) {
                            table.pool(ENTITY_LOOT_DIAMOND.method_355());
                            if (coinPool != PoolLevel.DIAMOND) {
                                table.pool(ENTITY_LOOT_NETHERITE.method_355());
                            }
                        }
                    }
                }
            }
            table.method_338().method_320(context, LootManager.LootSpawner(entity));
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error spawning coin drops!", e);
        }
    }

    public static void AddChestLootToTable(class_52.class_53 builder, PoolLevel coinPool) {
        LootManager.generateLootTables();
        if (coinPool == PoolLevel.COPPER) {
            builder.method_336(CHEST_LOOT_COPPER);
        } else if (coinPool == PoolLevel.IRON) {
            builder.method_336(CHEST_LOOT_IRON);
        } else if (coinPool == PoolLevel.GOLD) {
            builder.method_336(CHEST_LOOT_GOLD);
        } else if (coinPool == PoolLevel.EMERALD) {
            builder.method_336(CHEST_LOOT_EMERALD);
        } else if (coinPool == PoolLevel.DIAMOND) {
            builder.method_336(CHEST_LOOT_DIAMOND);
        } else if (coinPool == PoolLevel.NETHERITE) {
            builder.method_336(CHEST_LOOT_NETHERITE);
        }
    }

    public static List<class_1799> GetRandomChestLoot(PoolLevel coinPool, class_47 context) {
        LootManager.generateLootTables();
        try {
            if (coinPool == PoolLevel.COPPER) {
                class_52.class_53 table = class_52.method_324();
                table.method_336(CHEST_LOOT_COPPER);
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.IRON) {
                class_52.class_53 table = class_52.method_324();
                table.pool(CHEST_LOOT_IRON.method_355());
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.GOLD) {
                class_52.class_53 table = class_52.method_324();
                table.pool(CHEST_LOOT_GOLD.method_355());
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.EMERALD) {
                class_52.class_53 table = class_52.method_324();
                table.pool(CHEST_LOOT_EMERALD.method_355());
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.DIAMOND) {
                class_52.class_53 table = class_52.method_324();
                table.pool(CHEST_LOOT_DIAMOND.method_355());
                return LootManager.safelyGetResults(table, context);
            }
            if (coinPool == PoolLevel.NETHERITE) {
                class_52.class_53 table = class_52.method_324();
                table.pool(CHEST_LOOT_NETHERITE.method_355());
                return LootManager.safelyGetResults(table, context);
            }
            LightmansCurrency.LogError("Attempting to get random chest loot from an invalid chest pool level of '" + (coinPool == null ? "NULL" : coinPool.toString()) + "'");
            return new ArrayList<class_1799>();
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error spawning chest coin drops!", e);
            return new ArrayList<class_1799>();
        }
    }

    private static List<class_1799> safelyGetResults(class_52.class_53 table, class_47 context) {
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        table.method_338().method_320(context, results::add);
        return results;
    }

    public static PoolLevel GetChestPoolLevel(String lootTable) {
        if (((List)LCConfig.COMMON.chestDropsT1.get()).contains(lootTable)) {
            return PoolLevel.COPPER;
        }
        if (((List)LCConfig.COMMON.chestDropsT2.get()).contains(lootTable)) {
            return PoolLevel.IRON;
        }
        if (((List)LCConfig.COMMON.chestDropsT3.get()).contains(lootTable)) {
            return PoolLevel.GOLD;
        }
        if (((List)LCConfig.COMMON.chestDropsT5.get()).contains(lootTable)) {
            return PoolLevel.EMERALD;
        }
        if (((List)LCConfig.COMMON.chestDropsT5.get()).contains(lootTable)) {
            return PoolLevel.DIAMOND;
        }
        if (((List)LCConfig.COMMON.chestDropsT6.get()).contains(lootTable)) {
            return PoolLevel.NETHERITE;
        }
        return null;
    }

    private static Consumer<class_1799> LootSpawner(class_1297 entity) {
        return i -> InventoryUtil.dumpContents(entity.method_37908(), entity.method_24515(), i);
    }

    private static class_55.class_56 GenerateEntityCoinPool(class_1935 item, float min, float max, float chance, String name, boolean requirePlayerKill) {
        class_55.class_56 lootPoolBuilder = class_55.method_347().method_352((class_5658)class_44.method_32448((float)1.0f)).method_351((class_79.class_80)class_77.method_411((class_1935)item).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)min, (float)max))).method_438((class_117.class_118)class_125.method_547((class_5658)class_5662.method_32462((float)0.0f, (float)1.0f))));
        if (requirePlayerKill) {
            lootPoolBuilder.method_356(class_221.method_939());
        }
        if (chance < 1.0f) {
            lootPoolBuilder.method_356(class_225.method_953((float)chance, (float)0.01f));
        }
        return lootPoolBuilder;
    }

    private static class_55.class_56 GenerateChestCoinPool(ChestLootEntryData[] lootEntries, float minRolls, float maxRolls, String name) {
        class_55.class_56 lootPoolBuilder = class_55.method_347().method_352((class_5658)class_5662.method_32462((float)minRolls, (float)maxRolls));
        for (ChestLootEntryData entry : lootEntries) {
            lootPoolBuilder.method_351((class_79.class_80)class_77.method_411((class_1935)((class_1935)entry.item.get())).method_438((class_117.class_118)class_141.method_621((class_5658)class_5662.method_32462((float)entry.minCount, (float)entry.maxCount))).method_437(entry.weight));
        }
        return lootPoolBuilder;
    }

    private static /* synthetic */ boolean lambda$ConfigContainsEntity$0(class_2960 tagKey, class_6862 tag) {
        return tag.comp_327().equals((Object)tagKey);
    }

    private record ChestLootEntryData(Supplier<class_1792> item, float minCount, float maxCount, int weight) {
        public static ChestLootEntryData COPPER = new ChestLootEntryData(LCConfig.COMMON.lootItem1, 1.0f, 10.0f, 1);
        public static ChestLootEntryData IRON = new ChestLootEntryData(LCConfig.COMMON.lootItem2, 1.0f, 10.0f, 2);
        public static ChestLootEntryData GOLD = new ChestLootEntryData(LCConfig.COMMON.lootItem3, 1.0f, 10.0f, 3);
        public static ChestLootEntryData EMERALD = new ChestLootEntryData(LCConfig.COMMON.lootItem4, 1.0f, 10.0f, 4);
        public static ChestLootEntryData DIAMOND = new ChestLootEntryData(LCConfig.COMMON.lootItem5, 1.0f, 8.0f, 5);
        public static ChestLootEntryData NETHERITE = new ChestLootEntryData(LCConfig.COMMON.lootItem6, 1.0f, 3.0f, 6);
    }

    public static enum PoolLevel {
        COPPER(0, true),
        IRON(1, true),
        GOLD(2, true),
        EMERALD(3, true),
        DIAMOND(4, true),
        NETHERITE(5, true),
        BOSS_COPPER(6, false),
        BOSS_IRON(7, false),
        BOSS_GOLD(8, false),
        BOSS_EMERALD(9, false),
        BOSS_DIAMOND(10, false),
        BOSS_NETHERITE(11, false);

        public final int level;
        private final boolean requiresPlayerKill;

        public final boolean requiresPlayerKill() {
            return this.requiresPlayerKill;
        }

        private PoolLevel(int level, boolean requiresPlayerKill) {
            this.level = level;
            this.requiresPlayerKill = requiresPlayerKill;
        }
    }
}

