/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu;

import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menu.Menu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class ATMMenu
extends Menu
implements BankAccount.IBankAccountAdvancedMenu {
    private class_1657 player;
    private final class_1263 coinInput = new class_1277(9);
    private class_2561 transferMessage = null;

    @Override
    public class_1657 getPlayer() {
        return this.player;
    }

    @Override
    public class_1263 getCoinInput() {
        return this.coinInput;
    }

    public ATMMenu(int windowId, class_1661 inventory) {
        super(ModMenus.ATM, windowId);
        int x;
        this.player = inventory.field_7546;
        for (x = 0; x < this.coinInput.method_5439(); ++x) {
            this.method_7621(new CoinSlot(this.coinInput, x, 8 + x * 18, 129, false));
        }
        for (int y = 0; y < 3; ++y) {
            for (int x2 = 0; x2 < 9; ++x2) {
                this.method_7621(new class_1735((class_1263)inventory, x2 + y * 9 + 9, 8 + x2 * 18, 161 + y * 18));
            }
        }
        for (x = 0; x < 9; ++x) {
            this.method_7621(new class_1735((class_1263)inventory, x, 8 + x * 18, 219));
        }
    }

    public boolean method_7597(class_1657 playerIn) {
        this.getBankAccountReference();
        return true;
    }

    public void method_7595(class_1657 playerIn) {
        super.method_7595(playerIn);
        this.method_7607(playerIn, this.coinInput);
        if (!this.isClient()) {
            BankAccount.AccountReference account = this.getBankAccountReference();
            if (account.accountType == BankAccount.AccountType.Player && !account.playerID.equals(this.player.method_5667())) {
                BankSaveData.SetSelectedBankAccount(this.player, BankAccount.GenerateReference(this.player));
            }
        }
    }

    public class_1799 method_7601(class_1657 playerEntity, int index) {
        class_1799 clickedStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            clickedStack = slotStack.method_7972();
            if (index < this.coinInput.method_5439() ? MoneyUtil.isCoin(slotStack.method_7909()) && !this.method_7616(slotStack, this.coinInput.method_5439(), this.field_7761.size(), true) : !this.method_7616(slotStack, 0, this.coinInput.method_5439(), false)) {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_48931(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return clickedStack;
    }

    public void ExchangeCoins(String command) {
        if (command.contentEquals("convertAllUp")) {
            MoneyUtil.ConvertAllCoinsUp(this.coinInput);
        } else if (command.startsWith("convertUp-")) {
            class_2960 coinID = null;
            String id = "";
            try {
                id = command.substring("convertUp-".length());
                coinID = new class_2960(id);
                class_1792 coinItem = (class_1792)class_7923.field_41178.method_10223(coinID);
                if (coinItem == null) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is not a registered item.");
                    return;
                }
                if (!MoneyUtil.isCoin(coinItem)) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is not a coin.");
                    return;
                }
                if (MoneyUtil.getUpwardConversion(coinItem) == null) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is the largest visible coin in its chain, and thus cannot be converted any larger.");
                    return;
                }
                MoneyUtil.ConvertCoinsUp(this.coinInput, coinItem);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + id + "' could not be parsed as an item id.", e);
            }
        } else if (command.contentEquals("convertAllDown")) {
            MoneyUtil.ConvertAllCoinsDown(this.coinInput);
        } else if (command.startsWith("convertDown-")) {
            String id = "";
            try {
                id = command.substring("convertDown-".length());
                class_2960 coinID = new class_2960(id);
                class_1792 coinItem = (class_1792)class_7923.field_41178.method_10223(coinID);
                if (coinItem == null) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is not a registered item.");
                    return;
                }
                if (!MoneyUtil.isCoin(coinItem)) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is not a coin.");
                    return;
                }
                if (MoneyUtil.getDownwardConversion(coinItem) == null) {
                    LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + coinID.toString() + "' is the smallest known coin, and thus cannot be converted any smaller.");
                    return;
                }
                MoneyUtil.ConvertCoinsDown(this.coinInput, coinItem);
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error handling ATM Conversion command '" + command + "'.\n'" + id + "' could not be parsed as an item id.", e);
            }
        } else {
            LightmansCurrency.LogError("'" + command + "' is not a valid ATM Conversion command.");
        }
    }

    public class_5250 SetPlayerAccount(String playerName) {
        if (CommandLCAdmin.isAdminPlayer(this.player)) {
            PlayerReference accountPlayer = PlayerReference.of(false, playerName);
            if (accountPlayer != null) {
                BankSaveData.SetSelectedBankAccount(this.player, BankAccount.GenerateReference(false, accountPlayer));
                return class_2561.method_43469((String)"gui.bank.select.player.success", (Object[])new Object[]{accountPlayer.getName(false)});
            }
            return class_2561.method_43471((String)"gui.bank.transfer.error.null.to");
        }
        return class_2561.method_43470((String)"ERROR");
    }

    public boolean hasTransferMessage() {
        return this.transferMessage != null;
    }

    public class_2561 getTransferMessage() {
        return this.transferMessage;
    }

    @Override
    public void setTransferMessage(class_2561 message) {
        this.transferMessage = message;
    }

    public void clearMessage() {
        this.transferMessage = null;
    }

    @Override
    public boolean isClient() {
        return this.player.method_37908().field_9236;
    }
}

