/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu.slots;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.common.menu.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class CoinSlot
extends SimpleSlot {
    public static final class_2960 EMPTY_COIN_SLOT = new class_2960("lightmanscurrency", "item/empty_coin_slot");
    private boolean acceptHiddenCoins;
    private boolean lockInput = false;
    private boolean lockOutput = false;
    private List<Runnable> listeners = new ArrayList<Runnable>();

    public void LockInput() {
        this.lockInput = true;
    }

    public void UnlockInput() {
        this.lockInput = false;
    }

    public void LockOutput() {
        this.lockOutput = true;
    }

    public void UnlockOutput() {
        this.lockOutput = false;
    }

    public void Lock() {
        this.lockOutput = true;
        this.lockInput = true;
    }

    public void Unlock() {
        this.lockOutput = false;
        this.lockInput = false;
    }

    public CoinSlot(class_1263 inventory, int index, int x, int y) {
        this(inventory, index, x, y, true);
    }

    public CoinSlot(class_1263 inventory, int index, int x, int y, boolean acceptHiddenCoins) {
        super(inventory, index, x, y);
        this.acceptHiddenCoins = acceptHiddenCoins;
    }

    public CoinSlot addListener(Runnable listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
        return this;
    }

    @Override
    public boolean method_7680(class_1799 stack) {
        if (this.lockInput) {
            return false;
        }
        if (this.acceptHiddenCoins) {
            return MoneyUtil.isCoin(stack.method_7909());
        }
        return MoneyUtil.isCoin(stack.method_7909()) && !MoneyUtil.isCoinHidden(stack.method_7909());
    }

    public void method_48931(class_1799 stack) {
        if (this.lockInput && !stack.method_7960()) {
            return;
        }
        super.method_48931(stack);
    }

    @Override
    public class_1799 method_7671(int amount) {
        if (this.lockOutput) {
            return class_1799.field_8037;
        }
        return super.method_7671(amount);
    }

    @Override
    public boolean method_7674(class_1657 player) {
        if (this.lockOutput) {
            return false;
        }
        return super.method_7674(player);
    }

    public Pair<class_2960, class_2960> method_7679() {
        return Pair.of((Object)class_1723.field_21668, (Object)EMPTY_COIN_SLOT);
    }

    public void method_7668() {
        super.method_7668();
        this.listeners.forEach(listener -> listener.run());
    }
}

