/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu.traderstorage.auction;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.auction.AuctionStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.traders.auction.AuctionPlayerStorage;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class AuctionStorageTab
extends TraderStorageTab {
    public AuctionStorageTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new AuctionStorageClientTab(screen, this);
    }

    @Override
    public boolean canOpen(class_1657 player) {
        return this.menu.getTrader() instanceof AuctionHouseTrader;
    }

    @Override
    public void addStorageMenuSlots(Function<class_1735, class_1735> addSlot) {
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    public void clickedOnSlot(int storageSlot, boolean isShiftHeld) {
        TraderData t = this.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            AuctionPlayerStorage storage = trader.getStorage(this.menu.player);
            if (storageSlot >= 0 && storageSlot < storage.getStoredItems().size()) {
                class_1799 storedItem = storage.getStoredItems().get(storageSlot);
                if (storedItem.method_7960()) {
                    storage.getStoredItems().remove(storageSlot);
                    trader.markStorageDirty();
                } else {
                    int transferCount;
                    class_1799 heldItem = this.menu.method_34255();
                    if (isShiftHeld) {
                        this.menu.player.method_31548().method_7394(storedItem);
                        if (storedItem.method_7960()) {
                            storage.getStoredItems().remove(storageSlot);
                        }
                        trader.markStorageDirty();
                    } else if (heldItem.method_7960()) {
                        this.menu.method_34254(storedItem);
                        storage.getStoredItems().remove(storageSlot);
                        trader.markStorageDirty();
                    } else if (InventoryUtil.ItemMatches(storedItem, heldItem) && (transferCount = Math.min(heldItem.method_7914() - heldItem.method_7947(), storedItem.method_7947())) > 0) {
                        heldItem.method_7933(transferCount);
                        this.menu.method_34254(heldItem);
                        storedItem.method_7934(transferCount);
                        if (storedItem.method_7960()) {
                            storage.getStoredItems().remove(storageSlot);
                        }
                        trader.markStorageDirty();
                    }
                }
            }
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("ClickedSlot", storageSlot);
                message.method_10556("HeldShift", isShiftHeld);
                this.menu.sendMessage(message);
            }
        }
    }

    public void quickTransfer() {
        TraderData t = this.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            AuctionPlayerStorage storage = trader.getStorage(this.menu.player);
            storage.collectItems(this.menu.player);
            trader.markStorageDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10556("QuickTransfer", true);
                this.menu.sendMessage(message);
            }
        }
    }

    public void collectCoins() {
        TraderData t = this.menu.getTrader();
        if (t instanceof AuctionHouseTrader) {
            AuctionHouseTrader trader = (AuctionHouseTrader)t;
            AuctionPlayerStorage storage = trader.getStorage(this.menu.player);
            storage.collectedMoney(this.menu.player);
            trader.markStorageDirty();
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10556("CollectMoney", true);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(class_2487 message) {
        if (message.method_10573("ClickedSlot", 3)) {
            int storageSlot = message.method_10550("ClickedSlot");
            boolean isShiftHeld = message.method_10577("HeldShift");
            this.clickedOnSlot(storageSlot, isShiftHeld);
        }
        if (message.method_10545("QuickTransfer")) {
            this.quickTransfer();
        }
        if (message.method_10545("CollectMoney")) {
            this.collectCoins();
        }
    }
}

