/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu.traderstorage.slot_machine;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.slot_machine.SlotMachineStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.common.menu.slots.trader.UpgradeInputSlot;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.storage.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.slot_machine.SlotMachineTraderData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;

public class SlotMachineStorageTab
extends TraderStorageTab {
    List<SimpleSlot> slots = new ArrayList<SimpleSlot>();

    public SlotMachineStorageTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new SlotMachineStorageClientTab(screen, this);
    }

    @Override
    public boolean canOpen(class_1657 player) {
        return true;
    }

    public List<? extends class_1735> getSlots() {
        return this.slots;
    }

    @Override
    public void addStorageMenuSlots(Function<class_1735, class_1735> addSlot) {
        SlotMachineTraderData trader;
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData && !(trader = (SlotMachineTraderData)traderData).isPersistent()) {
            for (int i = 0; i < trader.getUpgrades().method_5439(); ++i) {
                UpgradeInputSlot upgradeSlot = new UpgradeInputSlot(trader.getUpgrades(), i, 176, 18 + 18 * i, trader);
                upgradeSlot.active = false;
                addSlot.apply(upgradeSlot);
                this.slots.add(upgradeSlot);
            }
        }
    }

    @Override
    public void onTabOpen() {
        SimpleSlot.SetActive(this.slots);
    }

    @Override
    public void onTabClose() {
        SimpleSlot.SetInactive(this.slots);
    }

    @Override
    public boolean quickMoveStack(class_1799 stack) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            if (trader.isPersistent()) {
                return false;
            }
            TraderItemStorage storage = trader.getStorage();
            if (storage.getFittableAmount(stack) > 0) {
                storage.tryAddItem(stack);
                trader.markStorageDirty();
                return true;
            }
        }
        return super.quickMoveStack(stack);
    }

    public void clickedOnSlot(int storageSlot, boolean isShiftHeld, boolean leftClick) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            if (trader.isPersistent()) {
                return;
            }
            TraderItemStorage storage = trader.getStorage();
            class_1799 heldItem = this.menu.method_34255();
            if (heldItem.method_7960()) {
                List<class_1799> storageContents = storage.getContents();
                if (storageSlot >= 0 && storageSlot < storageContents.size()) {
                    int removedAmount;
                    class_1799 stackToRemove = storageContents.get(storageSlot).method_7972();
                    class_1799 removeStack = stackToRemove.method_7972();
                    int tempAmount = Math.min(stackToRemove.method_7914(), stackToRemove.method_7947());
                    stackToRemove.method_7939(tempAmount);
                    if (!leftClick) {
                        if (tempAmount > 1) {
                            tempAmount /= 2;
                        }
                        stackToRemove.method_7939(tempAmount);
                    }
                    if (isShiftHeld) {
                        this.menu.player.method_31548().method_7394(stackToRemove);
                        removedAmount = tempAmount - stackToRemove.method_7947();
                    } else {
                        this.menu.method_34254(stackToRemove);
                        removedAmount = tempAmount;
                    }
                    if (removedAmount > 0) {
                        removeStack.method_7939(removedAmount);
                        storage.removeItem(removeStack);
                        trader.markStorageDirty();
                    }
                }
            } else if (leftClick) {
                storage.tryAddItem(heldItem);
                trader.markStorageDirty();
            } else {
                class_1799 addItem = heldItem.method_7972();
                addItem.method_7939(1);
                if (storage.addItem(addItem)) {
                    heldItem.method_7934(1);
                    if (heldItem.method_7960()) {
                        this.menu.method_34254(class_1799.field_8037);
                    }
                }
                trader.markStorageDirty();
            }
            if (this.menu.isClient()) {
                this.sendStorageClickMessage(storageSlot, isShiftHeld, leftClick);
            }
        }
    }

    private void sendStorageClickMessage(int storageSlot, boolean isShiftHeld, boolean leftClick) {
        class_2487 message = new class_2487();
        message.method_10569("ClickedSlot", storageSlot);
        message.method_10556("HeldShift", isShiftHeld);
        message.method_10556("LeftClick", leftClick);
        this.menu.sendMessage(message);
    }

    public void quickTransfer(int type) {
        TraderData traderData = this.menu.getTrader();
        if (traderData instanceof SlotMachineTraderData) {
            SlotMachineTraderData trader = (SlotMachineTraderData)traderData;
            if (trader.isPersistent()) {
                return;
            }
            TraderItemStorage storage = trader.getStorage();
            class_1661 inv = this.menu.player.method_31548();
            boolean changed = false;
            if (type == 0) {
                for (int i = 0; i < 36; ++i) {
                    class_1799 stack = inv.method_5438(i);
                    int fillAmount = storage.getFittableAmount(stack);
                    if (fillAmount <= 0) continue;
                    class_1799 fillStack = inv.method_5434(i, fillAmount);
                    storage.forceAddItem(fillStack);
                }
            } else if (type == 1) {
                List<class_1799> itemList = InventoryUtil.copyList(storage.getContents());
                for (class_1799 stack : itemList) {
                    boolean keepTrying = true;
                    while (storage.getItemCount(stack) > 0 && keepTrying) {
                        class_1799 transferStack = stack.method_7972();
                        int transferCount = Math.min(storage.getItemCount(stack), stack.method_7914());
                        transferStack.method_7939(transferCount);
                        int removedCount = InventoryUtil.safeGiveToPlayer(inv, transferStack);
                        if (removedCount > 0) {
                            changed = true;
                            class_1799 removeStack = stack.method_7972();
                            removeStack.method_7939(removedCount);
                            storage.removeItem(removeStack);
                            continue;
                        }
                        keepTrying = false;
                    }
                }
            }
            if (changed) {
                trader.markStorageDirty();
            }
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10569("QuickTransfer", type);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(class_2487 message) {
        if (message.method_10573("ClickedSlot", 3)) {
            int storageSlot = message.method_10550("ClickedSlot");
            boolean isShiftHeld = message.method_10577("HeldShift");
            boolean leftClick = message.method_10577("LeftClick");
            this.clickedOnSlot(storageSlot, isShiftHeld, leftClick);
        }
        if (message.method_10545("QuickTransfer")) {
            this.quickTransfer(message.method_10550("QuickTransfer"));
        }
    }
}

