/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu.traderstorage.trades_basic;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderStorageScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.BasicTradeEditClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menu.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.common.menu.traderstorage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.traders.tradedata.TradeData;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class BasicTradeEditTab
extends TraderStorageTab {
    public static final int INTERACTION_INPUT = 0;
    public static final int INTERACTION_OUTPUT = 1;
    public static final int INTERACTION_OTHER = 2;
    TraderStorageMenu.IClientMessage clientHandler = null;

    public BasicTradeEditTab(TraderStorageMenu menu) {
        super(menu);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public TraderStorageClientTab<?> createClientTab(TraderStorageScreen screen) {
        return new BasicTradeEditClientTab<BasicTradeEditTab>(screen, this);
    }

    public void setClientHandler(TraderStorageMenu.IClientMessage clientHandler) {
        this.clientHandler = clientHandler;
    }

    @Override
    public boolean canOpen(class_1657 player) {
        return true;
    }

    @Override
    public void onTabOpen() {
    }

    @Override
    public void onTabClose() {
    }

    @Override
    public void addStorageMenuSlots(Function<class_1735, class_1735> addSlot) {
    }

    public void sendOpenTabMessage(int newTab, @Nullable class_2487 additionalData) {
        class_2487 message = this.menu.createTabChangeMessage(newTab, additionalData);
        if (this.clientHandler != null) {
            this.clientHandler.selfMessage(message);
        }
        this.menu.sendMessage(message);
    }

    public void sendInputInteractionMessage(int tradeIndex, int interactionIndex, int button, class_1799 heldItem) {
        class_2487 message = new class_2487();
        message.method_10569("TradeIndex", tradeIndex);
        message.method_10569("InteractionType", 0);
        message.method_10569("InteractionIndex", interactionIndex);
        message.method_10569("Button", button);
        class_2487 itemTag = new class_2487();
        heldItem.method_7953(itemTag);
        message.method_10566("HeldItem", (class_2520)itemTag);
        this.menu.sendMessage(message);
    }

    public void sendOutputInteractionMessage(int tradeIndex, int interactionIndex, int button, class_1799 heldItem) {
        class_2487 message = new class_2487();
        message.method_10569("TradeIndex", tradeIndex);
        message.method_10569("InteractionType", 1);
        message.method_10569("InteractionIndex", interactionIndex);
        message.method_10569("Button", button);
        class_2487 itemTag = new class_2487();
        heldItem.method_7953(itemTag);
        message.method_10566("HeldItem", (class_2520)itemTag);
        this.menu.sendMessage(message);
    }

    public void sendOtherInteractionMessage(int tradeIndex, int mouseX, int mouseY, int button, class_1799 heldItem) {
        class_2487 message = new class_2487();
        message.method_10569("TradeIndex", tradeIndex);
        message.method_10569("InteractionType", 2);
        message.method_10569("Button", button);
        message.method_10569("MouseX", mouseX);
        message.method_10569("MouseY", mouseX);
        class_2487 itemTag = new class_2487();
        heldItem.method_7953(itemTag);
        message.method_10566("HeldItem", (class_2520)itemTag);
        this.menu.sendMessage(message);
    }

    public void addTrade() {
        if (this.menu.getTrader() != null) {
            this.menu.getTrader().addTrade(this.menu.player);
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10556("AddTrade", true);
                this.menu.sendMessage(message);
            }
        }
    }

    public void removeTrade() {
        if (this.menu.getTrader() != null) {
            this.menu.getTrader().removeTrade(this.menu.player);
            if (this.menu.isClient()) {
                class_2487 message = new class_2487();
                message.method_10556("RemoveTrade", true);
                this.menu.sendMessage(message);
            }
        }
    }

    @Override
    public void receiveMessage(class_2487 message) {
        if (message.method_10573("TradeIndex", 3)) {
            int tradeIndex = message.method_10550("TradeIndex");
            int interaction = message.method_10550("InteractionType");
            int interactionIndex = message.method_10573("InteractionIndex", 3) ? message.method_10550("InteractionIndex") : 0;
            int button = message.method_10550("Button");
            int mouseX = message.method_10573("MouseX", 3) ? message.method_10550("MouseX") : 0;
            int mouseY = message.method_10573("MouseY", 3) ? message.method_10550("MouseY") : 0;
            class_1799 heldItem = class_1799.method_7915((class_2487)message.method_10562("HeldItem"));
            TradeData trade = this.menu.getTrader().getTradeData().get(tradeIndex);
            switch (interaction) {
                case 0: {
                    trade.onInputDisplayInteraction(this, this.clientHandler, interactionIndex, button, heldItem);
                    break;
                }
                case 1: {
                    trade.onOutputDisplayInteraction(this, this.clientHandler, interactionIndex, button, heldItem);
                    break;
                }
                case 2: {
                    trade.onInteraction(this, this.clientHandler, mouseX, mouseY, button, heldItem);
                    break;
                }
                default: {
                    LightmansCurrency.LogWarning("Interaction Type " + interaction + " is not a valid interaction.");
                }
            }
            this.menu.getTrader().markTradesDirty();
        }
        if (message.method_10545("AddTrade")) {
            this.addTrade();
        }
        if (message.method_10545("RemoveTrade")) {
            this.removeTrade();
        }
    }
}

