/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menu.wallet;

import io.github.lightman314.lightmanscurrency.common.items.WalletItem;
import io.github.lightman314.lightmanscurrency.common.menu.Menu;
import io.github.lightman314.lightmanscurrency.common.menu.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.common.menu.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_3917;

public abstract class WalletMenuBase
extends Menu {
    private static int maxWalletSlots = 0;
    protected final class_1263 dummyInventory = new class_1277(1);
    protected final int walletStackIndex;
    protected final class_1661 inventory;
    private boolean autoConvert;
    protected final class_1263 coinInput;
    protected final WalletItem walletItem;
    public final class_1657 player;

    public static int getMaxWalletSlots() {
        return maxWalletSlots;
    }

    public static void updateMaxWalletSlots(int slotCount) {
        maxWalletSlots = Math.max(maxWalletSlots, slotCount);
    }

    public final boolean isEquippedWallet() {
        return this.walletStackIndex < 0;
    }

    public final int getWalletStackIndex() {
        return this.walletStackIndex;
    }

    public final boolean hasWallet() {
        class_1799 wallet = this.getWallet();
        return !wallet.method_7960() && wallet.method_7909() instanceof WalletItem;
    }

    public final class_1799 getWallet() {
        if (this.isEquippedWallet()) {
            return WalletHandler.getWallet(this.player).getWallet();
        }
        return this.inventory.method_5438(this.walletStackIndex);
    }

    public boolean canConvert() {
        return WalletItem.CanExchange(this.walletItem);
    }

    public boolean canPickup() {
        return WalletItem.CanPickup(this.walletItem);
    }

    public boolean hasBankAccess() {
        return WalletItem.HasBankAccess(this.walletItem);
    }

    public boolean getAutoConvert() {
        return this.autoConvert;
    }

    public void ToggleAutoExchange() {
        this.autoConvert = !this.autoConvert;
        this.saveWalletContents();
    }

    public class_1657 getPlayer() {
        return this.player;
    }

    protected WalletMenuBase(class_3917<?> type, int windowID, class_1661 inventory, int walletStackIndex) {
        super(type, windowID);
        this.inventory = inventory;
        this.player = this.inventory.field_7546;
        this.walletStackIndex = walletStackIndex;
        class_1792 item = this.getWallet().method_7909();
        this.walletItem = item instanceof WalletItem ? (WalletItem)item : null;
        this.coinInput = new class_1277(WalletItem.InventorySize(this.walletItem));
        this.reloadWalletContents();
        this.autoConvert = WalletItem.getAutoConvert(this.getWallet());
    }

    protected final void addCoinSlots(int yPosition) {
        int y = 0;
        while (y * 9 < this.coinInput.method_5439()) {
            for (int x = 0; x < 9 && x + y * 9 < this.coinInput.method_5439(); ++x) {
                this.method_7621(new CoinSlot(this.coinInput, x + y * 9, 8 + x * 18, yPosition + y * 18).addListener(this::saveWalletContents));
            }
            ++y;
        }
    }

    protected final void addDummySlots(int slotLimit) {
        while (this.field_7761.size() < slotLimit) {
            this.method_7621(new DisplaySlot(this.dummyInventory, 0, 0x3FFFFFFF, 0x3FFFFFFF));
        }
    }

    public final void reloadWalletContents() {
        class_2371<class_1799> walletInventory = WalletItem.getWalletInventory(this.getWallet());
        for (int i = 0; i < this.coinInput.method_5439() && i < walletInventory.size(); ++i) {
            this.coinInput.method_5447(i, (class_1799)walletInventory.get(i));
        }
    }

    public final int getRowCount() {
        return 1 + (this.coinInput.method_5439() - 1) / 9;
    }

    public final int getSlotCount() {
        return this.coinInput.method_5439();
    }

    public boolean method_7597(class_1657 playerIn) {
        return this.hasWallet();
    }

    public final void saveWalletContents() {
        if (!this.hasWallet()) {
            return;
        }
        class_2371 walletInventory = class_2371.method_10213((int)WalletItem.InventorySize(this.walletItem), (Object)class_1799.field_8037);
        for (int i = 0; i < walletInventory.size() && i < this.coinInput.method_5439(); ++i) {
            walletInventory.set(i, (Object)this.coinInput.method_5438(i));
        }
        WalletItem.putWalletInventory(this.getWallet(), (class_2371<class_1799>)walletInventory);
        if (this.autoConvert != WalletItem.getAutoConvert(this.getWallet())) {
            WalletItem.toggleAutoConvert(this.getWallet());
        }
    }

    public final void ExchangeCoins() {
        MoneyUtil.ConvertAllCoinsUp(this.coinInput);
        MoneyUtil.SortCoins(this.coinInput);
        this.saveWalletContents();
    }

    public final class_1799 PickupCoins(class_1799 stack) {
        class_1799 returnValue = stack.method_7972();
        for (int i = 0; i < this.coinInput.method_5439() && !returnValue.method_7960(); ++i) {
            class_1799 thisStack = this.coinInput.method_5438(i);
            if (thisStack.method_7960()) {
                this.coinInput.method_5447(i, returnValue.method_7972());
                returnValue = class_1799.field_8037;
                continue;
            }
            if (!InventoryUtil.ItemMatches(thisStack, returnValue)) continue;
            int amountToAdd = MathUtil.clamp(returnValue.method_7947(), 0, thisStack.method_7914() - thisStack.method_7947());
            thisStack.method_7939(thisStack.method_7947() + amountToAdd);
            returnValue.method_7939(returnValue.method_7947() - amountToAdd);
        }
        if (this.autoConvert) {
            this.ExchangeCoins();
        } else {
            this.saveWalletContents();
        }
        return returnValue;
    }
}

