/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.money.CoinData;
import io.github.lightman314.lightmanscurrency.common.money.DefaultMoneyDataCollection;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.network.client.ServerToClientPacket;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_7923;

public class MoneyData
extends ServerToClientPacket {
    public static final class_2960 PACKET_ID = new class_2960("lightmanscurrency", "money_data_packet");
    private List<CoinData> coinList = new ArrayList<CoinData>();
    private List<CoinData> sortedCoinList = new ArrayList<CoinData>();

    public MoneyData(CoinDataCollector collector) {
        super(PACKET_ID);
        for (CoinData.Builder dataBuilder : collector.coinBuilderList) {
            this.addCoinItem(dataBuilder);
        }
        this.sortCoinList();
    }

    public static MoneyData fromJson(JsonObject json) throws Throwable {
        JsonArray array = json.get("CoinEntries").getAsJsonArray();
        CoinDataCollector collector = new CoinDataCollector();
        for (int i = 0; i < array.size(); ++i) {
            try {
                CoinData.Builder builder = CoinData.getBuilder(array.get(i).getAsJsonObject());
                collector.addCoinBuilder(builder);
                continue;
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error loading coin entry " + (i + 1), e);
            }
        }
        return new MoneyData(collector);
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        JsonArray dataList = new JsonArray();
        for (int i = 0; i < this.coinList.size(); ++i) {
            try {
                JsonObject entry = this.coinList.get(i).toJson();
                dataList.add((JsonElement)entry);
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        json.add("CoinEntries", (JsonElement)dataList);
        return json;
    }

    @Override
    public void encode(LazyPacketData.Builder dataBuilder) {
        JsonObject json = this.toJson();
        String jsonString = FileUtil.GSON.toJson((JsonElement)json);
        dataBuilder.setString("json", jsonString);
    }

    private static MoneyData decode(LazyPacketData data) {
        try {
            LightmansCurrency.LogDebug("Decoding money data packet:");
            String jsonString = data.getString("json");
            JsonObject json = JsonParser.parseString((String)jsonString).getAsJsonObject();
            return MoneyData.fromJson(json);
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error decoding MoneyData.", t);
            return MoneyData.generateDefault();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static void handle(class_310 client, class_634 handler, LazyPacketData data, PacketSender responseSender) {
        LightmansCurrency.LogInfo("Received money data packet from server. Synchronizing coin list.");
        MoneyUtil.receiveMoneyData(MoneyData.decode(data));
    }

    public static MoneyData generateDefault() {
        CoinDataCollector dataCollector = new CoinDataCollector();
        ((DefaultMoneyDataCollection)DefaultMoneyDataCollection.EVENT.invoker()).appendMoneyData(dataCollector);
        return new MoneyData(dataCollector);
    }

    private void addCoinItem(CoinData.Builder newCoinDataBuilder) {
        CoinData newCoinData = newCoinDataBuilder.build();
        for (CoinData coinData : this.coinList) {
            if (coinData.coinItem == newCoinData.coinItem) {
                LightmansCurrency.LogWarning("Attempted to add Duplicate Coin Item (" + class_7923.field_41178.method_10221((Object)newCoinData.coinItem).toString() + ") to the coin list.");
                return;
            }
            if (coinData.worthOtherCoin != newCoinData.worthOtherCoin || newCoinData.isHidden || coinData.isHidden || newCoinData.worthOtherCoin == null || !coinData.chain.contentEquals(newCoinData.chain)) continue;
            LightmansCurrency.LogWarning("Attempted to add a new Coin Item '" + class_7923.field_41178.method_10221((Object)newCoinData.coinItem) + "' with the same dependent (" + class_7923.field_41178.method_10221((Object)coinData.worthOtherCoin) + ") as another coin (" + class_7923.field_41178.method_10221((Object)coinData.coinItem) + ") in the same chain '" + coinData.chain + "'.\nEntry will be flagged as hidden.");
            newCoinData = newCoinDataBuilder.setHidden().build();
        }
        LightmansCurrency.LogInfo("Registered " + class_7923.field_41178.method_10221((Object)newCoinData.coinItem) + " as a coin.");
        this.coinList.add(newCoinData);
    }

    private void sortCoinList() {
        this.sortedCoinList = new ArrayList<CoinData>();
        ArrayList copyList = Lists.newArrayList(this.coinList);
        while (copyList.size() > 0) {
            int highestValueIndex = 0;
            long highestValue = ((CoinData)copyList.get(0)).getValue(this);
            for (int i = 1; i < copyList.size(); ++i) {
                if (((CoinData)copyList.get(i)).getValue(this) <= highestValue) continue;
                highestValueIndex = i;
                highestValue = ((CoinData)copyList.get(i)).getValue(this);
            }
            this.sortedCoinList.add((CoinData)copyList.get(highestValueIndex));
            copyList.remove(highestValueIndex);
        }
    }

    public class_5250 getPluralName(class_1792 coinItem) {
        CoinData data = this.getData(coinItem);
        if (data != null) {
            return data.getPlural();
        }
        return MoneyUtil.getDefaultPlural(coinItem);
    }

    public CoinData getData(class_1792 coinItem) {
        for (CoinData data : this.coinList) {
            if (data.coinItem != coinItem) continue;
            return data;
        }
        return null;
    }

    @Deprecated
    public List<CoinData> getCoinList() {
        return this.coinList;
    }

    @Deprecated
    public List<CoinData> getCoinList(String chain) {
        ArrayList<CoinData> results = new ArrayList<CoinData>();
        for (int i = 0; i < this.coinList.size(); ++i) {
            CoinData data = this.coinList.get(i);
            if (!data.chain.contentEquals(chain)) continue;
            results.add(data);
        }
        return results;
    }

    public List<CoinData> getSortedCoinList() {
        return this.sortedCoinList;
    }

    public List<CoinData> getSortedCoinList(String chain) {
        ArrayList<CoinData> results = new ArrayList<CoinData>();
        for (int i = 0; i < this.sortedCoinList.size(); ++i) {
            CoinData data = this.sortedCoinList.get(i);
            if (!data.chain.contentEquals(chain)) continue;
            results.add(data);
        }
        return results;
    }

    public static class CoinDataCollector {
        List<CoinData.Builder> coinBuilderList = new ArrayList<CoinData.Builder>();

        public void addCoinBuilder(CoinData.Builder coinBuilder) {
            this.coinBuilderList.add(coinBuilder);
        }
    }
}

