/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money.bank;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.client.data.ClientBankData;
import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.common.money.bank.BankSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationData;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationSaveData;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.BankTransferNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.DepositWithdrawNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.bank.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.traders.TraderData;
import io.github.lightman314.lightmanscurrency.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class BankAccount {
    private final IMarkDirty markDirty;
    private CoinValue coinStorage = new CoinValue(new CoinValue.CoinValuePair[0]);
    private CoinValue notificationLevel = new CoinValue(new CoinValue.CoinValuePair[0]);
    private Consumer<Supplier<Notification>> notificationSender;
    private NotificationData logger = new NotificationData();
    private String ownerName = "Unknown";

    public CoinValue getCoinStorage() {
        return this.coinStorage;
    }

    public CoinValue getNotificationValue() {
        return this.notificationLevel;
    }

    public long getNotificationLevel() {
        return this.notificationLevel.getRawValue();
    }

    public void setNotificationValue(CoinValue value) {
        this.notificationLevel = value.copy();
        this.markDirty();
    }

    public void setNotificationConsumer(Consumer<Supplier<Notification>> notificationSender) {
        this.notificationSender = notificationSender;
    }

    public void pushLocalNotification(Notification notification) {
        this.logger.addNotification(notification);
        this.markDirty();
    }

    public void pushNotification(Supplier<Notification> notification) {
        this.pushLocalNotification(notification.get());
        if (this.notificationSender != null) {
            this.notificationSender.accept(notification);
        }
    }

    public static Consumer<Supplier<Notification>> generateNotificationAcceptor(UUID playerID) {
        return notification -> NotificationSaveData.PushNotification(playerID, (Notification)notification.get());
    }

    public List<Notification> getNotifications() {
        return this.logger.getNotifications();
    }

    public String getOwnersName() {
        return this.ownerName;
    }

    public void updateOwnersName(String ownerName) {
        this.ownerName = ownerName;
    }

    public class_5250 getName() {
        return class_2561.method_43469((String)"lightmanscurrency.bankaccount", (Object[])new Object[]{this.ownerName});
    }

    public void depositCoins(CoinValue depositAmount) {
        this.coinStorage = new CoinValue(this.coinStorage.getRawValue() + depositAmount.getRawValue());
        this.markDirty();
    }

    public CoinValue withdrawCoins(CoinValue withdrawAmount) {
        long oldValue = this.coinStorage.getRawValue();
        if (withdrawAmount.getRawValue() > this.coinStorage.getRawValue()) {
            withdrawAmount = this.coinStorage.copy();
        }
        if (withdrawAmount.getRawValue() <= 0L) {
            return CoinValue.EMPTY;
        }
        this.coinStorage.loadFromOldValue(this.coinStorage.getRawValue() - withdrawAmount.getRawValue());
        this.markDirty();
        if (oldValue >= this.getNotificationLevel() && this.coinStorage.getRawValue() < this.getNotificationLevel()) {
            this.pushNotification(() -> new LowBalanceNotification(this.getName(), this.notificationLevel));
        }
        return withdrawAmount;
    }

    public void LogInteraction(class_1657 player, CoinValue amount, boolean isDeposit) {
        this.pushLocalNotification(new DepositWithdrawNotification.Player(PlayerReference.of(player), this.getName(), isDeposit, amount));
        this.markDirty();
    }

    public void LogInteraction(TraderData trader, CoinValue amount, boolean isDeposit) {
        this.pushLocalNotification(new DepositWithdrawNotification.Trader(trader.getName(), this.getName(), isDeposit, amount));
        this.markDirty();
    }

    public void LogTransfer(class_1657 player, CoinValue amount, class_5250 otherAccount, boolean wasReceived) {
        this.pushLocalNotification(new BankTransferNotification(PlayerReference.of(player), amount, this.getName(), otherAccount, wasReceived));
        this.markDirty();
    }

    public static void DepositCoins(IBankAccountMenu menu, CoinValue amount) {
        if (menu == null) {
            return;
        }
        BankAccount.DepositCoins(menu.getPlayer(), menu.getCoinInput(), menu.getBankAccount(), amount);
    }

    public static void DepositCoins(class_1657 player, class_1263 coinInput, BankAccount account, CoinValue amount) {
        if (account == null) {
            return;
        }
        CoinValue actualAmount = MoneyUtil.getCoinValue(coinInput);
        if (amount.getRawValue() > actualAmount.getRawValue() || amount.getRawValue() <= 0L) {
            amount = actualAmount;
        }
        MoneyUtil.ProcessPayment(coinInput, player, amount, true);
        account.depositCoins(amount);
        account.LogInteraction(player, amount, true);
    }

    public static void WithdrawCoins(IBankAccountMenu menu, CoinValue amount) {
        if (menu == null) {
            return;
        }
        BankAccount.WithdrawCoins(menu.getPlayer(), menu.getCoinInput(), menu.getBankAccount(), amount);
    }

    public static void WithdrawCoins(class_1657 player, class_1263 coinOutput, BankAccount account, CoinValue amount) {
        if (account == null || amount.getRawValue() <= 0L) {
            return;
        }
        CoinValue withdrawnAmount = account.withdrawCoins(amount);
        List<class_1799> coins = MoneyUtil.getCoinsOfValue(withdrawnAmount);
        for (int i = 0; i < coins.size(); ++i) {
            class_1799 remainder = InventoryUtil.TryPutItemStack(coinOutput, coins.get(i));
            if (remainder.method_7960() || player.method_7270(remainder)) continue;
            InventoryUtil.dumpContents(player.method_37908(), player.method_24515(), remainder);
        }
        account.LogInteraction(player, withdrawnAmount, false);
    }

    public static class_5250 TransferCoins(IBankAccountAdvancedMenu menu, CoinValue amount, AccountReference destination) {
        return BankAccount.TransferCoins(menu.getPlayer(), menu.getBankAccount(), amount, destination.get());
    }

    public static class_5250 TransferCoins(class_1657 player, BankAccount fromAccount, CoinValue amount, BankAccount destinationAccount) {
        if (fromAccount == null) {
            return class_2561.method_43471((String)"gui.bank.transfer.error.null.from");
        }
        if (destinationAccount == null) {
            return class_2561.method_43471((String)"gui.bank.transfer.error.null.to");
        }
        if (amount.getRawValue() <= 0L) {
            return class_2561.method_43469((String)"gui.bank.transfer.error.amount", (Object[])new Object[]{amount.getString("nothing")});
        }
        if (fromAccount == destinationAccount) {
            return class_2561.method_43471((String)"gui.bank.transfer.error.same");
        }
        CoinValue withdrawnAmount = fromAccount.withdrawCoins(amount);
        if (withdrawnAmount.getRawValue() <= 0L) {
            return class_2561.method_43469((String)"gui.bank.transfer.error.nobalance", (Object[])new Object[]{amount.getString()});
        }
        destinationAccount.depositCoins(withdrawnAmount);
        fromAccount.LogTransfer(player, withdrawnAmount, destinationAccount.getName(), false);
        destinationAccount.LogTransfer(player, withdrawnAmount, fromAccount.getName(), true);
        return class_2561.method_43469((String)"gui.bank.transfer.success", (Object[])new Object[]{withdrawnAmount.getString(), destinationAccount.getName()});
    }

    public static boolean ServerGiveCoins(BankAccount account, CoinValue amount) {
        if (account == null || amount.getEntries().size() == 0) {
            return false;
        }
        account.depositCoins(amount);
        account.pushNotification(() -> new DepositWithdrawNotification.Server(account.getName(), true, amount.copy()));
        return true;
    }

    public static Pair<Boolean, CoinValue> ServerTakeCoins(BankAccount account, CoinValue amount) {
        if (account == null || amount.getEntries().size() == 0) {
            return Pair.of((Object)false, (Object)new CoinValue(new CoinValue.CoinValuePair[0]));
        }
        CoinValue taken = account.withdrawCoins(amount);
        account.pushNotification(() -> new DepositWithdrawNotification.Server(account.getName(), false, taken));
        return Pair.of((Object)true, (Object)taken);
    }

    public BankAccount() {
        this((IMarkDirty)null);
    }

    public BankAccount(IMarkDirty markDirty) {
        this.markDirty = markDirty;
    }

    public BankAccount(class_2487 compound) {
        this(null, compound);
    }

    public BankAccount(IMarkDirty markDirty, class_2487 compound) {
        this.markDirty = markDirty;
        this.coinStorage.load(compound, "CoinStorage");
        this.logger.load(compound.method_10562("AccountLogs"));
        this.ownerName = compound.method_10558("OwnerName");
        this.notificationLevel.load(compound, "NotificationLevel");
    }

    public void markDirty() {
        if (this.markDirty != null) {
            this.markDirty.markDirty();
        }
    }

    public final class_2487 save() {
        class_2487 compound = new class_2487();
        this.coinStorage.save(compound, "CoinStorage");
        compound.method_10566("AccountLogs", (class_2520)this.logger.save());
        compound.method_10582("OwnerName", this.ownerName);
        this.notificationLevel.save(compound, "NotificationLevel");
        return compound;
    }

    public static AccountReference GenerateReference(class_1657 player) {
        return BankAccount.GenerateReference(player.method_37908().field_9236, player.method_5667());
    }

    public static AccountReference GenerateReference(boolean isClient, @Nullable UUID playerID) {
        return new AccountReference(isClient, playerID);
    }

    public static AccountReference GenerateReference(boolean isClient, @Nullable PlayerReference player) {
        return BankAccount.GenerateReference(isClient, player == null ? null : player.id);
    }

    public static AccountReference GenerateReference(boolean isClient, Team team) {
        return BankAccount.GenerateReference(isClient, team.getID());
    }

    public static AccountReference GenerateReference(boolean isClient, long teamID) {
        return new AccountReference(isClient, teamID);
    }

    public static AccountReference LoadReference(boolean isClient, class_2487 compound) {
        if (compound.method_10545("PlayerID")) {
            UUID id = compound.method_25926("PlayerID");
            return BankAccount.GenerateReference(isClient, id);
        }
        if (compound.method_10545("TeamID")) {
            long id = compound.method_10537("TeamID");
            return BankAccount.GenerateReference(isClient, id);
        }
        return null;
    }

    public static AccountReference LoadReference(boolean isClient, class_2540 buffer) {
        try {
            AccountType accountType = AccountType.fromID(buffer.readInt());
            if (accountType == AccountType.Player) {
                UUID id = buffer.method_10790();
                return BankAccount.GenerateReference(isClient, id);
            }
            if (accountType == AccountType.Team) {
                long id = buffer.readLong();
                return BankAccount.GenerateReference(isClient, id);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static AccountReference LoadReference(boolean isClient, LazyPacketData data) {
        try {
            AccountType accountType = AccountType.fromID(data.getInt("BankAccountType"));
            if (accountType == AccountType.Player) {
                UUID id = data.getUUID("BankAccountPlayer");
                return BankAccount.GenerateReference(isClient, id);
            }
            if (accountType == AccountType.Team) {
                long id = data.getLong("BankAccountTeam");
                return BankAccount.GenerateReference(isClient, id);
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static interface IBankAccountMenu {
        public class_1657 getPlayer();

        public class_1263 getCoinInput();

        default public void onDepositOrWithdraw() {
        }

        public boolean isClient();

        default public AccountReference getBankAccountReference() {
            return this.isClient() ? ClientBankData.GetLastSelectedAccount() : BankSaveData.GetSelectedBankAccount(this.getPlayer());
        }

        default public BankAccount getBankAccount() {
            AccountReference reference = this.getBankAccountReference();
            return reference == null ? null : reference.get();
        }
    }

    public static interface IBankAccountAdvancedMenu
    extends IBankAccountMenu {
        public void setTransferMessage(class_2561 var1);

        default public void setNotificationLevel(CoinValue amount) {
            BankAccount account = this.getBankAccount();
            if (account != null) {
                account.setNotificationValue(amount);
            }
        }
    }

    public static class AccountReference {
        private final boolean isClient;
        public final AccountType accountType;
        public final UUID playerID;
        public final long teamID;

        private AccountReference(boolean isClient, UUID playerID) {
            this.isClient = isClient;
            this.accountType = AccountType.Player;
            this.playerID = playerID;
            this.teamID = -1L;
        }

        private AccountReference(boolean isClient, long teamID) {
            this.isClient = isClient;
            this.accountType = AccountType.Team;
            this.teamID = teamID;
            this.playerID = null;
        }

        public class_2487 save() {
            class_2487 compound = new class_2487();
            if (this.playerID != null) {
                compound.method_25927("PlayerID", this.playerID);
            }
            if (this.teamID >= 0L) {
                compound.method_10544("TeamID", this.teamID);
            }
            return compound;
        }

        public void writeToBuffer(class_2540 buffer) {
            buffer.writeInt(this.accountType.id);
            if (this.playerID != null) {
                buffer.method_10797(this.playerID);
            }
            if (this.teamID >= 0L) {
                buffer.writeLong(this.teamID);
            }
        }

        public void writeToBuffer(LazyPacketData.Builder builder) {
            builder.setInt("BankAccountType", this.accountType.id);
            builder.setUUID("BankAccountPlayer", this.playerID);
            builder.setLong("BankAccountTeam", this.teamID);
        }

        public BankAccount get() {
            switch (this.accountType) {
                case Player: {
                    return BankSaveData.GetBankAccount(this.isClient, this.playerID);
                }
                case Team: {
                    Team team = TeamSaveData.GetTeam(this.isClient, this.teamID);
                    if (team == null || !team.hasBankAccount()) break;
                    return team.getBankAccount();
                }
            }
            return null;
        }

        public boolean allowedAccess(class_1657 player) {
            switch (this.accountType) {
                case Player: {
                    return player.method_5667().equals(this.playerID) || CommandLCAdmin.isAdminPlayer(player);
                }
                case Team: {
                    Team team = TeamSaveData.GetTeam(this.isClient, this.teamID);
                    if (team == null || !team.hasBankAccount()) break;
                    return team.canAccessBankAccount(player);
                }
            }
            return false;
        }
    }

    public static interface IMarkDirty {
        public void markDirty();
    }

    public static enum AccountType {
        Player(0),
        Team(1);

        public final int id;

        private AccountType(int id) {
            this.id = id;
        }

        public static AccountType fromID(int id) {
            for (AccountType type : AccountType.values()) {
                if (type.id != id) continue;
                return type;
            }
            return Player;
        }
    }
}

