/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money.util;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandExceptionType;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.lightman314.lightmanscurrency.common.easy.EasyText;
import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.NumberUtil;
import java.util.ArrayList;
import net.minecraft.class_1792;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.NotNull;

public class CoinValueParser {
    private static final CommandExceptionType EXCEPTION_TYPE = new CommandExceptionType(){

        public int hashCode() {
            return super.hashCode();
        }
    };

    public static CoinValue parse(StringReader reader, boolean allowEmpty) throws CommandSyntaxException {
        CoinValue value = new CoinValue(new CoinValue.CoinValuePair[0]);
        StringReader inputReader = new StringReader(CoinValueParser.readStringUntil(reader, ' '));
        while (inputReader.canRead()) {
            String s1 = CoinValueParser.readStringUntil(inputReader, '-', ',');
            if (NumberUtil.IsInteger(s1)) {
                int count = NumberUtil.GetIntegerValue(s1, 1);
                String s2 = CoinValueParser.readStringUntil(inputReader, ',');
                CoinValueParser.TryParseCoin(value, inputReader, s2, count);
                continue;
            }
            CoinValueParser.TryParseCoin(value, inputReader, s1, 1);
        }
        if (!allowEmpty && !value.hasAny()) {
            throw CoinValueParser.NoValueException(reader);
        }
        return value;
    }

    public static String writeParsable(@NotNull CoinValue value) {
        StringBuilder builder = new StringBuilder();
        boolean comma = false;
        for (CoinValue.CoinValuePair pair : value.getEntries()) {
            if (comma) {
                builder.append(',');
            } else {
                comma = true;
            }
            builder.append(pair.amount).append('-').append(class_7923.field_41178.method_10221((Object)pair.coin));
        }
        return builder.toString();
    }

    private static String readStringUntil(StringReader reader, char ... t) throws CommandSyntaxException {
        ArrayList<Character> terminators = new ArrayList<Character>();
        for (char c : t) {
            terminators.add(Character.valueOf(c));
        }
        StringBuilder result = new StringBuilder();
        boolean escaped = false;
        while (reader.canRead()) {
            char c = reader.read();
            if (escaped) {
                if (terminators.contains(Character.valueOf(c)) || c == '\\') {
                    result.append(c);
                    escaped = false;
                    continue;
                }
                reader.setCursor(reader.getCursor() - 1);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidEscape().createWithContext((ImmutableStringReader)reader, (Object)String.valueOf(c));
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (terminators.contains(Character.valueOf(c))) {
                return result.toString();
            }
            result.append(c);
        }
        return result.toString();
    }

    private static void TryParseCoin(CoinValue result, StringReader reader, String coinIDString, int count) throws CommandSyntaxException {
        class_1792 coin;
        if (class_2960.method_20207((String)coinIDString)) {
            class_2960 coinID = new class_2960(coinIDString);
            coin = (class_1792)class_7923.field_41178.method_10223(coinID);
            if (!MoneyUtil.isCoin(coin, false)) {
                throw CoinValueParser.NotACoinException(coinIDString, reader);
            }
        } else {
            throw CoinValueParser.NotACoinException(coinIDString, reader);
        }
        result.addValue(coin, count);
    }

    public static CommandSyntaxException NoValueException(StringReader reader) {
        return new CommandSyntaxException(EXCEPTION_TYPE, (Message)EasyText.translatable("command.argument.coinvalue.novalue", new Object[0]), reader.getString(), reader.getCursor());
    }

    public static CommandSyntaxException NotACoinException(String item, StringReader reader) {
        return new CommandSyntaxException(EXCEPTION_TYPE, (Message)EasyText.translatable("command.argument.coinvalue.notacoin", item), reader.getString(), reader.getCursor());
    }
}

