/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.money.wallet;

import io.github.lightman314.lightmanscurrency.client.data.ClientWalletData;
import io.github.lightman314.lightmanscurrency.common.money.wallet.WalletHandler;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageSetupClientWallet;
import io.github.lightman314.lightmanscurrency.network.client.messages.data.SMessageUpdateClientWallet;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class WalletSaveData
extends class_18 {
    private final Map<UUID, WalletHandler> playerWalletData = new HashMap<UUID, WalletHandler>();
    private final List<UUID> relevantPlayers = new ArrayList<UUID>();

    private WalletSaveData() {
    }

    private WalletSaveData(class_2487 compound) {
        class_2499 walletData = compound.method_10554("PlayerWalletData", 10);
        for (int i = 0; i < walletData.size(); ++i) {
            class_2487 tag = walletData.method_10602(i);
            UUID player = tag.method_25926("Player");
            WalletHandler handler = new WalletHandler();
            handler.load(tag.method_10562("WalletData"));
            this.playerWalletData.put(player, handler);
        }
    }

    public class_2487 method_75(class_2487 compound) {
        class_2499 walletData = new class_2499();
        this.playerWalletData.forEach((player, handler) -> {
            class_2487 tag = new class_2487();
            tag.method_25927("Player", player);
            tag.method_10566("WalletData", (class_2520)handler.save());
            walletData.add((Object)tag);
        });
        compound.method_10566("PlayerWalletData", (class_2520)walletData);
        return compound;
    }

    private static WalletSaveData get() {
        class_3218 level;
        MinecraftServer server = ServerHook.getServer();
        if (server != null && (level = server.method_30002()) != null) {
            return (WalletSaveData)level.method_17983().method_17924(WalletSaveData::new, WalletSaveData::new, "lightmanscurrency_wallet_data");
        }
        return null;
    }

    @NotNull
    public static WalletHandler GetPlayerWallet(@NotNull class_1657 player) {
        if (player.method_37908().field_9236) {
            return ClientWalletData.GetPlayerWallet(player);
        }
        WalletSaveData wsd = WalletSaveData.get();
        if (wsd != null) {
            if (wsd.playerWalletData.containsKey(Objects.requireNonNull(player.method_5667()))) {
                return wsd.playerWalletData.get(player.method_5667()).updatePlayer(player);
            }
            WalletHandler newHandler = new WalletHandler();
            wsd.playerWalletData.put(player.method_5667(), newHandler);
            wsd.markWalletHandlerDirty(player.method_5667(), newHandler);
            return newHandler.updatePlayer(player);
        }
        return new WalletHandler();
    }

    private void markWalletHandlerDirty(UUID playerID, WalletHandler handler) {
        this.method_80();
        new SMessageUpdateClientWallet(playerID, handler).sendToAll();
    }

    public static void onServerTick(MinecraftServer server) {
        WalletSaveData wsd = WalletSaveData.get();
        if (wsd != null) {
            for (class_3222 player : server.method_3760().method_14571()) {
                WalletHandler handler = WalletSaveData.GetPlayerWallet((class_1657)player);
                handler.tick();
                if (!handler.isDirty()) continue;
                handler.clean();
                wsd.markWalletHandlerDirty(player.method_5667(), handler);
            }
        }
    }

    public static void OnPlayerLogin(class_3222 player, PacketSender sender) {
        WalletSaveData wsd = WalletSaveData.get();
        if (wsd == null) {
            return;
        }
        WalletSaveData.GetPlayerWallet((class_1657)player);
        class_2487 compound = new class_2487();
        class_2499 walletData = new class_2499();
        wsd.playerWalletData.forEach((playerID, handler) -> {
            class_2487 tag = new class_2487();
            tag.method_25927("Player", playerID);
            tag.method_10566("WalletData", (class_2520)handler.save());
            walletData.add((Object)tag);
        });
        compound.method_10566("PlayerWalletData", (class_2520)walletData);
        if (!wsd.relevantPlayers.contains(player.method_5667())) {
            wsd.relevantPlayers.add(player.method_5667());
        }
        new SMessageSetupClientWallet(compound).sendTo(sender);
    }

    public static void OnPlayerDisconnect(class_3222 player) {
        WalletSaveData wsd = WalletSaveData.get();
        if (wsd == null) {
            return;
        }
        WalletHandler handler = WalletSaveData.GetPlayerWallet((class_1657)player);
        if (handler.isDirty()) {
            handler.clean();
            wsd.markWalletHandlerDirty(player.method_5667(), handler);
        }
        wsd.relevantPlayers.remove(player.method_5667());
    }
}

