/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.notifications.types.trader.paygate;

import io.github.lightman314.lightmanscurrency.common.money.CoinValue;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.NotificationCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.tradedata.PaygateTradeData;
import java.util.UUID;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class PaygateNotification
extends Notification {
    public static final class_2960 TYPE = new class_2960("lightmanscurrency", "paygate_trade");
    TraderCategory traderData;
    UUID ticketID = null;
    CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);
    int duration = 0;
    String customer;

    public PaygateNotification(PaygateTradeData trade, CoinValue cost, PlayerReference customer, TraderCategory traderData) {
        this.traderData = traderData;
        this.ticketID = trade.getTicketID();
        if (trade.isTicketTrade()) {
            this.ticketID = trade.getTicketID();
        } else {
            this.cost = cost;
        }
        this.duration = trade.getDuration();
        this.customer = customer.getName(false);
    }

    public PaygateNotification(class_2487 compound) {
        this.load(compound);
    }

    @Override
    protected class_2960 getType() {
        return TYPE;
    }

    @Override
    public NotificationCategory getCategory() {
        return this.traderData;
    }

    @Override
    public class_5250 getMessage() {
        if (this.ticketID != null) {
            return class_2561.method_43469((String)"notifications.message.paygate_trade.ticket", (Object[])new Object[]{this.customer, this.ticketID.toString(), PaygateTradeData.formatDurationShort(this.duration)});
        }
        return class_2561.method_43469((String)"notifications.message.paygate_trade.coin", (Object[])new Object[]{this.customer, this.cost.getString(), PaygateTradeData.formatDurationShort(this.duration)});
    }

    @Override
    protected void saveAdditional(class_2487 compound) {
        compound.method_10566("TraderInfo", (class_2520)this.traderData.save());
        compound.method_10569("Duration", this.duration);
        if (this.ticketID != null) {
            compound.method_25927("Ticket", this.ticketID);
        } else {
            this.cost.save(compound, "Price");
        }
        compound.method_10582("Customer", this.customer);
    }

    @Override
    protected void loadAdditional(class_2487 compound) {
        this.traderData = new TraderCategory(compound.method_10562("TraderInfo"));
        this.duration = compound.method_10550("Duration");
        if (compound.method_10545("Ticket")) {
            this.ticketID = compound.method_25926("Ticket");
        } else if (compound.method_10545("Price")) {
            this.cost.load(compound, "Price");
        }
        this.customer = compound.method_10558("Customer");
    }

    @Override
    protected boolean canMerge(Notification other) {
        if (other instanceof PaygateNotification) {
            PaygateNotification pn = (PaygateNotification)other;
            if (!pn.traderData.matches(this.traderData)) {
                return false;
            }
            if (pn.ticketID == null != (this.ticketID == null)) {
                return false;
            }
            if (pn.ticketID != null && !pn.ticketID.equals(this.ticketID)) {
                return false;
            }
            if (pn.duration != this.duration) {
                return false;
            }
            if (pn.cost.getRawValue() != this.cost.getRawValue()) {
                return false;
            }
            return pn.customer.equals(this.customer);
        }
        return false;
    }
}

