/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.ownership;

import io.github.lightman314.lightmanscurrency.common.commands.CommandLCAdmin;
import io.github.lightman314.lightmanscurrency.common.ownership.PlayerReference;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.teams.TeamSaveData;
import io.github.lightman314.lightmanscurrency.common.util.IClientTracker;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public class OwnerData {
    private class_5250 customOwner = null;
    private PlayerReference playerOwner = null;
    private long teamOwner = -1L;
    private final IClientTracker parent;
    private final Consumer<OwnerData> onChanged;

    public OwnerData(IClientTracker parent, Consumer<OwnerData> onChanged) {
        this.parent = parent;
        this.onChanged = onChanged;
    }

    public boolean hasOwner() {
        return this.playerOwner != null || this.getTeam() != null || this.customOwner != null;
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        if (this.customOwner != null) {
            compound.method_10582("Custom", class_2561.class_2562.method_10867((class_2561)this.customOwner));
        }
        if (this.playerOwner != null) {
            compound.method_10566("Player", (class_2520)this.playerOwner.save());
        }
        if (this.teamOwner >= 0L) {
            compound.method_10544("Team", this.teamOwner);
        }
        return compound;
    }

    public void load(class_2487 compound) {
        this.customOwner = compound.method_10545("Custom") ? class_2561.class_2562.method_10877((String)compound.method_10558("Custom")) : null;
        this.playerOwner = compound.method_10545("Player") ? PlayerReference.load(compound.method_10562("Player")) : null;
        this.teamOwner = compound.method_10545("Team") ? compound.method_10537("Team") : -1L;
    }

    public void copyFrom(OwnerData owner) {
        this.customOwner = owner.customOwner;
        this.playerOwner = owner.playerOwner;
        this.teamOwner = owner.teamOwner;
    }

    public boolean hasPlayer() {
        return this.playerOwner != null;
    }

    public PlayerReference getPlayer() {
        return this.playerOwner;
    }

    public boolean hasTeam() {
        return this.getTeam() != null;
    }

    public Team getTeam() {
        if (this.teamOwner < 0L) {
            return null;
        }
        return TeamSaveData.GetTeam(this.parent.isClient(), this.teamOwner);
    }

    public PlayerReference getPlayerForContext() {
        Team team = this.getTeam();
        if (team != null) {
            return team.getOwner().copyWithName(team.getName());
        }
        return this.playerOwner;
    }

    public boolean isAdmin(class_1657 player) {
        return CommandLCAdmin.isAdminPlayer(player) || this.isAdmin(PlayerReference.of(player));
    }

    public boolean isAdmin(PlayerReference player) {
        if (player == null) {
            return false;
        }
        Team team = this.getTeam();
        if (team != null) {
            return team.isAdmin(player.id);
        }
        return player.is(this.playerOwner);
    }

    public boolean isMember(class_1657 player) {
        return CommandLCAdmin.isAdminPlayer(player) || this.isMember(PlayerReference.of(player));
    }

    public boolean isMember(PlayerReference player) {
        if (player == null) {
            return false;
        }
        Team team = this.getTeam();
        if (team != null) {
            return team.isMember(player.id);
        }
        return player.is(this.playerOwner);
    }

    public String getOwnerName(boolean isClient) {
        if (this.customOwner != null) {
            return this.customOwner.getString();
        }
        Team team = this.getTeam();
        if (team != null) {
            return team.getName();
        }
        if (this.playerOwner != null) {
            return this.playerOwner.getName(isClient);
        }
        return "NULL";
    }

    public void SetCustomOwner(String customOwner) {
        this.customOwner = class_2561.method_43470((String)customOwner);
    }

    public void SetCustomOwner(class_5250 customOwner) {
        this.customOwner = customOwner;
    }

    public void SetOwner(PlayerReference player) {
        this.playerOwner = player;
        this.teamOwner = -1L;
        this.onChanged.accept(this);
    }

    public void SetOwner(Team team) {
        if (team == null) {
            return;
        }
        this.teamOwner = team.getID();
        this.onChanged.accept(this);
    }
}

