/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.ownership;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import io.github.lightman314.lightmanscurrency.common.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.server.ServerHook;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public class PlayerReference {
    public final UUID id;
    private boolean forceName = false;
    private String name = "";

    public String getName(boolean isClient) {
        if (isClient || this.forceName) {
            return this.name;
        }
        String n = PlayerReference.getPlayerName(this.id);
        if (n == null || n.isBlank()) {
            return this.name;
        }
        return n;
    }

    public class_5250 getNameComponent(boolean isClient) {
        return class_2561.method_43470((String)this.getName(isClient));
    }

    private PlayerReference(UUID playerID, String name) {
        this.id = playerID;
        this.name = name;
    }

    public PlayerReference copyWithName(String name) {
        PlayerReference copy = new PlayerReference(this.id, name);
        copy.forceName = true;
        return copy;
    }

    public boolean is(PlayerReference player) {
        if (player == null) {
            return false;
        }
        return this.is(player.id);
    }

    public boolean is(GameProfile profile) {
        return this.is(profile.getId());
    }

    public boolean is(UUID entityID) {
        if (entityID == null) {
            return false;
        }
        return entityID.equals(this.id);
    }

    public boolean is(class_1297 entity) {
        if (entity == null) {
            return false;
        }
        return entity.method_5667().equals(this.id);
    }

    public boolean isOnline() {
        return this.getPlayer() != null;
    }

    public class_1657 getPlayer() {
        MinecraftServer server = ServerHook.getServer();
        if (server != null) {
            return server.method_3760().method_14602(this.id);
        }
        return null;
    }

    public class_2487 save() {
        class_2487 compound = new class_2487();
        compound.method_25927("ID", this.id);
        compound.method_10582("Name", this.getName(false));
        if (this.forceName) {
            compound.method_10556("ForcedName", this.forceName);
        }
        return compound;
    }

    public JsonObject saveAsJson() {
        JsonObject json = new JsonObject();
        json.addProperty("ID", this.id.toString());
        json.addProperty("Name", this.getName(false));
        return json;
    }

    public static PlayerReference load(class_2487 compound) {
        try {
            UUID id = compound.method_25926("ID");
            String name = compound.method_10558("Name");
            PlayerReference pr = PlayerReference.of(id, name);
            if (compound.method_10545("ForcedName")) {
                pr.forceName = compound.method_10577("ForcedName");
            }
            return pr;
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error loading PlayerReference from tag.", e);
            return null;
        }
    }

    public static PlayerReference load(JsonElement json) {
        try {
            if (json.isJsonPrimitive() && json.getAsJsonPrimitive().isString()) {
                return PlayerReference.of(false, json.getAsString());
            }
            JsonObject j = json.getAsJsonObject();
            UUID id = UUID.fromString(j.get("ID").getAsString());
            String name = j.get("Name").getAsString();
            return PlayerReference.of(id, name);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error loading PlayerReference from JsonObject", e);
            return null;
        }
    }

    public static void saveList(class_2487 compound, List<PlayerReference> playerList, String tag) {
        class_2499 list = new class_2499();
        for (int i = 0; i < playerList.size(); ++i) {
            class_2487 thisCompound = playerList.get(i).save();
            list.add((Object)thisCompound);
        }
        compound.method_10566(tag, (class_2520)list);
    }

    public static List<PlayerReference> loadList(class_2487 compound, String tag) {
        ArrayList playerList = Lists.newArrayList();
        class_2499 list = compound.method_10554(tag, 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 thisCompound = list.method_10602(i);
            PlayerReference player = PlayerReference.load(thisCompound);
            if (player == null) continue;
            playerList.add(player);
        }
        return playerList;
    }

    public static PlayerReference of(UUID playerID, String name) {
        return new PlayerReference(playerID, name);
    }

    public static PlayerReference of(GameProfile playerProfile) {
        if (playerProfile == null) {
            return null;
        }
        return PlayerReference.of(playerProfile.getId(), playerProfile.getName());
    }

    public static PlayerReference of(class_1297 entity) {
        if (entity instanceof class_1657) {
            return PlayerReference.of((class_1657)entity);
        }
        return null;
    }

    public static PlayerReference of(class_1657 player) {
        if (player == null) {
            return null;
        }
        return PlayerReference.of(player.method_7334());
    }

    public static PlayerReference of(boolean isClient, String playerName) {
        if (playerName.isBlank() || isClient) {
            return null;
        }
        UUID playerID = PlayerReference.getPlayerID(playerName);
        if (playerID != null) {
            return PlayerReference.of(playerID, playerName);
        }
        return null;
    }

    public static boolean listContains(List<PlayerReference> list, PlayerReference entry) {
        if (entry != null) {
            return PlayerReference.listContains(list, entry.id);
        }
        return false;
    }

    public static boolean listContains(List<PlayerReference> list, UUID id) {
        for (PlayerReference player : list) {
            if (!player.is(id)) continue;
            return true;
        }
        return false;
    }

    public static boolean removeFromList(List<PlayerReference> list, PlayerReference entry) {
        if (entry != null) {
            return PlayerReference.removeFromList(list, entry.id);
        }
        return false;
    }

    public static boolean removeFromList(List<PlayerReference> list, UUID id) {
        for (int i = 0; i < list.size(); ++i) {
            if (!list.get(i).is(id)) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static String getPlayerName(UUID playerID) {
        try {
            GameProfile profile;
            MinecraftServer server = ServerHook.getServer();
            if (server != null && (profile = (GameProfile)server.method_3793().method_14512(playerID).orElse(null)) != null) {
                return profile.getName();
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error getting player name.", t);
        }
        return null;
    }

    public static UUID getPlayerID(String playerName) {
        playerName = playerName.toLowerCase();
        try {
            GameProfile profile;
            MinecraftServer server = ServerHook.getServer();
            if (server != null && (profile = (GameProfile)server.method_3793().method_14515(playerName).orElse(null)) != null) {
                return profile.getId();
            }
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error getting player ID from name.", t);
        }
        return null;
    }
}

